/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelHandler;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster.client.render.RenderCustomModel;
import mchorse.blockbuster.common.OrientedBB;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster_pack.client.render.RenderCustomActor;
import mchorse.blockbuster_pack.client.render.layers.LayerBodyPart;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomMorph
extends AbstractMorph
implements IBodyPartProvider,
IAnimationProvider,
ISyncableMorph {
    public Map<ModelLimb, List<OrientedBB>> orientedBBlimbs;
    public Model model;
    protected ModelPose pose;
    public String currentPose = "";
    public boolean currentPoseOnSneak = false;
    public ResourceLocation skin;
    public ModelPose customPose = null;
    public Map<String, ResourceLocation> materials = new HashMap<String, ResourceLocation>();
    public float scale = 1.0f;
    public float scaleGui = 1.0f;
    public boolean keying;
    public PoseAnimation animation = new PoseAnimation();
    public BodyPartManager parts = new BodyPartManager();
    private String key;
    private long lastUpdate;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;

    public CustomMorph() {
        this.settings = this.settings.copy();
        this.settings.hands = true;
    }

    public void fillObbs(boolean force) {
        if (this.orientedBBlimbs == null || force) {
            this.orientedBBlimbs = new HashMap<ModelLimb, List<OrientedBB>>();
            if (this.model != null) {
                for (ModelLimb limb : this.model.limbs.values()) {
                    ArrayList<OrientedBB> newObbs = new ArrayList<OrientedBB>();
                    for (OrientedBB obb : limb.obbs) {
                        newObbs.add(obb.clone());
                    }
                    this.orientedBBlimbs.put(limb, newObbs);
                }
            }
        }
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        if (previous instanceof IMorphProvider) {
            previous = ((IMorphProvider)previous).getMorph();
        }
        if (previous instanceof CustomMorph) {
            CustomMorph custom = (CustomMorph)previous;
            ModelPose pose = custom.getCurrentPose();
            if (!this.animation.ignored) {
                this.animation.last = custom.animation.isInProgress() && pose != null ? custom.animation.calculatePose(pose, 1.0f).copy() : pose;
            } else if (custom.customPose != null) {
                this.customPose = custom.customPose;
            } else if (!custom.currentPose.isEmpty()) {
                this.customPose = null;
                this.currentPose = custom.currentPose;
            }
            if (pose != null) {
                this.animation.mergeShape(pose.shapes);
            }
        }
        this.parts.pause(previous, offset);
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public List<ShapeKey> getShapesForRendering(float partialTick) {
        if (this.model.shapes.isEmpty()) {
            return this.getCurrentPose().shapes;
        }
        if (this.animation.isInProgress()) {
            return this.animation.calculateShapes(this, partialTick);
        }
        return this.getCurrentPose().shapes;
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        if (this.model != null) {
            return this.model.name;
        }
        return super.getSubclassDisplayName();
    }

    public void changeModel(String model) {
        if (Blockbuster.proxy.models.models.get(model) == null) {
            return;
        }
        this.name = "blockbuster." + model;
        this.key = null;
        this.model = Blockbuster.proxy.models.models.get(model);
        this.fillObbs(true);
    }

    public BodyPartManager getBodyPart() {
        return this.parts;
    }

    public ModelPose getPose(EntityLivingBase target, float partialTicks) {
        return this.getPose(target, false, partialTicks);
    }

    public ModelPose getPose(EntityLivingBase target, boolean ignoreCustom, float partialTicks) {
        ModelPose pose = this.getCurrentPose(target, ignoreCustom);
        if (this.animation.isInProgress() && pose != null) {
            return this.animation.calculatePose(pose, partialTicks);
        }
        return pose;
    }

    private ModelPose getCurrentPose(EntityLivingBase target, boolean ignoreCustom) {
        if (this.customPose != null && !ignoreCustom && (this.currentPoseOnSneak && target.func_70093_af() || !this.currentPoseOnSneak)) {
            return this.customPose;
        }
        String poseName = EntityUtils.getPose((EntityLivingBase)target, (String)this.currentPose, (boolean)this.currentPoseOnSneak);
        if (target instanceof EntityActor) {
            poseName = ((EntityActor)target).isMounted ? "riding" : poseName;
        }
        return this.model == null ? null : this.model.getPose(poseName);
    }

    public ModelPose getCurrentPose() {
        return this.customPose != null ? this.customPose : (this.model == null ? null : this.model.getPose(this.currentPose));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.name.replaceAll("^blockbuster\\.", "");
        }
        return this.key;
    }

    public void updateModel() {
        this.updateModel(false);
    }

    public void updateModel(boolean force) {
        if (this.lastUpdate < ModelHandler.lastUpdate || force) {
            this.lastUpdate = ModelHandler.lastUpdate;
            this.model = Blockbuster.proxy.models.models.get(this.getKey());
            this.fillObbs(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        if (this.model != null) {
            this.fillObbs(false);
        }
        this.updateModel();
        ModelCustom model = ModelCustom.MODELS.get(this.getKey());
        if (model != null && this.model != null) {
            Model data = model.model;
            if (data != null && (data.defaultTexture != null || data.providesMtl || this.skin != null)) {
                this.parts.initBodyParts();
                model.materials = this.materials;
                model.pose = this.getPose((EntityLivingBase)player, Minecraft.func_71410_x().func_184121_ak());
                model.field_78095_p = 0.0f;
                ResourceLocation texture = this.skin == null ? data.defaultTexture : this.skin;
                RenderCustomModel.bindLastTexture(texture);
                this.drawModel(model, player, x, y, scale * data.scaleGui * this.scaleGui, alpha);
            }
        } else {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int width = font.func_78256_a(this.name);
            String error = I18n.func_135052_a((String)"blockbuster.morph_error", (Object[])new Object[0]);
            font.func_175063_a(error, (float)(x - font.func_78256_a(error) / 2), (float)(y - (int)((double)font.field_78288_b * 2.5)), 0xFF2222);
            font.func_175063_a(this.name, (float)(x - width / 2), (float)(y - font.field_78288_b), 0xFFFFFF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawModel(ModelCustom model, EntityPlayer player, int x, int y, float scale, float alpha) {
        float factor = 0.0625f;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)45.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.501f, (float)0.0f);
        GlStateManager.func_179141_d();
        model.func_78086_a((EntityLivingBase)player, 0.0f, 0.0f, 0.0f);
        model.func_78087_a(0.0f, 0.0f, player.field_70173_aa, 0.0f, 0.0f, factor, (Entity)player);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        model.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, factor);
        LayerBodyPart.renderBodyParts((EntityLivingBase)player, this, model, 0.0f, factor);
        GlStateManager.func_179097_i();
        GlStateManager.func_179101_C();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        ResourceLocation location;
        this.updateModel();
        RenderCustomActor renderer = ClientProxy.actorRenderer;
        renderer.current = this;
        renderer.setupModel((EntityLivingBase)player, Minecraft.func_71410_x().func_184121_ak());
        if (renderer.func_177087_b() == null) {
            return false;
        }
        Object object = this.skin != null ? this.skin : (location = this.model != null ? this.model.defaultTexture : null);
        if (location != null) {
            renderer.func_110776_a(location);
        }
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            renderer.renderRightArm(player);
        } else {
            renderer.renderLeftArm(player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.model != null) {
            this.fillObbs(false);
        }
        this.updateModel();
        if (this.model != null) {
            this.parts.initBodyParts();
            RenderCustomActor render = ClientProxy.actorRenderer;
            render.current = this;
            render.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        } else {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            RenderManager manager = mc.func_175598_ae();
            EntityRenderer.func_189692_a((FontRenderer)font, (String)this.getKey(), (float)((float)x), (float)((float)y + 1.0f), (float)((float)z), (int)0, (float)manager.field_78735_i, (float)manager.field_78732_j, (mc.field_71474_y.field_74320_O == 2 ? 1 : 0) != 0, (boolean)entity.func_70093_af());
        }
    }

    public void update(EntityLivingBase target) {
        this.updateModel();
        this.animation.update();
        this.parts.updateBodyLimbs((AbstractMorph)this, target);
        super.update(target);
        if (target.field_70170_p.field_72995_K) {
            this.updateCapeVariables(target);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateCapeVariables(EntityLivingBase target) {
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        double dX = target.field_70165_t - this.capeX;
        double dY = target.field_70163_u - this.capeY;
        double dZ = target.field_70161_v - this.capeZ;
        double multiplier = 0.25;
        if (Math.abs(dX) > 10.0) {
            this.prevCapeX = this.capeX = target.field_70165_t;
        }
        if (Math.abs(dY) > 10.0) {
            this.prevCapeY = this.capeY = target.field_70163_u;
        }
        if (Math.abs(dZ) > 10.0) {
            this.prevCapeZ = this.capeZ = target.field_70161_v;
        }
        this.capeX += dX * multiplier;
        this.capeY += dY * multiplier;
        this.capeZ += dZ * multiplier;
    }

    protected void updateUserHitbox(EntityLivingBase target) {
        this.pose = this.getPose(target, 0.0f);
        if (this.pose != null) {
            float[] pose = this.pose.size;
            this.updateSize(target, pose[0] * this.scale, pose[1] * this.scale);
        }
    }

    public float getWidth(EntityLivingBase target) {
        return (this.pose != null ? this.pose.size[0] : 0.6f) * this.scale;
    }

    public float getHeight(EntityLivingBase target) {
        return (this.pose != null ? this.pose.size[1] : 1.8f) * this.scale;
    }

    public boolean equals(Object object) {
        boolean result = super.equals(object);
        if (object instanceof CustomMorph) {
            CustomMorph morph = (CustomMorph)((Object)object);
            result = result && Objects.equal((Object)this.currentPose, (Object)morph.currentPose);
            result = result && Objects.equal((Object)this.skin, (Object)morph.skin);
            result = result && Objects.equal((Object)this.customPose, (Object)morph.customPose);
            result = result && this.currentPoseOnSneak == morph.currentPoseOnSneak;
            result = result && this.scale == morph.scale;
            result = result && this.scaleGui == morph.scaleGui;
            result = result && this.materials.equals(morph.materials);
            result = result && this.parts.equals((Object)morph.parts);
            result = result && this.keying == morph.keying;
            result = result && this.animation.equals((Object)morph.animation);
            return result;
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof CustomMorph) {
            CustomMorph custom = (CustomMorph)morph;
            this.mergeBasic(morph);
            if (!custom.animation.ignored) {
                ModelPose pose = this.getCurrentPose();
                this.animation.last = this.animation.isInProgress() && pose != null ? this.animation.calculatePose(pose, 1.0f).copy() : pose;
                this.currentPose = custom.currentPose;
                this.customPose = custom.customPose == null ? null : custom.customPose.copy();
                this.animation.merge(custom.animation);
                if (pose != null) {
                    this.animation.mergeShape(pose.shapes);
                }
            } else {
                this.animation.ignored = true;
            }
            this.key = null;
            this.name = custom.name;
            this.skin = RLUtils.clone((ResourceLocation)custom.skin);
            this.currentPoseOnSneak = custom.currentPoseOnSneak;
            this.scale = custom.scale;
            this.scaleGui = custom.scaleGui;
            this.materials.clear();
            for (Map.Entry<String, ResourceLocation> entry : custom.materials.entrySet()) {
                this.materials.put(entry.getKey(), RLUtils.clone((ResourceLocation)entry.getValue()));
            }
            this.parts.merge(custom.parts);
            this.model = custom.model;
            return true;
        }
        return super.canMerge(morph);
    }

    public void afterMerge(AbstractMorph morph) {
        super.afterMerge(morph);
        if (!(morph instanceof IMorphProvider)) {
            return;
        }
        AbstractMorph destination = ((IMorphProvider)morph).getMorph();
        if (destination instanceof IBodyPartProvider) {
            this.recursiveAfterMerge(this, (IBodyPartProvider)destination);
        }
        if (destination instanceof CustomMorph) {
            this.copyPoseForAnimation(this, (CustomMorph)destination);
        }
    }

    private void recursiveAfterMerge(IBodyPartProvider target, IBodyPartProvider destination) {
        int c = target.getBodyPart().parts.size();
        for (int i = 0; i < c && i < destination.getBodyPart().parts.size(); ++i) {
            AbstractMorph a = ((BodyPart)target.getBodyPart().parts.get((int)i)).morph.get();
            AbstractMorph b = ((BodyPart)destination.getBodyPart().parts.get((int)i)).morph.get();
            if (a instanceof IBodyPartProvider && b instanceof IBodyPartProvider) {
                this.recursiveAfterMerge((IBodyPartProvider)a, (IBodyPartProvider)b);
            }
            if (!(a instanceof CustomMorph) || !(b instanceof CustomMorph)) continue;
            this.copyPoseForAnimation((CustomMorph)a, (CustomMorph)b);
        }
    }

    private void copyPoseForAnimation(CustomMorph target, CustomMorph destination) {
        ModelPose pose = destination.getCurrentPose();
        target.animation.progress = 0;
        target.animation.last = destination.animation.isInProgress() && pose != null ? destination.animation.calculatePose(pose, 1.0f).copy() : pose;
    }

    public void reset() {
        super.reset();
        this.key = null;
        this.parts.reset();
        this.animation.reset();
        this.scaleGui = 1.0f;
        this.scale = 1.0f;
    }

    public AbstractMorph create() {
        return new CustomMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof CustomMorph) {
            CustomMorph morph = (CustomMorph)from;
            this.skin = RLUtils.clone((ResourceLocation)morph.skin);
            this.currentPose = morph.currentPose;
            this.currentPoseOnSneak = morph.currentPoseOnSneak;
            this.scale = morph.scale;
            this.scaleGui = morph.scaleGui;
            this.keying = morph.keying;
            if (morph.customPose != null) {
                this.customPose = morph.customPose.copy();
            }
            if (!morph.materials.isEmpty()) {
                this.materials.clear();
                for (Map.Entry<String, ResourceLocation> entry : morph.materials.entrySet()) {
                    this.materials.put(entry.getKey(), RLUtils.clone((ResourceLocation)entry.getValue()));
                }
            }
            this.model = morph.model;
            this.parts.copy(morph.parts);
            this.animation.copy(morph.animation);
        }
    }

    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound animation;
        NBTTagList bodyParts;
        super.toNBT(tag);
        if (this.skin != null) {
            tag.func_74782_a("Skin", RLUtils.writeNbt((ResourceLocation)this.skin));
        }
        if (!this.currentPose.isEmpty()) {
            tag.func_74778_a("Pose", this.currentPose);
        }
        if (this.currentPoseOnSneak) {
            tag.func_74757_a("Sneak", this.currentPoseOnSneak);
        }
        if (this.scale != 1.0f) {
            tag.func_74776_a("Scale", this.scale);
        }
        if (this.scaleGui != 1.0f) {
            tag.func_74776_a("ScaleGUI", this.scaleGui);
        }
        if (this.keying) {
            tag.func_74757_a("Keying", this.keying);
        }
        if (this.customPose != null) {
            tag.func_74782_a("CustomPose", (NBTBase)this.customPose.toNBT(new NBTTagCompound()));
        }
        if (!this.materials.isEmpty()) {
            NBTTagCompound materials = new NBTTagCompound();
            for (Map.Entry<String, ResourceLocation> entry : this.materials.entrySet()) {
                materials.func_74782_a(entry.getKey(), RLUtils.writeNbt((ResourceLocation)entry.getValue()));
            }
            tag.func_74782_a("Materials", (NBTBase)materials);
        }
        if ((bodyParts = this.parts.toNBT()) != null) {
            tag.func_74782_a("BodyParts", (NBTBase)bodyParts);
        }
        if (!(animation = this.animation.toNBT()).func_82582_d()) {
            tag.func_74782_a("Animation", (NBTBase)animation);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        String name = this.name;
        super.fromNBT(tag);
        if (!name.equals(this.name)) {
            Model model = Blockbuster.proxy.models.models.get(this.getKey());
            Model model2 = this.model = model == null ? this.model : model;
        }
        if (tag.func_74764_b("Skin")) {
            this.skin = RLUtils.create((NBTBase)tag.func_74781_a("Skin"));
        }
        this.currentPose = tag.func_74779_i("Pose");
        this.currentPoseOnSneak = tag.func_74767_n("Sneak");
        if (tag.func_150297_b("Scale", 99)) {
            this.scale = tag.func_74760_g("Scale");
        }
        if (tag.func_150297_b("ScaleGUI", 99)) {
            this.scaleGui = tag.func_74760_g("ScaleGUI");
        }
        if (tag.func_74764_b("Keying")) {
            this.keying = tag.func_74767_n("Keying");
        }
        if (tag.func_150297_b("CustomPose", 10)) {
            this.customPose = new ModelPose();
            this.customPose.fromNBT(tag.func_74775_l("CustomPose"));
        }
        if (tag.func_150297_b("Materials", 10)) {
            NBTTagCompound materials = tag.func_74775_l("Materials");
            this.materials.clear();
            for (String key : materials.func_150296_c()) {
                this.materials.put(key, RLUtils.create((NBTBase)materials.func_74781_a(key)));
            }
        }
        if (tag.func_150297_b("BodyParts", 9)) {
            this.parts.fromNBT(tag.func_150295_c("BodyParts", 10));
        }
        if (tag.func_74764_b("Animation")) {
            this.animation.fromNBT(tag.func_74775_l("Animation"));
        }
    }

    public static class PoseAnimation
    extends Animation {
        public List<ShapeKey> lastShapes = new ArrayList<ShapeKey>();
        public ModelPose last;
        public ModelPose pose = new ModelPose();
        private List<ShapeKey> temporaryShapes = new ArrayList<ShapeKey>();

        public void merge(Animation animation) {
            super.merge(animation);
            this.pose.limbs.clear();
        }

        public void mergeShape(List<ShapeKey> shapes) {
            this.lastShapes.clear();
            this.lastShapes.addAll(shapes);
        }

        public List<ShapeKey> calculateShapes(CustomMorph morph, float partialTicks) {
            ShapeKey last;
            float factor = this.getFactor(partialTicks);
            this.temporaryShapes.clear();
            for (ShapeKey key : morph.getCurrentPose().shapes) {
                last = null;
                for (ShapeKey previous : this.lastShapes) {
                    if (!previous.name.equals(key.name)) continue;
                    last = previous;
                    break;
                }
                this.temporaryShapes.add(new ShapeKey(key.name, this.interp.interpolate(last == null ? 0.0f : last.value, key.value, factor), key.relative));
            }
            for (ShapeKey key : this.lastShapes) {
                last = null;
                for (ShapeKey previous : this.temporaryShapes) {
                    if (!previous.name.equals(key.name)) continue;
                    last = previous;
                    break;
                }
                if (last != null) continue;
                this.temporaryShapes.add(new ShapeKey(key.name, this.interp.interpolate(key.value, 0.0f, factor), key.relative));
            }
            return this.temporaryShapes;
        }

        public boolean isInProgress() {
            return super.isInProgress() && this.last != null;
        }

        public ModelPose calculatePose(ModelPose current, float partialTicks) {
            float factor = this.getFactor(partialTicks);
            for (Map.Entry<String, ModelTransform> entry : current.limbs.entrySet()) {
                String key = entry.getKey();
                ModelTransform trans = this.pose.limbs.get(key);
                ModelTransform last = this.last.limbs.get(key);
                if (last == null) continue;
                if (trans == null) {
                    trans = new ModelTransform();
                    this.pose.limbs.put(key, trans);
                }
                trans.interpolate(last, entry.getValue(), factor, this.interp);
            }
            for (int i = 0; i < this.pose.size.length; ++i) {
                this.pose.size[i] = this.interp.interpolate(this.last.size[i], current.size[i], factor);
            }
            return this.pose;
        }
    }
}

