/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.ArrayList;
import java.util.Objects;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.recording.PacketRequestRecording;
import mchorse.blockbuster.network.common.recording.actions.PacketRequestAction;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.mclib.client.gui.framework.elements.utils.GuiInventoryElement;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RecordMorph
extends AbstractMorph
implements ISyncableMorph {
    public static final ItemStack ICON = new ItemStack(Items.field_151096_cd);
    @SideOnly(value=Side.CLIENT)
    public EntityActor actor;
    public boolean reload;
    public AbstractMorph initial;
    public String record = "";
    public boolean loop = true;
    public int randomSkip;
    private boolean initiate;
    private Animation animation = new Animation();
    private Replay replay = new Replay();

    public RecordMorph() {
        this.name = "blockbuster.record";
    }

    public void setRecord(String record) {
        this.record = record;
        this.reload = true;
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        this.replay.morph = this.initial;
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    @SideOnly(value=Side.CLIENT)
    private void previewActor(Record record) {
        int tick = this.animation.progress % record.getLength();
        Frame frame = record.getFrame(tick);
        if (frame == null) {
            return;
        }
        frame.apply((EntityLivingBase)this.actor, true);
        if (frame.hasBodyYaw) {
            this.actor.field_70761_aq = frame.bodyYaw;
        }
        this.actor.field_70169_q = this.actor.field_70165_t;
        this.actor.field_70167_r = this.actor.field_70163_u;
        this.actor.field_70166_s = this.actor.field_70161_v;
        this.actor.field_70126_B = this.actor.field_70177_z;
        this.actor.field_70127_C = this.actor.field_70125_A;
        this.actor.field_70758_at = this.actor.field_70759_as;
        this.actor.field_70760_ar = this.actor.field_70761_aq;
        this.actor.playback.tick = tick;
        this.actor.playback.playing = false;
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return I18n.func_135052_a((String)"blockbuster.morph.record", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        this.initiateActor(player.field_70170_p);
        float record = (float)Math.ceil(scale / 16.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + 1), (float)(y - 9), (float)0.0f);
        GlStateManager.func_179152_a((float)record, (float)record, (float)1.0f);
        GuiInventoryElement.drawItemStack((ItemStack)ICON, (int)-8, (int)-8, (int)0, null);
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        if (this.initial != null) {
            this.initial.renderOnScreen(player, x, y, scale, alpha);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.initiateActor(entity.field_70170_p);
        AbstractMorph morph = this.actor.getMorph();
        if (morph != null) {
            Frame first;
            if (this.actor.playback.record != null && (first = this.actor.playback.record.getFrame(0)) != null) {
                if (!this.initiate) {
                    this.actor.field_70169_q = this.actor.field_70165_t = first.x;
                    this.actor.field_70167_r = this.actor.field_70163_u = first.y;
                    this.actor.field_70166_s = this.actor.field_70161_v = first.z;
                    this.initiate = true;
                }
                x += this.actor.field_70169_q + (this.actor.field_70165_t - this.actor.field_70169_q) * (double)partialTicks - first.x;
                y += this.actor.field_70167_r + (this.actor.field_70163_u - this.actor.field_70167_r) * (double)partialTicks - first.y;
                z += this.actor.field_70166_s + (this.actor.field_70161_v - this.actor.field_70166_s) * (double)partialTicks - first.z;
            }
            morph.render((EntityLivingBase)this.actor, x, y, z, entityYaw, partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initiateActor(World world) {
        if (this.reload) {
            this.actor = null;
            this.initiate = false;
            this.reload = false;
        }
        if (this.actor == null) {
            this.actor = new EntityActor(world);
            this.actor.morph.setDirect(MorphUtils.copy((AbstractMorph)this.initial));
            this.actor.playback = new RecordPlayer(null, Mode.FRAMES, (EntityLivingBase)this.actor);
            this.actor.playback.tick = (int)((double)this.randomSkip * Math.random());
            this.actor.manual = true;
            Record record = ClientProxy.manager.getClient(this.record);
            if (record == null && !this.record.isEmpty()) {
                Dispatcher.sendToServer(new PacketRequestRecording(this.record));
            } else if (this.isPaused() && record != null) {
                this.previewActor(record);
                record.applyPreviousMorph((EntityLivingBase)this.actor, this.replay, this.animation.progress, Record.MorphType.PAUSE);
            }
        }
    }

    public void update(EntityLivingBase target) {
        super.update(target);
        if (target.field_70170_p.field_72995_K) {
            this.updateActor();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateActor() {
        if (this.actor != null) {
            RecordPlayer player = this.actor.playback;
            if (player.record == null) {
                player.record = ClientProxy.manager.getClient(this.record);
                if (player.record != null) {
                    this.previewActor(player.record);
                }
                if (player.record != null && player.record.actions.isEmpty()) {
                    player.record.actions.add(new ArrayList());
                    Dispatcher.sendToServer(new PacketRequestAction(this.record, false));
                }
            } else {
                if (this.isPaused() && this.actor.playback.record != null) {
                    this.previewActor(this.actor.playback.record);
                    this.actor.playback.record.applyPreviousMorph((EntityLivingBase)this.actor, this.replay, this.animation.progress, Record.MorphType.PAUSE);
                } else {
                    this.actor.func_70071_h_();
                }
                if (!this.isPaused() && this.actor.playback.isFinished() && this.loop) {
                    this.actor.playback.record.reset((EntityLivingBase)this.actor);
                    this.actor.playback.tick = (int)((double)this.randomSkip * Math.random());
                    this.actor.playback.record.applyAction(0, (EntityLivingBase)this.actor, true);
                    this.actor.morph.setDirect(MorphUtils.copy((AbstractMorph)this.initial));
                }
            }
        }
    }

    public AbstractMorph create() {
        return new RecordMorph();
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof RecordMorph) {
            RecordMorph recmorph = (RecordMorph)morph;
            this.mergeBasic(morph);
            if (!recmorph.animation.ignored) {
                this.animation.merge(recmorph.animation);
            }
            if (!recmorph.record.equals(this.record)) {
                this.copy(recmorph);
            }
            return true;
        }
        return super.canMerge(morph);
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof RecordMorph) {
            RecordMorph morph = (RecordMorph)from;
            this.record = morph.record;
            this.loop = morph.loop;
            this.randomSkip = morph.randomSkip;
            this.initial = MorphUtils.copy((AbstractMorph)morph.initial);
        }
    }

    public float getWidth(EntityLivingBase target) {
        return 0.6f;
    }

    public float getHeight(EntityLivingBase target) {
        return 1.8f;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof RecordMorph) {
            RecordMorph record = (RecordMorph)((Object)obj);
            result = result && Objects.equals(record.record, this.record);
            result = result && Objects.equals(record.initial, this.initial);
            result = result && record.loop == this.loop;
            result = result && record.randomSkip == this.randomSkip;
        }
        return result;
    }

    public void reset() {
        super.reset();
        this.initial = null;
        this.record = "";
        this.reload = true;
        this.loop = true;
        this.randomSkip = 0;
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_150297_b("Initial", 10)) {
            this.initial = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Initial"));
        }
        if (tag.func_150297_b("Record", 8)) {
            this.record = tag.func_74779_i("Record");
        }
        if (tag.func_150297_b("Loop", 99)) {
            this.loop = tag.func_74767_n("Loop");
        }
        if (tag.func_150297_b("RandomDelay", 99)) {
            this.randomSkip = tag.func_74762_e("RandomDelay");
        }
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.initial != null) {
            NBTTagCompound morph = new NBTTagCompound();
            this.initial.toNBT(morph);
            tag.func_74782_a("Initial", (NBTBase)morph);
        }
        if (!this.record.isEmpty()) {
            tag.func_74778_a("Record", this.record);
        }
        if (!this.loop) {
            tag.func_74757_a("Loop", this.loop);
        }
        if (this.randomSkip != 0) {
            tag.func_74768_a("RandomDelay", this.randomSkip);
        }
    }
}

