/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SequencerMorph
extends AbstractMorph
implements IMorphProvider,
ISyncableMorph {
    public List<SequenceEntry> morphs = new ArrayList<SequenceEntry>();
    public Morph currentMorph = new Morph();
    public int current;
    public int timer;
    public float duration;
    public boolean reverse;
    public boolean isRandom;
    public boolean isTrulyRandom;
    private Animation animation = new Animation();
    private Random random = new Random();

    public SequencerMorph() {
        this.name = "sequencer";
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        FoundMorph found = this.getMorphAt(offset);
        if (found == null) {
            return;
        }
        AbstractMorph morph = MorphUtils.copy((AbstractMorph)found.getCurrentMorph());
        if (found.previous != null) {
            AbstractMorph prevMorph = MorphUtils.copy((AbstractMorph)found.getPreviousMorph());
            MorphUtils.pause((AbstractMorph)prevMorph, (AbstractMorph)previous, (int)((int)found.getPreviousDuration()));
            found.applyPrevious(prevMorph);
            previous = prevMorph;
        }
        MorphUtils.pause((AbstractMorph)morph, (AbstractMorph)previous, (int)((int)((float)offset - found.lastDuration)));
        found.applyCurrent(morph);
        this.currentMorph.setDirect(morph);
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public AbstractMorph getMorph() {
        return this.currentMorph.get();
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return I18n.func_135052_a((String)"blockbuster.morph.sequencer", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        AbstractMorph morph;
        this.updateCycle();
        if (this.morphs.isEmpty()) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            BBIcons.CHICKEN.render(x - 8, y - 20);
        }
        if ((morph = this.currentMorph.get()) != null) {
            morph.renderOnScreen(player, x, y, scale, alpha);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        AbstractMorph morph;
        if (!this.isPaused()) {
            this.updateMorph((float)this.timer + partialTicks);
        }
        if ((morph = this.currentMorph.get()) != null) {
            morph.render(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        AbstractMorph morph = this.currentMorph.get();
        if (morph != null) {
            return morph.renderHand(player, hand);
        }
        return false;
    }

    private Random getRandomSeed(float duration) {
        if (this.isTrulyRandom) {
            this.random.setSeed(System.nanoTime());
        } else {
            this.random.setSeed((long)(duration * 100000.0f));
        }
        return this.random;
    }

    public AbstractMorph getRandom() {
        if (this.morphs.isEmpty()) {
            return null;
        }
        double factor = this.isTrulyRandom ? Math.random() : this.random.nextDouble();
        return this.get((int)(factor * (double)this.morphs.size()));
    }

    public int getRandomIndex(float duration) {
        return (int)(this.getRandomSeed(duration * 2.0f + 5.0f).nextFloat() * (float)this.morphs.size());
    }

    public AbstractMorph get(int index) {
        if (index >= this.morphs.size() || index < 0) {
            return null;
        }
        return this.morphs.get((int)index).morph;
    }

    public FoundMorph getMorphAt(int tick) {
        if (this.morphs.isEmpty() || tick < 0) {
            return null;
        }
        float duration = this.getDuration();
        int size = this.morphs.size();
        if (duration <= 0.0f) {
            return new FoundMorph(this.morphs.get(size - 1), size == 1 ? null : this.morphs.get(size - 2), 0.0f, 0.0f, 0.0f);
        }
        SequenceEntry entry = null;
        SequenceEntry lastEntry = null;
        int i = this.reverse ? size - 1 : 0;
        duration = 0.0f;
        if (this.isRandom) {
            i = this.getRandomIndex(duration);
        }
        float lastDuration = 0.0f;
        float prevLastDuration = 0.0f;
        while (duration <= (float)tick) {
            prevLastDuration = lastDuration;
            lastDuration = duration;
            lastEntry = entry;
            entry = this.morphs.get(i);
            i = this.isRandom ? this.getRandomIndex(duration) : MathUtils.cycler((int)(i + (this.reverse ? -1 : 1)), (int)0, (int)(size - 1));
            duration += entry.getDuration(this.getRandomSeed(duration));
        }
        return entry == null ? null : new FoundMorph(entry, lastEntry, duration, lastDuration, prevLastDuration);
    }

    public float getDuration() {
        float duration = 0.0f;
        for (SequenceEntry entry : this.morphs) {
            duration += entry.getDuration(this.getRandomSeed(duration));
        }
        return duration;
    }

    public void update(EntityLivingBase target) {
        this.updateCycle();
        AbstractMorph morph = this.currentMorph.get();
        if (morph != null) {
            morph.update(target);
        }
    }

    protected void updateCycle() {
        if (this.isPaused()) {
            return;
        }
        this.updateMorph(this.timer);
        ++this.timer;
    }

    protected void updateMorph(float timer) {
        if (timer >= this.duration) {
            int size = this.morphs.size();
            this.current = this.isRandom ? this.getRandomIndex(this.duration) : MathUtils.cycler((int)(this.current + (this.reverse ? -1 : 1)), (int)0, (int)(size - 1));
            if (this.current >= 0 && this.current < size) {
                SequenceEntry entry = this.morphs.get(this.current);
                AbstractMorph morph = MorphUtils.copy((AbstractMorph)entry.morph);
                float duration = entry.getDuration(this.getRandomSeed(this.duration));
                if (entry.setDuration && morph instanceof IAnimationProvider) {
                    ((IAnimationProvider)morph).getAnimation().duration = (int)duration;
                }
                this.currentMorph.set(morph);
                this.duration += duration;
            }
            if (!this.morphs.isEmpty()) {
                boolean durationZero;
                boolean bl = durationZero = this.morphs.get((int)this.current).duration == 0.0f;
                if ((float)this.timer >= this.duration && !durationZero) {
                    this.updateMorph(this.timer);
                }
            }
        }
    }

    public AbstractMorph create() {
        return new SequencerMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof SequencerMorph) {
            SequencerMorph morph = (SequencerMorph)from;
            for (SequenceEntry entry : morph.morphs) {
                this.morphs.add(entry.clone());
            }
            this.reverse = morph.reverse;
            this.isRandom = morph.isRandom;
            this.isTrulyRandom = morph.isTrulyRandom;
            this.currentMorph.copy(morph.currentMorph);
            this.timer = morph.timer;
            this.current = morph.current;
            this.duration = morph.duration;
        }
    }

    public float getWidth(EntityLivingBase target) {
        AbstractMorph morph = this.currentMorph.get();
        return morph == null ? 0.0f : morph.getWidth(target);
    }

    public float getHeight(EntityLivingBase target) {
        AbstractMorph morph = this.currentMorph.get();
        return morph == null ? 0.0f : morph.getHeight(target);
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof SequencerMorph) {
            SequencerMorph seq = (SequencerMorph)((Object)obj);
            result = result && Objects.equals(this.morphs, seq.morphs);
            result = result && this.reverse == seq.reverse;
            result = result && this.isRandom == seq.isRandom;
            result = result && this.isTrulyRandom == seq.isTrulyRandom;
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof SequencerMorph) {
            SequencerMorph sequencer = (SequencerMorph)morph;
            if (!sequencer.morphs.equals(this.morphs)) {
                this.mergeBasic(morph);
                this.morphs.clear();
                for (SequenceEntry entry : sequencer.morphs) {
                    this.morphs.add(entry.clone());
                }
                this.current = -1;
                this.timer = 0;
                this.duration = this.morphs.isEmpty() ? 0.0f : this.morphs.get((int)0).duration;
                this.currentMorph.copy(sequencer.currentMorph);
                this.reverse = sequencer.reverse;
                this.isRandom = sequencer.isRandom;
                return true;
            }
        }
        return super.canMerge(morph);
    }

    public void afterMerge(AbstractMorph morph) {
        super.afterMerge(morph);
        this.currentMorph.setDirect(morph);
        this.current = -1;
        this.duration = 0.0f;
        this.timer = 0;
    }

    public void reset() {
        super.reset();
        this.current = 0;
        this.timer = 0;
        this.duration = 0.0f;
        this.reverse = false;
        this.currentMorph.setDirect(null);
        this.morphs.clear();
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.reverse) {
            tag.func_74757_a("Reverse", this.reverse);
        }
        if (this.isRandom) {
            tag.func_74757_a("Random", this.isRandom);
        }
        if (this.isTrulyRandom) {
            tag.func_74757_a("TrulyRandom", this.isTrulyRandom);
        }
        if (!this.morphs.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (SequenceEntry entry : this.morphs) {
                list.func_74742_a((NBTBase)entry.toNBT());
            }
            tag.func_74782_a("List", (NBTBase)list);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Reverse")) {
            this.reverse = tag.func_74767_n("Reverse");
        }
        if (tag.func_74764_b("Random")) {
            this.isRandom = tag.func_74767_n("Random");
        }
        if (tag.func_74764_b("TrulyRandom")) {
            this.isTrulyRandom = tag.func_74767_n("TrulyRandom");
        }
        if (tag.func_150297_b("List", 9)) {
            NBTTagList list = tag.func_150295_c("List", 10);
            int c = list.func_74745_c();
            for (int i = 0; i < c; ++i) {
                SequenceEntry entry = new SequenceEntry();
                entry.fromNBT(list.func_150305_b(i));
                this.morphs.add(entry);
            }
            this.current = -1;
            this.duration = 0.0f;
            this.timer = 0;
            this.updateMorph(0.0f);
        }
    }

    public static class FoundMorph {
        public SequenceEntry current;
        public SequenceEntry previous;
        public float totalDuration;
        public float lastDuration;
        public float prevLastDuration;

        public FoundMorph(SequenceEntry current, SequenceEntry previous, float totalDuration, float lastDuration, float prevLastDuration) {
            this.current = current;
            this.previous = previous;
            this.totalDuration = totalDuration;
            this.lastDuration = lastDuration;
            this.prevLastDuration = prevLastDuration;
        }

        public AbstractMorph getCurrentMorph() {
            return this.current == null ? null : this.current.morph;
        }

        public AbstractMorph getPreviousMorph() {
            return this.previous == null ? null : this.previous.morph;
        }

        public float getCurrentDuration() {
            return this.totalDuration - this.lastDuration;
        }

        public float getPreviousDuration() {
            return this.lastDuration - this.prevLastDuration;
        }

        public void applyCurrent(AbstractMorph morph) {
            if (this.current.setDuration && morph instanceof IAnimationProvider) {
                ((IAnimationProvider)morph).getAnimation().duration = (int)this.getCurrentDuration();
            }
        }

        public void applyPrevious(AbstractMorph morph) {
            if (this.previous.setDuration && morph instanceof IAnimationProvider) {
                ((IAnimationProvider)morph).getAnimation().duration = (int)this.getPreviousDuration();
            }
        }
    }

    public static class SequenceEntry {
        public AbstractMorph morph;
        public float duration = 10.0f;
        public float random = 0.0f;
        public boolean setDuration;

        public SequenceEntry() {
        }

        public SequenceEntry(AbstractMorph morph) {
            this.morph = morph;
        }

        public SequenceEntry(AbstractMorph morph, float duration) {
            this(morph, duration, 0.0f);
        }

        public SequenceEntry(AbstractMorph morph, float duration, float random) {
            this(morph, duration, random, true);
        }

        public SequenceEntry(AbstractMorph morph, float duration, float random, boolean setDuration) {
            this.morph = morph;
            this.duration = duration;
            this.random = random;
            this.setDuration = setDuration;
        }

        public float getDuration(Random random) {
            return this.duration + (this.random != 0.0f ? random.nextFloat() * this.random : 0.0f);
        }

        public SequenceEntry clone() {
            return new SequenceEntry(MorphUtils.copy((AbstractMorph)this.morph), this.duration, this.random, this.setDuration);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SequenceEntry) {
                SequenceEntry entry = (SequenceEntry)obj;
                return Objects.equals(this.morph, entry.morph) && this.duration == entry.duration && this.random == entry.random && this.setDuration == entry.setDuration;
            }
            return super.equals(obj);
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound entryTag = new NBTTagCompound();
            if (this.morph != null) {
                entryTag.func_74782_a("Morph", (NBTBase)this.morph.toNBT());
            }
            entryTag.func_74776_a("Duration", this.duration);
            entryTag.func_74776_a("Random", this.random);
            entryTag.func_74757_a("SetDuration", this.setDuration);
            return entryTag;
        }

        public void fromNBT(NBTTagCompound tag) {
            if (tag.func_150297_b("Morph", 10)) {
                this.morph = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph"));
            }
            if (tag.func_150297_b("Duration", 99)) {
                this.duration = tag.func_74760_g("Duration");
            }
            if (tag.func_150297_b("Random", 99)) {
                this.random = tag.func_74760_g("Random");
            }
            this.setDuration = tag.func_74764_b("SetDuration") && tag.func_74767_n("SetDuration");
        }
    }
}

