/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import com.google.common.base.Objects;
import java.awt.Color;
import javax.vecmath.Matrix4f;
import mchorse.blockbuster_pack.trackers.ApertureTracker;
import mchorse.blockbuster_pack.trackers.BaseTracker;
import mchorse.blockbuster_pack.trackers.TrackerRegistry;
import mchorse.mclib.client.Draw;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TrackerMorph
extends AbstractMorph {
    public BaseTracker tracker = new ApertureTracker();
    public boolean hidden = false;
    private int renderTimer = 0;

    public TrackerMorph() {
        this.name = "tracker";
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        if (this.tracker != null && !this.tracker.name.isEmpty()) {
            return I18n.func_135052_a((String)("blockbuster.gui.tracker_morph.type." + TrackerRegistry.CLASS_TO_ID.get(this.tracker.getClass())), (Object[])new Object[0]) + " (" + this.tracker.name + ")";
        }
        return I18n.func_135052_a((String)"blockbuster.gui.tracker_morph.name", (Object[])new Object[0]);
    }

    public void update(EntityLivingBase target) {
        super.update(target);
        if (target.field_70170_p.field_72995_K) {
            ++this.renderTimer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        ++this.renderTimer;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)x, (float)(y - 15), (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-5.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(scale * 2.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
        this.renderPointer();
        GlStateManager.func_179121_F();
        String name = I18n.func_135052_a((String)"blockbuster.gui.tracker_morph.name", (Object[])new Object[0]);
        if (this.tracker != null && this.tracker.name != null && !this.tracker.name.isEmpty()) {
            name = this.tracker.name;
        }
        font.func_78276_b(name, -font.func_78256_a(name) / 2, 5, -1);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (Minecraft.func_71382_s() && Minecraft.func_71410_x().field_71462_r == null && !this.hidden || GuiModelRenderer.isRendering()) {
            GlStateManager.func_179140_f();
            this.renderPointer();
            GlStateManager.func_179145_e();
            if (!this.hidden) {
                this.renderLabel();
            }
        }
        if (this.tracker != null) {
            this.tracker.track(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    public AbstractMorph create() {
        return new TrackerMorph();
    }

    public float getWidth(EntityLivingBase target) {
        return 0.0f;
    }

    public float getHeight(EntityLivingBase target) {
        return 0.0f;
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof TrackerMorph) {
            TrackerMorph morph = (TrackerMorph)from;
            this.tracker = null;
            if (morph.tracker != null) {
                this.tracker = morph.tracker.copy();
            }
            this.hidden = morph.hidden;
        }
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof TrackerMorph) {
            this.mergeBasic(morph);
            this.hidden = ((TrackerMorph)morph).hidden;
            if (this.tracker != null) {
                return this.tracker.canMerge(morph);
            }
        }
        return super.canMerge(morph);
    }

    public boolean equals(Object object) {
        boolean result = super.equals(object);
        if (object instanceof TrackerMorph) {
            TrackerMorph morph = (TrackerMorph)((Object)object);
            result = result && Objects.equal((Object)this.tracker, (Object)morph.tracker);
            result = result && this.hidden == morph.hidden;
            return result;
        }
        return result;
    }

    public void reset() {
        this.tracker = null;
        this.hidden = false;
    }

    public void fromNBT(NBTTagCompound tag) {
        NBTTagCompound tracker;
        Class<? extends BaseTracker> clazz;
        super.fromNBT(tag);
        if (tag.func_150297_b("Tracker", 10) && (clazz = TrackerRegistry.ID_TO_CLASS.get((tracker = tag.func_74775_l("Tracker")).func_74779_i("Id"))) != null) {
            try {
                this.tracker = clazz.newInstance();
                this.tracker.fromNBT(tracker);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (tag.func_150297_b("Hidden", 1)) {
            this.hidden = tag.func_74767_n("Hidden");
        }
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.tracker != null) {
            NBTTagCompound tracker = new NBTTagCompound();
            tracker.func_74778_a("Id", TrackerRegistry.CLASS_TO_ID.get(this.tracker.getClass()));
            this.tracker.toNBT(tracker);
            tag.func_74782_a("Tracker", (NBTBase)tracker);
        }
        if (this.hidden) {
            tag.func_74757_a("Hidden", this.hidden);
        }
    }

    private void renderPointer() {
        this.renderTimer %= 50;
        int rgb = Color.HSBtoRGB((float)this.renderTimer / 50.0f, 1.0f, 1.0f);
        int rgb2 = Color.HSBtoRGB((float)this.renderTimer / 50.0f + 0.5f, 1.0f, 1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_187441_d((float)5.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 1.0).func_181669_b(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 0 & 0xFF, 255).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.5, 0.0).func_181669_b(rgb2 >> 16 & 0xFF, rgb2 >> 8 & 0xFF, rgb2 >> 0 & 0xFF, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
        Draw.point((double)0.0, (double)0.0, (double)0.0);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private void renderLabel() {
        if (this.tracker != null && !this.tracker.name.isEmpty()) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            Matrix4f mat = MatrixUtils.readModelView((Matrix4f)new Matrix4f());
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            EntityRenderer.func_189692_a((FontRenderer)font, (String)this.tracker.name, (float)mat.m03, (float)(mat.m13 + (float)font.field_78288_b / 48.0f + 0.1f), (float)mat.m23, (int)0, (float)180.0f, (float)0.0f, (mc.field_71474_y.field_74320_O == 2 ? 1 : 0) != 0, (boolean)false);
            GlStateManager.func_179121_F();
        }
    }
}

