/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.crafting.CustomRecipe;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BagDyeing
extends CustomRecipe {
    public BagDyeing(ResourceLocation name) {
        super(name);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.getOutput(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        dyed_output output = this.getOutput(inv);
        if (output != null) {
            return ChiselsAndBits.getItems().itemBitBag.dyeBag(output.bag, output.color);
        }
        return ModUtil.getEmptyStack();
    }

    private dyed_output getOutput(InventoryCrafting inv) {
        ItemStack bag = null;
        ItemStack dye = null;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (is == null || ModUtil.isEmpty(is)) continue;
            if (is.func_77973_b() == Items.field_151131_as || this.getDye(is) != null) {
                if (dye == null) {
                    dye = is;
                    continue;
                }
                return null;
            }
            if (is.func_77973_b() instanceof ItemBitBag) {
                if (bag == null) {
                    bag = is;
                    continue;
                }
                return null;
            }
            return null;
        }
        if (bag != null && dye != null) {
            return new dyed_output(bag, this.getDye(dye));
        }
        return null;
    }

    private EnumDyeColor getDye(ItemStack is) {
        if (this.testDye("dyeWhite", is)) {
            return EnumDyeColor.WHITE;
        }
        if (this.testDye("dyeOrange", is)) {
            return EnumDyeColor.ORANGE;
        }
        if (this.testDye("dyeMagenta", is)) {
            return EnumDyeColor.MAGENTA;
        }
        if (this.testDye("dyeLightBlue", is)) {
            return EnumDyeColor.LIGHT_BLUE;
        }
        if (this.testDye("dyeLime", is)) {
            return EnumDyeColor.LIME;
        }
        if (this.testDye("dyePink", is)) {
            return EnumDyeColor.PINK;
        }
        if (this.testDye("dyeGray", is)) {
            return EnumDyeColor.GRAY;
        }
        if (this.testDye("dyeLightGray", is)) {
            return EnumDyeColor.SILVER;
        }
        if (this.testDye("dyeCyan", is)) {
            return EnumDyeColor.CYAN;
        }
        if (this.testDye("dyePurple", is)) {
            return EnumDyeColor.PURPLE;
        }
        if (this.testDye("dyeBlue", is)) {
            return EnumDyeColor.BLUE;
        }
        if (this.testDye("dyeBrown", is)) {
            return EnumDyeColor.BROWN;
        }
        if (this.testDye("dyeGreen", is)) {
            return EnumDyeColor.GREEN;
        }
        if (this.testDye("dyeRed", is)) {
            return EnumDyeColor.RED;
        }
        if (this.testDye("dyeBlack", is)) {
            return EnumDyeColor.BLACK;
        }
        return null;
    }

    private boolean testDye(String string, ItemStack is) {
        if (OreDictionary.doesOreNameExist((String)string)) {
            int ore = OreDictionary.getOreID((String)string);
            int[] list = OreDictionary.getOreIDs((ItemStack)is);
            for (int x = 0; x < list.length; ++x) {
                if (list[x] != ore) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Invalid dye: " + string);
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ * p_194133_2_ >= 2;
    }

    public ItemStack func_77571_b() {
        return ModUtil.getEmptyStack();
    }

    private static class dyed_output {
        ItemStack bag;
        EnumDyeColor color;

        public dyed_output(ItemStack bag, EnumDyeColor dye) {
            this.bag = bag;
            this.color = dye;
        }
    }
}

