/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.animation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mchorse.chameleon.animation.ActionConfig;
import mchorse.chameleon.animation.ActionPlayback;
import mchorse.chameleon.animation.ActionsConfig;
import mchorse.chameleon.lib.ChameleonModel;
import mchorse.chameleon.lib.data.animation.Animation;
import mchorse.chameleon.lib.data.animation.Animations;
import mchorse.chameleon.lib.data.model.Model;
import mchorse.chameleon.metamorph.ChameleonMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Animator {
    public ActionPlayback idle;
    public ActionPlayback running;
    public ActionPlayback sprinting;
    public ActionPlayback crouching;
    public ActionPlayback crouchingIdle;
    public ActionPlayback swimming;
    public ActionPlayback swimmingIdle;
    public ActionPlayback flying;
    public ActionPlayback flyingIdle;
    public ActionPlayback riding;
    public ActionPlayback ridingIdle;
    public ActionPlayback dying;
    public ActionPlayback falling;
    public ActionPlayback sleeping;
    public ActionPlayback jump;
    public ActionPlayback swipe;
    public ActionPlayback hurt;
    public ActionPlayback land;
    public ActionPlayback shoot;
    public ActionPlayback consume;
    public ActionPlayback active;
    public ActionPlayback lastActive;
    public List<ActionPlayback> actions = new ArrayList<ActionPlayback>();
    public double prevX = 3.4028234663852886E38;
    public double prevZ = 3.4028234663852886E38;
    public double prevMY;
    public boolean wasOnGround = true;
    public boolean wasShooting = false;
    public boolean wasConsuming = false;
    private ChameleonMorph morph;

    public Animator(ChameleonMorph morph) {
        this.morph = morph;
        this.refresh();
    }

    public void refresh() {
        ActionsConfig actions = this.morph.actions;
        this.idle = this.createAction(this.idle, actions.getConfig("idle"), true);
        this.running = this.createAction(this.running, actions.getConfig("running"), true);
        this.sprinting = this.createAction(this.sprinting, actions.getConfig("sprinting"), true);
        this.crouching = this.createAction(this.crouching, actions.getConfig("crouching"), true);
        this.crouchingIdle = this.createAction(this.crouchingIdle, actions.getConfig("crouching_idle"), true);
        this.swimming = this.createAction(this.swimming, actions.getConfig("swimming"), true);
        this.swimmingIdle = this.createAction(this.swimmingIdle, actions.getConfig("swimming_idle"), true);
        this.flying = this.createAction(this.flying, actions.getConfig("flying"), true);
        this.flyingIdle = this.createAction(this.flyingIdle, actions.getConfig("flying_idle"), true);
        this.riding = this.createAction(this.riding, actions.getConfig("riding"), true);
        this.ridingIdle = this.createAction(this.ridingIdle, actions.getConfig("riding_idle"), true);
        this.dying = this.createAction(this.dying, actions.getConfig("dying"), false);
        this.falling = this.createAction(this.falling, actions.getConfig("falling"), true);
        this.sleeping = this.createAction(this.sleeping, actions.getConfig("sleeping"), true);
        this.swipe = this.createAction(this.swipe, actions.getConfig("swipe"), false);
        this.jump = this.createAction(this.jump, actions.getConfig("jump"), false, 2);
        this.hurt = this.createAction(this.hurt, actions.getConfig("hurt"), false, 3);
        this.land = this.createAction(this.land, actions.getConfig("land"), false);
        this.shoot = this.createAction(this.shoot, actions.getConfig("shoot"), true);
        this.consume = this.createAction(this.consume, actions.getConfig("consume"), true);
    }

    public ActionPlayback createAction(ActionPlayback old, ActionConfig config, boolean looping) {
        return this.createAction(old, config, looping, 1);
    }

    public ActionPlayback createAction(ActionPlayback old, ActionConfig config, boolean looping, int priority) {
        Animations animations;
        ChameleonModel model = this.morph.getModel();
        Animations animations2 = animations = model == null ? null : model.animations;
        if (animations == null) {
            return null;
        }
        Animation action = animations.get(config.name);
        if (action == null) {
            return null;
        }
        if (old != null && old.action == action) {
            old.config = config;
            old.setSpeed(1.0);
            return old;
        }
        return new ActionPlayback(action, config, looping, priority);
    }

    public void update(EntityLivingBase target) {
        if (this.prevX == 3.4028234663852886E38) {
            this.prevX = target.field_70165_t;
            this.prevZ = target.field_70161_v;
        }
        this.controlActions(target);
        if (this.active != null) {
            this.active.update();
        }
        if (this.lastActive != null) {
            this.lastActive.update();
        }
        Iterator<ActionPlayback> it = this.actions.iterator();
        while (it.hasNext()) {
            ActionPlayback action = it.next();
            action.update();
            if (!action.finishedFading() || !action.isFadingModeOut()) continue;
            action.stopFade();
            it.remove();
        }
    }

    protected void controlActions(EntityLivingBase target) {
        boolean moves;
        double dx = target.field_70165_t - this.prevX;
        double dz = target.field_70161_v - this.prevZ;
        boolean creativeFlying = target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75100_b;
        boolean wet = target.func_70090_H();
        float threshold = creativeFlying ? 0.1f : (wet ? 0.025f : 0.01f);
        boolean bl = moves = Math.abs(dx) > (double)threshold || Math.abs(dz) > (double)threshold;
        if (target.func_110143_aJ() <= 0.0f) {
            this.setActiveAction(this.dying);
        } else if (target.func_70608_bn()) {
            this.setActiveAction(this.sleeping);
        } else if (wet) {
            this.setActiveAction(!moves ? this.swimmingIdle : this.swimming);
        } else if (target.func_184218_aH()) {
            Entity riding = target.func_184187_bx();
            moves = Math.abs(riding.field_70165_t - this.prevX) > (double)threshold || Math.abs(riding.field_70161_v - this.prevZ) > (double)threshold;
            this.prevX = riding.field_70165_t;
            this.prevZ = riding.field_70161_v;
            this.setActiveAction(!moves ? this.ridingIdle : this.riding);
        } else if (creativeFlying || target.func_184613_cA()) {
            this.setActiveAction(!moves ? this.flyingIdle : this.flying);
        } else {
            if (target.func_70093_af()) {
                this.setActiveAction(!moves ? this.crouchingIdle : this.crouching);
            } else if (!target.field_70122_E && target.field_70181_x < 0.0 && (double)target.field_70143_R > 1.25) {
                this.setActiveAction(this.falling);
            } else if (target.func_70051_ag() && this.sprinting != null) {
                this.setActiveAction(this.sprinting);
            } else {
                this.setActiveAction(!moves ? this.idle : this.running);
            }
            if (target.field_70122_E && !this.wasOnGround && !target.func_70051_ag() && this.prevMY < -0.5) {
                this.addAction(this.land);
            }
        }
        if (!target.field_70122_E && this.wasOnGround && Math.abs(target.field_70181_x) > (double)0.2f) {
            this.addAction(this.jump);
            this.wasOnGround = false;
        }
        boolean shooting = this.wasShooting;
        boolean consuming = this.wasConsuming;
        ItemStack stack = target.func_184614_ca();
        if (!stack.func_190926_b()) {
            if (target.func_184605_cv() > 0) {
                EnumAction action = stack.func_77975_n();
                if (action == EnumAction.BOW) {
                    if (!this.actions.contains(this.shoot)) {
                        this.addAction(this.shoot);
                    }
                    this.wasShooting = true;
                } else if (action == EnumAction.DRINK || action == EnumAction.EAT) {
                    if (!this.actions.contains(this.consume)) {
                        this.addAction(this.consume);
                    }
                    this.wasConsuming = true;
                }
            } else {
                this.wasShooting = false;
                this.wasConsuming = false;
            }
        } else {
            this.wasShooting = false;
            this.wasConsuming = false;
        }
        if (shooting && !this.wasShooting && this.shoot != null) {
            this.shoot.fadeOut();
        }
        if (consuming && !this.wasConsuming && this.consume != null) {
            this.consume.fadeOut();
        }
        if (target.field_70737_aN == target.field_70738_aO - 1) {
            this.addAction(this.hurt);
        }
        if (target.field_82175_bq && target.field_70733_aJ == 0.0f && !target.func_70608_bn()) {
            this.addAction(this.swipe);
        }
        this.prevX = target.field_70165_t;
        this.prevZ = target.field_70161_v;
        this.prevMY = target.field_70181_x;
        this.wasOnGround = target.field_70122_E;
    }

    public void setActiveAction(ActionPlayback action) {
        if (this.active == action || action == null) {
            return;
        }
        if (this.active != null && action.priority < this.active.priority) {
            return;
        }
        if (this.active != null) {
            this.lastActive = this.active;
        }
        this.active = action;
        this.active.reset();
        this.active.fadeIn();
    }

    public void addAction(ActionPlayback action) {
        if (action == null) {
            return;
        }
        if (this.actions.contains(action)) {
            action.reset();
            return;
        }
        action.reset();
        action.fadeIn();
        this.actions.add(action);
    }

    public void applyActions(EntityLivingBase target, Model armature, float partialTicks) {
        if (this.lastActive != null && this.active.isFading()) {
            this.lastActive.apply(target, armature, partialTicks, 1.0f, false);
        }
        if (this.active != null) {
            float fade = this.active.isFading() ? this.active.getFadeFactor(partialTicks) : 1.0f;
            this.active.apply(target, armature, partialTicks, fade, false);
        }
        for (ActionPlayback action : this.actions) {
            if (action.isFading()) {
                action.apply(target, armature, partialTicks, action.getFadeFactor(partialTicks), true);
                continue;
            }
            action.apply(target, armature, partialTicks, 1.0f, true);
        }
    }
}

