/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib.data.model;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import mchorse.chameleon.lib.data.model.Model;
import mchorse.chameleon.lib.data.model.ModelQuad;
import mchorse.chameleon.lib.data.model.ModelUV;

public class ModelCube {
    public List<ModelQuad> quads = new ArrayList<ModelQuad>();
    public Vector3f origin = new Vector3f();
    public Vector3f size = new Vector3f();
    public Vector3f pivot = new Vector3f();
    public Vector3f rotation = new Vector3f();
    public float inflate;
    public ModelUV north;
    public ModelUV east;
    public ModelUV south;
    public ModelUV west;
    public ModelUV up;
    public ModelUV down;

    public void setupBoxUV(Vector2f boxUV, boolean mirror) {
        float tmp;
        float w = (float)Math.floor(this.size.x);
        float h = (float)Math.floor(this.size.y);
        float d = (float)Math.floor(this.size.z);
        float tMinX = boxUV.x + d;
        float tMinY = boxUV.y + d;
        float tMaxX = tMinX + w;
        float tMaxY = tMinY + h;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.north = ModelUV.from(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + d;
        tMaxY = tMinY + h;
        if (mirror) {
            tMinX = boxUV.x + d + w;
            tMinY = boxUV.y + d;
            tMaxX = tMinX + d;
            tMaxY = tMinY + h;
            tmp = tMinX;
            tMinX = tMaxX;
            tMaxX = tmp;
        }
        this.east = ModelUV.from(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d * 2.0f + w;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + w;
        tMaxY = tMinY + h;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.south = ModelUV.from(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d + w;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + d;
        tMaxY = tMinY + h;
        if (mirror) {
            tMinX = boxUV.x;
            tMinY = boxUV.y + d;
            tMaxX = tMinX + d;
            tMaxY = tMinY + h;
            tmp = tMinX;
            tMinX = tMaxX;
            tMaxX = tmp;
        }
        this.west = ModelUV.from(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d;
        tMinY = boxUV.y;
        tMaxX = tMinX + w;
        tMaxY = tMinY + d;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.up = ModelUV.from(tMinX, tMinY, tMaxX, tMaxY);
        tMinX = boxUV.x + d + w;
        tMinY = boxUV.y + d;
        tMaxX = tMinX + w;
        tMaxY = boxUV.y;
        if (mirror) {
            tmp = tMaxX;
            tMaxX = tMinX;
            tMinX = tmp;
        }
        this.down = ModelUV.from(tMinX, tMinY, tMaxX, tMaxY);
    }

    public void generateQuads(Model model) {
        ModelUV uv;
        float tw = 1.0f / (float)model.textureWidth;
        float th = 1.0f / (float)model.textureHeight;
        float minX = (this.origin.x - this.size.x - this.inflate) / 16.0f;
        float minY = (this.origin.y - this.inflate) / 16.0f;
        float minZ = (this.origin.z - this.inflate) / 16.0f;
        float maxX = (this.origin.x + this.inflate) / 16.0f;
        float maxY = (this.origin.y + this.size.y + this.inflate) / 16.0f;
        float maxZ = (this.origin.z + this.size.z + this.inflate) / 16.0f;
        if (this.north != null) {
            uv = this.north;
            this.quads.add(new ModelQuad().vertex(maxX, minY, minZ, uv.sx() * tw, uv.ey() * th).vertex(minX, minY, minZ, uv.ex() * tw, uv.ey() * th).vertex(minX, maxY, minZ, uv.ex() * tw, uv.sy() * th).vertex(maxX, maxY, minZ, uv.sx() * tw, uv.sy() * th).normal(0.0f, 0.0f, -1.0f));
        }
        if (this.east != null) {
            uv = this.east;
            this.quads.add(new ModelQuad().vertex(maxX, minY, maxZ, uv.sx() * tw, uv.ey() * th).vertex(maxX, minY, minZ, uv.ex() * tw, uv.ey() * th).vertex(maxX, maxY, minZ, uv.ex() * tw, uv.sy() * th).vertex(maxX, maxY, maxZ, uv.sx() * tw, uv.sy() * th).normal(1.0f, 0.0f, 0.0f));
        }
        if (this.south != null) {
            uv = this.south;
            this.quads.add(new ModelQuad().vertex(minX, minY, maxZ, uv.sx() * tw, uv.ey() * th).vertex(maxX, minY, maxZ, uv.ex() * tw, uv.ey() * th).vertex(maxX, maxY, maxZ, uv.ex() * tw, uv.sy() * th).vertex(minX, maxY, maxZ, uv.sx() * tw, uv.sy() * th).normal(0.0f, 0.0f, 1.0f));
        }
        if (this.west != null) {
            uv = this.west;
            this.quads.add(new ModelQuad().vertex(minX, minY, minZ, uv.sx() * tw, uv.ey() * th).vertex(minX, minY, maxZ, uv.ex() * tw, uv.ey() * th).vertex(minX, maxY, maxZ, uv.ex() * tw, uv.sy() * th).vertex(minX, maxY, minZ, uv.sx() * tw, uv.sy() * th).normal(-1.0f, 0.0f, 0.0f));
        }
        if (this.up != null) {
            uv = this.up;
            this.quads.add(new ModelQuad().vertex(maxX, maxY, minZ, uv.sx() * tw, uv.ey() * th).vertex(minX, maxY, minZ, uv.ex() * tw, uv.ey() * th).vertex(minX, maxY, maxZ, uv.ex() * tw, uv.sy() * th).vertex(maxX, maxY, maxZ, uv.sx() * tw, uv.sy() * th).normal(0.0f, 1.0f, 0.0f));
        }
        if (this.down != null) {
            uv = this.down;
            this.quads.add(new ModelQuad().vertex(minX, minY, minZ, uv.ex() * tw, uv.sy() * th).vertex(maxX, minY, minZ, uv.sx() * tw, uv.sy() * th).vertex(maxX, minY, maxZ, uv.sx() * tw, uv.ey() * th).vertex(minX, minY, maxZ, uv.ex() * tw, uv.ey() * th).normal(0.0f, -1.0f, 0.0f));
        }
    }
}

