/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.editor.render;

import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelCube;
import mchorse.chameleon.lib.data.model.ModelQuad;
import mchorse.chameleon.lib.data.model.ModelVertex;
import mchorse.chameleon.lib.render.ChameleonPostRenderer;
import mchorse.chameleon.lib.render.IChameleonRenderProcessor;
import mchorse.chameleon.lib.utils.MatrixStack;
import mchorse.mclib.client.Draw;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChameleonHighlightRenderer
implements IChameleonRenderProcessor {
    private String boneName;
    private Vector4f vertex = new Vector4f();

    public void setBoneName(String boneName) {
        this.boneName = boneName;
    }

    @Override
    public boolean renderBone(BufferBuilder builder, MatrixStack stack, ModelBone bone) {
        if (bone.id.equals(this.boneName)) {
            builder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            for (ModelCube cube : bone.cubes) {
                this.renderCubeForHighlight(builder, stack, cube);
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179094_E();
            ChameleonPostRenderer.multiplyMatrix(stack, bone);
            Draw.axis((float)0.375f);
            GlStateManager.func_179121_F();
            return true;
        }
        return false;
    }

    private void renderCubeForHighlight(BufferBuilder builder, MatrixStack stack, ModelCube cube) {
        stack.push();
        stack.moveToCubePivot(cube);
        stack.rotateCube(cube);
        stack.moveBackFromCubePivot(cube);
        for (ModelQuad quad : cube.quads) {
            for (ModelVertex vertex : quad.vertices) {
                this.vertex.set((Tuple3f)vertex.position);
                this.vertex.w = 1.0f;
                stack.getModelMatrix().transform((Tuple4f)this.vertex);
                builder.func_181662_b((double)this.vertex.getX(), (double)this.vertex.getY(), (double)this.vertex.getZ()).func_181675_d();
            }
        }
        stack.pop();
    }
}

