/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.pose;

import mchorse.mclib.utils.Interpolation;
import net.minecraft.nbt.NBTTagCompound;

public class AnimatedTransform {
    public String boneName;
    public float x;
    public float y;
    public float z;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public float rotateX;
    public float rotateY;
    public float rotateZ;

    public AnimatedTransform(String name) {
        this.boneName = name;
    }

    public void interpolate(AnimatedTransform a, AnimatedTransform b, float x, Interpolation interp) {
        this.x = interp.interpolate(a.x, b.x, x);
        this.y = interp.interpolate(a.y, b.y, x);
        this.z = interp.interpolate(a.z, b.z, x);
        this.scaleX = interp.interpolate(a.scaleX, b.scaleX, x);
        this.scaleY = interp.interpolate(a.scaleY, b.scaleY, x);
        this.scaleZ = interp.interpolate(a.scaleZ, b.scaleZ, x);
        this.rotateX = interp.interpolate(a.rotateX, b.rotateX, x);
        this.rotateY = interp.interpolate(a.rotateY, b.rotateY, x);
        this.rotateZ = interp.interpolate(a.rotateZ, b.rotateZ, x);
    }

    public AnimatedTransform clone() {
        AnimatedTransform item = new AnimatedTransform(this.boneName);
        item.x = this.x;
        item.y = this.y;
        item.z = this.z;
        item.scaleX = this.scaleX;
        item.scaleY = this.scaleY;
        item.scaleZ = this.scaleZ;
        item.rotateX = this.rotateX;
        item.rotateY = this.rotateY;
        item.rotateZ = this.rotateZ;
        return item;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnimatedTransform) {
            AnimatedTransform config = (AnimatedTransform)obj;
            boolean result = config.x == this.x && config.y == this.y && config.z == this.z;
            result = result && config.scaleX == this.scaleX && config.scaleY == this.scaleY && config.scaleZ == this.scaleZ;
            result = result && config.rotateX == this.rotateX && config.rotateY == this.rotateY && config.rotateZ == this.rotateZ;
            return result;
        }
        return super.equals(obj);
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("X", 99)) {
            this.x = tag.func_74760_g("X");
        }
        if (tag.func_150297_b("Y", 99)) {
            this.y = tag.func_74760_g("Y");
        }
        if (tag.func_150297_b("Z", 99)) {
            this.z = tag.func_74760_g("Z");
        }
        if (tag.func_150297_b("SX", 99)) {
            this.scaleX = tag.func_74760_g("SX");
        }
        if (tag.func_150297_b("SY", 99)) {
            this.scaleY = tag.func_74760_g("SY");
        }
        if (tag.func_150297_b("SZ", 99)) {
            this.scaleZ = tag.func_74760_g("SZ");
        }
        if (tag.func_150297_b("RX", 99)) {
            this.rotateX = tag.func_74760_g("RX");
        }
        if (tag.func_150297_b("RY", 99)) {
            this.rotateY = tag.func_74760_g("RY");
        }
        if (tag.func_150297_b("RZ", 99)) {
            this.rotateZ = tag.func_74760_g("RZ");
        }
    }

    public NBTTagCompound toNBT(NBTTagCompound tag) {
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (this.x != 0.0f) {
            tag.func_74776_a("X", this.x);
        }
        if (this.y != 0.0f) {
            tag.func_74776_a("Y", this.y);
        }
        if (this.z != 0.0f) {
            tag.func_74776_a("Z", this.z);
        }
        if (this.scaleX != 1.0f) {
            tag.func_74776_a("SX", this.scaleX);
        }
        if (this.scaleY != 1.0f) {
            tag.func_74776_a("SY", this.scaleY);
        }
        if (this.scaleZ != 1.0f) {
            tag.func_74776_a("SZ", this.scaleZ);
        }
        if (this.rotateX != 0.0f) {
            tag.func_74776_a("RX", this.rotateX);
        }
        if (this.rotateY != 0.0f) {
            tag.func_74776_a("RY", this.rotateY);
        }
        if (this.rotateZ != 0.0f) {
            tag.func_74776_a("RZ", this.rotateZ);
        }
        return tag;
    }
}

