/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.modularwarfare.ModConfig;
import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.WeaponAnimations;
import com.modularwarfare.client.ClientEventHandler;
import com.modularwarfare.client.ClientRenderHooks;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.client.config.AmmoRenderConfig;
import com.modularwarfare.client.config.ArmorRenderConfig;
import com.modularwarfare.client.config.AttachmentRenderConfig;
import com.modularwarfare.client.config.BackpackRenderConfig;
import com.modularwarfare.client.config.BulletRenderConfig;
import com.modularwarfare.client.config.GrenadeRenderConfig;
import com.modularwarfare.client.config.GunRenderConfig;
import com.modularwarfare.client.export.ItemModelExport;
import com.modularwarfare.client.handler.ClientGunHandler;
import com.modularwarfare.client.handler.ClientTickHandler;
import com.modularwarfare.client.handler.KeyInputHandler;
import com.modularwarfare.client.handler.RenderGuiHandler;
import com.modularwarfare.client.handler.SmoothSwingTicker;
import com.modularwarfare.client.hud.AttachmentUI;
import com.modularwarfare.client.hud.GunUI;
import com.modularwarfare.client.killchat.KillFeedManager;
import com.modularwarfare.client.killchat.KillFeedRender;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.client.model.animations.AnimationPistol;
import com.modularwarfare.client.model.animations.AnimationRevolver;
import com.modularwarfare.client.model.animations.AnimationRifle;
import com.modularwarfare.client.model.animations.AnimationRifle2;
import com.modularwarfare.client.model.animations.AnimationRifle3;
import com.modularwarfare.client.model.animations.AnimationRifle4;
import com.modularwarfare.client.model.animations.AnimationShotgun;
import com.modularwarfare.client.model.animations.AnimationSideClip;
import com.modularwarfare.client.model.animations.AnimationSniperBottom;
import com.modularwarfare.client.model.animations.AnimationSniperTop;
import com.modularwarfare.client.model.animations.AnimationTopRifle;
import com.modularwarfare.client.model.layers.RenderLayerBackpack;
import com.modularwarfare.client.model.layers.RenderLayerBody;
import com.modularwarfare.client.model.layers.RenderLayerHeldGun;
import com.modularwarfare.client.model.renders.RenderAmmo;
import com.modularwarfare.client.model.renders.RenderAttachment;
import com.modularwarfare.client.model.renders.RenderBullet;
import com.modularwarfare.client.model.renders.RenderDecal;
import com.modularwarfare.client.model.renders.RenderGrenade;
import com.modularwarfare.client.model.renders.RenderGrenadeEntity;
import com.modularwarfare.client.model.renders.RenderGunStatic;
import com.modularwarfare.client.model.renders.RenderItemLoot;
import com.modularwarfare.client.model.renders.RenderParameters;
import com.modularwarfare.client.model.renders.RenderShell;
import com.modularwarfare.client.patch.customnpc.CustomNPCListener;
import com.modularwarfare.client.patch.galacticraft.GCCompatInterop;
import com.modularwarfare.client.patch.galacticraft.GCDummyInterop;
import com.modularwarfare.client.patch.obfuscate.ObfuscateCompatInterop;
import com.modularwarfare.client.scope.ScopeUtils;
import com.modularwarfare.common.CommonProxy;
import com.modularwarfare.common.armor.ArmorType;
import com.modularwarfare.common.armor.ItemMWArmor;
import com.modularwarfare.common.armor.ItemSpecialArmor;
import com.modularwarfare.common.backpacks.BackpackType;
import com.modularwarfare.common.backpacks.ItemBackpack;
import com.modularwarfare.common.entity.EntityBulletClient;
import com.modularwarfare.common.entity.debug.EntityDebugAABB;
import com.modularwarfare.common.entity.debug.EntityDebugDot;
import com.modularwarfare.common.entity.debug.EntityDebugVector;
import com.modularwarfare.common.entity.debug.RenderDebugAABB;
import com.modularwarfare.common.entity.debug.RenderDebugDot;
import com.modularwarfare.common.entity.debug.RenderDebugVector;
import com.modularwarfare.common.entity.decals.EntityBulletHole;
import com.modularwarfare.common.entity.decals.EntityShell;
import com.modularwarfare.common.entity.grenades.EntityGrenade;
import com.modularwarfare.common.entity.item.EntityItemLoot;
import com.modularwarfare.common.extra.ItemLight;
import com.modularwarfare.common.grenades.GrenadeType;
import com.modularwarfare.common.grenades.ItemGrenade;
import com.modularwarfare.common.guns.AmmoType;
import com.modularwarfare.common.guns.AttachmentEnum;
import com.modularwarfare.common.guns.AttachmentType;
import com.modularwarfare.common.guns.BulletType;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemAmmo;
import com.modularwarfare.common.guns.ItemAttachment;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.ItemSpray;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.particle.EntityBloodFX;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.objects.SoundEntry;
import com.modularwarfare.utility.MWResourcePack;
import com.modularwarfare.utility.MWSound;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import paulscode.sound.SoundSystemConfig;

public class ClientProxy
extends CommonProxy {
    public static ScopeUtils scopeUtils;
    public static ItemLight itemLight;
    public static RenderGrenade grenadeRenderer;
    public static GCCompatInterop galacticraftInterop;
    public static ClientRenderHooks renderHooks;
    public static KillFeedManager killFeedManager;
    private static final int[] llllllIl;
    public static RenderAttachment attachmentRenderer;
    public static AttachmentUI attachmentUI;
    public static ObfuscateCompatInterop obfuscateInterop;
    public static RenderGunStatic gunStaticRenderer;
    public static String modelDir;
    public static GunUI gunUI;
    public static HashMap<String, SoundEvent> modSounds;
    public static RenderAmmo ammoRenderer;

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    public KillFeedManager getKillChatManager() {
        return killFeedManager;
    }

    @Override
    public void onShootAnimation(EntityPlayer player, String wepType, int fireTickDelay, float recoilPitch, float recoilYaw) {
        GunType gunType = ModularWarfare.gunTypes.get((Object)wepType).type;
        if (gunType != null) {
            ClientRenderHooks.getAnimMachine(player).triggerShoot((ModelGun)gunType.model, gunType, fireTickDelay);
            float recoilPitchGripFactor = 1.0f;
            float recoilYawGripFactor = 1.0f;
            float recoilPitchBarrelFactor = 1.0f;
            float recoilYawBarrelFactor = 1.0f;
            if (GunType.getAttachment(player.func_184582_a(EntityEquipmentSlot.MAINHAND), AttachmentEnum.Grip) != null) {
                ItemAttachment gripAttachment = (ItemAttachment)GunType.getAttachment(player.func_184582_a(EntityEquipmentSlot.MAINHAND), AttachmentEnum.Grip).func_77973_b();
                recoilPitchGripFactor = gripAttachment.type.grip.recoilPitchFactor;
                recoilYawGripFactor = gripAttachment.type.grip.recoilYawFactor;
            }
            if (GunType.getAttachment(player.func_184582_a(EntityEquipmentSlot.MAINHAND), AttachmentEnum.Barrel) != null) {
                ItemAttachment barrelAttachment = (ItemAttachment)GunType.getAttachment(player.func_184582_a(EntityEquipmentSlot.MAINHAND), AttachmentEnum.Barrel).func_77973_b();
                recoilPitchBarrelFactor = barrelAttachment.type.barrel.recoilPitchFactor;
                recoilYawBarrelFactor = barrelAttachment.type.barrel.recoilYawFactor;
            }
            if (!ClientRenderHooks.isAiming) {
                RenderParameters.playerRecoilPitch += (gunType.recoilPitch + (new Random().nextFloat() * (gunType.randomRecoilPitch * 2.0f) - gunType.randomRecoilPitch)) * (recoilPitchGripFactor * recoilPitchBarrelFactor);
                RenderParameters.playerRecoilYaw += gunType.recoilYaw + (new Random().nextFloat() * (gunType.randomRecoilYaw * 2.0f) - gunType.randomRecoilYaw) * (recoilYawGripFactor * recoilYawBarrelFactor);
            } else {
                RenderParameters.playerRecoilPitch += (gunType.recoilPitch + (new Random().nextFloat() * (gunType.randomRecoilPitch * 2.0f) - gunType.randomRecoilPitch)) * gunType.recoilAimReducer * (recoilPitchGripFactor * recoilPitchBarrelFactor);
                RenderParameters.playerRecoilYaw += (gunType.recoilYaw + (new Random().nextFloat() * (gunType.randomRecoilYaw * 2.0f) - gunType.randomRecoilYaw)) * gunType.recoilAimReducer * (recoilYawGripFactor * recoilYawBarrelFactor);
            }
        }
    }

    private static void lIIlIIIl() {
        llllllIl = new int[5];
        ClientProxy.llllllIl[0] = " ".length();
        ClientProxy.llllllIl[1] = (1 ^ 0x66 ^ (0x4D ^ 0x70)) & (147 + 177 - 186 + 75 ^ 70 + 126 - 182 + 129 ^ -" ".length());
        ClientProxy.llllllIl[2] = -(0xFFFFEBFF & 0x35FB) & (0xFFFFB7FA & 0x6DFF);
        ClientProxy.llllllIl[3] = 0x1C ^ 0x3C;
        ClientProxy.llllllIl[4] = "  ".length();
    }

    @Override
    public void construction(FMLConstructionEvent event) {
        File file;
        int n;
        int n2;
        File[] fileArray;
        File myDir = new File("ModularWarfare");
        File modFile = null;
        if (!myDir.exists()) {
            if (myDir.getParentFile() != null) {
                if (!(myDir = new File(myDir.getParentFile().getParentFile(), "ModularWarfare")).exists()) {
                    myDir = new File("ModularWarfare");
                    myDir.mkdirs();
                }
            } else {
                myDir.mkdirs();
            }
        }
        if (!(ModularWarfare.MOD_DIR = myDir).exists()) {
            ModularWarfare.MOD_DIR.mkdir();
            ModularWarfare.DEV_ENV = ModConfig.INSTANCE.dev_mode;
        }
        new ModConfig(new File(ModularWarfare.MOD_DIR, "mod_config.json"));
        ImmutableList knownLibraries = ImmutableList.builder().addAll((Iterable)event.getModClassLoader().getDefaultLibraries()).addAll((Iterable)CoreModManager.getIgnoredMods()).addAll((Iterable)CoreModManager.getReparseableCoremods()).build();
        File[] minecraftSources = event.getModClassLoader().getParentSources();
        if (minecraftSources.length == llllllIl[0] && minecraftSources[llllllIl[1]].isFile()) {
            FMLLog.log.debug("Minecraft is a file at {}, loading", (Object)minecraftSources[llllllIl[1]].getAbsolutePath());
        } else {
            int i = llllllIl[1];
            fileArray = minecraftSources;
            n2 = fileArray.length;
            for (n = llllllIl[1]; n < n2; ++n) {
                File source = fileArray[n];
                if (source.isFile()) {
                    if (knownLibraries.contains(source.getName()) || event.getModClassLoader().isDefaultLibrary(source)) {
                        FMLLog.log.trace("Skipping known library file {}", (Object)source.getAbsolutePath());
                    } else {
                        FMLLog.log.debug("Found a minecraft related file at {}, examining for mod candidates", (Object)source.getAbsolutePath());
                        if (source.getAbsolutePath().contains("modularwarfare")) {
                            modFile = source;
                        }
                    }
                } else if (minecraftSources[i].isDirectory()) {
                    FMLLog.log.debug("Found a minecraft related directory at {}, examining for mod candidates", (Object)source.getAbsolutePath());
                }
                ++i;
            }
        }
        int needPrototypeExtract = ModConfig.INSTANCE.autoExtractContentpack;
        fileArray = myDir.listFiles();
        n2 = fileArray.length;
        for (n = llllllIl[1]; n < n2; ++n) {
            file = fileArray[n];
            if (file.getName().matches("prototype-1.0.9f-contentpack.zip")) {
                needPrototypeExtract = llllllIl[1];
                continue;
            }
            if (!file.getName().contains("prototype") || file.getName().contains("1.0.9f") || !file.getName().contains(".zip") || file.getName().endsWith(".bak")) continue;
            file.renameTo(new File(file.getAbsolutePath() + ".bak"));
        }
        if (needPrototypeExtract != 0) {
            try {
                ZipFile zipFile = new ZipFile(modFile);
                if (zipFile.isValidZipFile()) {
                    zipFile.extractFile("prototype-1.0.9f-contentpack.zip", myDir.getAbsolutePath());
                }
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
        }
        fileArray = myDir.listFiles();
        n2 = fileArray.length;
        for (n = llllllIl[1]; n < n2; ++n) {
            file = fileArray[n];
            if (file.getName().contains("cache") || file.getName().contains("officialmw") || file.getName().contains("highres")) continue;
            if (zipJar.matcher(file.getName()).matches()) {
                try {
                    FMLModContainer container;
                    HashMap<String, Object> map;
                    ZipFile zipFile = new ZipFile(file);
                    if (zipFile.isEncrypted()) {
                        ModularWarfare.PROTECTOR.requestPassword(file.getName());
                        ModularWarfare.PROTECTOR.applyPassword(zipFile, file.getName());
                        map = new HashMap();
                        map.put("modid", "modularwarfare");
                        map.put("name", "ModularWarfare : " + file.getName());
                        map.put("version", "1");
                        container = new MWResourcePack.Container("com.modularwarfare.ModularWarfare", new ModCandidate(file, file, ContainerType.JAR), map, zipFile, "ModularWarfare : " + file.getName());
                        container.bindMetadata(MetadataCollection.from(null, (String)""));
                        FMLClientHandler.instance().addModAsResource((ModContainer)container);
                        ModularWarfare.contentPacks.add(file);
                        continue;
                    }
                    try {
                        map = new HashMap<String, Object>();
                        map.put("modid", "modularwarfare");
                        map.put("name", "ModularWarfare : " + file.getName());
                        map.put("version", "1");
                        container = new FMLModContainer("com.modularwarfare.ModularWarfare", new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                        container.bindMetadata(MetadataCollection.from(null, (String)""));
                        FMLClientHandler.instance().addModAsResource((ModContainer)container);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ModularWarfare.contentPacks.add(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("modid", "modularwarfare");
                map.put("name", "ModularWarfare : " + file.getName());
                map.put("version", "1");
                FMLModContainer container = new FMLModContainer("com.modularwarfare.ModularWarfare", new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                container.bindMetadata(MetadataCollection.from(null, (String)""));
                FMLClientHandler.instance().addModAsResource((ModContainer)container);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ModularWarfare.contentPacks.add(file);
        }
    }

    @Override
    public void generateLangFiles(ArrayList<BaseType> types, boolean replace) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap langEntryMap = new HashMap();
        for (BaseType baseType : types) {
            if (baseType.contentPack == null) continue;
            String contentPack = baseType.contentPack;
            if (!langEntryMap.containsKey(contentPack)) {
                langEntryMap.put(contentPack, new ArrayList());
            }
            if (baseType.displayName != null && !((ArrayList)langEntryMap.get(contentPack)).contains(baseType)) {
                ((ArrayList)langEntryMap.get(contentPack)).add(baseType);
            }
            if (!(baseType instanceof ArmorType)) continue;
            ((ArrayList)langEntryMap.get(contentPack)).add(baseType);
        }
        for (String contentPack : langEntryMap.keySet()) {
            try {
                Path langPath;
                boolean soundsExists;
                int shouldCreate;
                ArrayList langEntries;
                File contentPackDir = new File(ModularWarfare.MOD_DIR, contentPack);
                if (!contentPackDir.exists() || !contentPackDir.isDirectory() || (langEntries = (ArrayList)langEntryMap.get(contentPack)) == null || langEntries.isEmpty()) continue;
                Path langDir = Paths.get(ModularWarfare.MOD_DIR.getAbsolutePath() + "/" + contentPack + "/assets/modularwarfare/lang/", new String[llllllIl[1]]);
                if (!Files.exists(langDir, new LinkOption[llllllIl[1]])) {
                    Files.createDirectories(langDir, new FileAttribute[llllllIl[1]]);
                }
                if ((shouldCreate = (soundsExists = Files.exists(langPath = Paths.get(langDir + "/en_US.lang", new String[llllllIl[1]]), new LinkOption[llllllIl[1]])) ? replace : llllllIl[0]) == 0) continue;
                if (!soundsExists) {
                    Files.createFile(langPath, new FileAttribute[llllllIl[1]]);
                }
                ArrayList<String> jsonEntries = new ArrayList<String>();
                String format = "item.%s.name=%s";
                for (int i = llllllIl[1]; i < langEntries.size(); ++i) {
                    BaseType type = (BaseType)langEntries.get(i);
                    if (type instanceof ArmorType) {
                        ArmorType armorType = (ArmorType)type;
                        for (ArmorType.ArmorInfo armorInfo : armorType.armorTypes.values()) {
                            String internalName = armorInfo.internalName != null ? armorInfo.internalName : armorType.internalName;
                            Object[] objectArray = new Object[llllllIl[4]];
                            objectArray[ClientProxy.llllllIl[1]] = internalName;
                            objectArray[ClientProxy.llllllIl[0]] = armorInfo.displayName;
                            jsonEntries.add(String.format(format, objectArray));
                        }
                        continue;
                    }
                    Object[] objectArray = new Object[llllllIl[4]];
                    objectArray[ClientProxy.llllllIl[1]] = type.internalName;
                    objectArray[ClientProxy.llllllIl[0]] = type.displayName;
                    jsonEntries.add(String.format(format, objectArray));
                }
                Files.write(langPath, jsonEntries, Charset.forName("UTF-8"), new OpenOption[llllllIl[1]]);
            }
            catch (Exception exception) {
                if (ModularWarfare.DEV_ENV) {
                    exception.printStackTrace();
                    continue;
                }
                Object[] objectArray = new Object[llllllIl[0]];
                objectArray[ClientProxy.llllllIl[1]] = contentPack;
                ModularWarfare.LOGGER.error(String.format("Failed to create sounds.json for content pack '%s'", objectArray));
            }
        }
    }

    @Override
    public void addBlood(EntityLivingBase living, int amount) {
        for (int k = llllllIl[1]; k < amount; ++k) {
            float attenuator = 0.3f;
            double mX = -MathHelper.func_76126_a((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(living.field_70125_A / 180.0f * (float)Math.PI)) * attenuator;
            double mZ = MathHelper.func_76134_b((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(living.field_70125_A / 180.0f * (float)Math.PI)) * attenuator;
            double mY = -MathHelper.func_76126_a((float)(living.field_70125_A / 180.0f * (float)Math.PI)) * attenuator + 0.1f;
            attenuator = 0.02f;
            float var5 = living.func_70681_au().nextFloat() * (float)Math.PI * 2.0f;
            EntityBloodFX blood = new EntityBloodFX(living.func_130014_f_(), living.field_70165_t, living.field_70163_u + 0.5 + living.func_70681_au().nextDouble() * 0.7, living.field_70161_v, living.field_70159_w * 2.0 + (mX += Math.cos(var5) * (double)(attenuator *= living.func_70681_au().nextFloat())), living.field_70181_x + (mY += (double)((living.func_70681_au().nextFloat() - living.func_70681_au().nextFloat()) * 0.1f)), living.field_70179_y * 2.0 + (mZ += Math.sin(var5) * (double)attenuator), 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)blood);
        }
    }

    public void setupLayers(RenderPlayer renderer) {
        renderer.func_177094_a((LayerRenderer)new RenderLayerBackpack(renderer, renderer.func_177087_b().field_178730_v));
        renderer.func_177094_a((LayerRenderer)new RenderLayerBody(renderer, renderer.func_177087_b().field_178730_v));
        renderer.func_177094_a((LayerRenderer)new RenderLayerHeldGun((RenderLivingBase<?>)renderer));
    }

    @Override
    public void playSound(MWSound sound) {
        SoundEvent soundEvent = modSounds.get(sound.soundName);
        if (soundEvent == null) {
            Object[] objectArray = new Object[llllllIl[0]];
            objectArray[ClientProxy.llllllIl[1]] = sound.soundName;
            ModularWarfare.LOGGER.error(String.format("The sound named '%s' does not exist. Skipping playSound", objectArray));
            return;
        }
        Minecraft.func_71410_x().field_71441_e.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, sound.blockPos, soundEvent, SoundCategory.PLAYERS, sound.volume, sound.pitch);
    }

    @Override
    public void forceReload() {
        FMLClientHandler.instance().refreshResources(new IResourceType[llllllIl[1]]);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBulletHole.class, (IRenderFactory)RenderDecal.FACTORY);
            RenderingRegistry.registerEntityRenderingHandler(EntityShell.class, (IRenderFactory)RenderShell.FACTORY);
            RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (IRenderFactory)RenderGrenadeEntity.FACTORY);
            RenderingRegistry.registerEntityRenderingHandler(EntityDebugAABB.class, (IRenderFactory)new RenderDebugAABB.Factory());
            RenderingRegistry.registerEntityRenderingHandler(EntityDebugDot.class, (IRenderFactory)new RenderDebugDot.Factory());
            RenderingRegistry.registerEntityRenderingHandler(EntityDebugVector.class, (IRenderFactory)new RenderDebugVector.Factory());
            RenderingRegistry.registerEntityRenderingHandler(EntityItemLoot.class, (IRenderFactory)RenderItemLoot.FACTORY);
            RenderingRegistry.registerEntityRenderingHandler(EntityBulletClient.class, (IRenderFactory)RenderBullet.FACTORY);
        }
    }

    @Override
    public void addBlood(EntityLivingBase living, int amount, boolean onhit) {
        if (onhit) {
            this.addBlood(living, amount);
        }
    }

    @Override
    public void generateJsonSounds(Collection<ItemGun> types, boolean replace) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap cpSounds = new HashMap();
        for (ItemGun itemGun : types) {
            GunType type = itemGun.type;
            if (type.contentPack == null) continue;
            String contentPack = type.contentPack;
            if (!cpSounds.containsKey(contentPack)) {
                cpSounds.put(contentPack, new ArrayList());
            }
            for (WeaponSoundType weaponSoundType : type.weaponSoundMap.keySet()) {
                ArrayList<SoundEntry> soundEntries = type.weaponSoundMap.get((Object)weaponSoundType);
                for (SoundEntry soundEntry : soundEntries) {
                    if (soundEntry.soundName != null && !((ArrayList)cpSounds.get(contentPack)).contains(soundEntry.soundName)) {
                        ((ArrayList)cpSounds.get(contentPack)).add(soundEntry.soundName);
                    }
                    if (soundEntry.soundNameDistant == null || ((ArrayList)cpSounds.get(contentPack)).contains(soundEntry.soundNameDistant)) continue;
                    ((ArrayList)cpSounds.get(contentPack)).add(soundEntry.soundNameDistant);
                }
            }
        }
        for (String contentPack : cpSounds.keySet()) {
            try {
                Path soundsFile;
                boolean soundsExists;
                int shouldCreate;
                ArrayList soundEntries;
                File contentPackDir = new File(ModularWarfare.MOD_DIR, contentPack);
                if (!contentPackDir.exists() || !contentPackDir.isDirectory() || (soundEntries = (ArrayList)cpSounds.get(contentPack)) == null || soundEntries.isEmpty()) continue;
                Path assetsDir = Paths.get(ModularWarfare.MOD_DIR.getAbsolutePath() + "/" + contentPack + "/assets/modularwarfare/", new String[llllllIl[1]]);
                if (!Files.exists(assetsDir, new LinkOption[llllllIl[1]])) {
                    Files.createDirectories(assetsDir, new FileAttribute[llllllIl[1]]);
                }
                if ((shouldCreate = (soundsExists = Files.exists(soundsFile = Paths.get(assetsDir + "/sounds.json", new String[llllllIl[1]]), new LinkOption[llllllIl[1]])) ? replace : llllllIl[0]) == 0) continue;
                if (!soundsExists) {
                    Files.createFile(soundsFile, new FileAttribute[llllllIl[1]]);
                }
                ArrayList<String> jsonEntries = new ArrayList<String>();
                String format = "\"%s\":{\"category\": \"player\",\"subtitle\": \"MW Sound\",\"sounds\": [\"modularwarfare:%s\"]}";
                jsonEntries.add("{");
                for (int i = llllllIl[1]; i < soundEntries.size(); ++i) {
                    if (i + llllllIl[0] < soundEntries.size()) {
                        jsonEntries.add(format.replaceAll("%s", (String)soundEntries.get(i)) + ",");
                        continue;
                    }
                    jsonEntries.add(format.replaceAll("%s", (String)soundEntries.get(i)));
                }
                jsonEntries.add("}");
                Files.write(soundsFile, jsonEntries, Charset.forName("UTF-8"), new OpenOption[llllllIl[1]]);
            }
            catch (Exception exception) {
                if (ModularWarfare.DEV_ENV) {
                    exception.printStackTrace();
                    continue;
                }
                Object[] objectArray = new Object[llllllIl[0]];
                objectArray[ClientProxy.llllllIl[1]] = contentPack;
                ModularWarfare.LOGGER.error(String.format("Failed to create sounds.json for content pack '%s'", objectArray));
            }
        }
    }

    @Override
    public void registerSound(String soundName) {
        ResourceLocation resourceLocation = new ResourceLocation("modularwarfare", soundName);
        modSounds.put(soundName, (SoundEvent)new SoundEvent(resourceLocation).setRegistryName(resourceLocation));
    }

    @Override
    public void init() {
    }

    @Override
    public void onReloadAnimation(EntityPlayer player, String wepType, int reloadTime, int reloadCount, int reloadType) {
        ClientTickHandler.playerReloadCooldown.put(player.func_110124_au(), reloadTime);
        ItemGun gunType = ModularWarfare.gunTypes.get(wepType);
        if (gunType != null) {
            ClientRenderHooks.getAnimMachine(player).triggerReload(reloadTime, reloadCount, (ModelGun)gunType.type.model, ReloadType.getTypeFromInt(reloadType), player.func_70051_ag());
        }
    }

    @Override
    public void playHitmarker(boolean headshot) {
        if (ModConfig.INSTANCE.enableHitmarker) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)modSounds.get("hitmarker"), (float)1.0f, (float)4.0f));
            GunUI.addHitMarker(headshot);
        }
    }

    @Override
    public void generateJsonModels(ArrayList<BaseType> types) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (BaseType type : types) {
            File typeGrenadeRender;
            File typeBackpackRender;
            Object renderConfig;
            FileWriter fileWriter;
            BaseType ammoType;
            File typeArmorRender;
            File typeAttachmentRender;
            Object renderConfig2;
            FileWriter fileWriter2;
            File typeGunRender;
            File contentPackDir;
            if (type.contentPack == null || !(contentPackDir = new File(ModularWarfare.MOD_DIR, type.contentPack)).exists() || !contentPackDir.isDirectory()) continue;
            File itemModelsDir = new File(contentPackDir, "/assets/modularwarfare/models/item");
            File gunRenderConfig = new File(contentPackDir, "/guns/render");
            File attachmentRenderConfig = new File(contentPackDir, "/attachments/render");
            File armorRenderConfig = new File(contentPackDir, "/armor/render");
            File ammoRenderConfig = new File(contentPackDir, "/ammo/render");
            File bulletRenderConfig = new File(contentPackDir, "/bullets/render");
            File backpacksRenderConfig = new File(contentPackDir, "/backpacks/render");
            File grenadeRenderConfig = new File(contentPackDir, "/grenades/render");
            if (!itemModelsDir.exists()) {
                itemModelsDir.mkdirs();
            }
            if (!gunRenderConfig.exists()) {
                gunRenderConfig.mkdirs();
            }
            if (!attachmentRenderConfig.exists()) {
                attachmentRenderConfig.mkdirs();
            }
            if (!armorRenderConfig.exists()) {
                armorRenderConfig.mkdirs();
            }
            if (!ammoRenderConfig.exists()) {
                ammoRenderConfig.mkdirs();
            }
            if (!bulletRenderConfig.exists()) {
                bulletRenderConfig.mkdirs();
            }
            if (!backpacksRenderConfig.exists()) {
                backpacksRenderConfig.mkdirs();
            }
            if (!grenadeRenderConfig.exists()) {
                grenadeRenderConfig.mkdirs();
            }
            File typeModel = new File(itemModelsDir, type.internalName + ".json");
            if (ModularWarfare.DEV_ENV) {
                if (type instanceof ArmorType) {
                    ArmorType armorType = (ArmorType)type;
                    for (ArmorType.ArmorInfo armorInfo : armorType.armorTypes.values()) {
                        String internalName = armorInfo.internalName != null ? armorInfo.internalName : armorType.internalName;
                        typeModel = new File(itemModelsDir, internalName + ".json");
                        try {
                            FileWriter fileWriter3 = new FileWriter(typeModel, llllllIl[1]);
                            gson.toJson((Object)this.createJson(type, internalName), (Appendable)fileWriter3);
                            fileWriter3.flush();
                            fileWriter3.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        FileWriter fileWriter4 = new FileWriter(typeModel, llllllIl[1]);
                        gson.toJson((Object)this.createJson(type), (Appendable)fileWriter4);
                        fileWriter4.flush();
                        fileWriter4.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!ModularWarfare.DEV_ENV) continue;
            if (type instanceof GunType && !(typeGunRender = new File(gunRenderConfig, type.internalName + ".render.json")).exists()) {
                try {
                    fileWriter2 = new FileWriter(typeGunRender, llllllIl[0]);
                    renderConfig2 = new GunRenderConfig();
                    ((GunRenderConfig)renderConfig2).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                    ((GunRenderConfig)renderConfig2).modelFileName = ((GunRenderConfig)renderConfig2).modelFileName + ".obj";
                    gson.toJson(renderConfig2, (Appendable)fileWriter2);
                    fileWriter2.flush();
                    fileWriter2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (type instanceof AttachmentType && !(typeAttachmentRender = new File(attachmentRenderConfig, type.internalName + ".render.json")).exists()) {
                try {
                    fileWriter2 = new FileWriter(typeAttachmentRender, llllllIl[0]);
                    renderConfig2 = new AttachmentRenderConfig();
                    ((AttachmentRenderConfig)renderConfig2).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                    ((AttachmentRenderConfig)renderConfig2).modelFileName = ((AttachmentRenderConfig)renderConfig2).modelFileName + ".obj";
                    gson.toJson(renderConfig2, (Appendable)fileWriter2);
                    fileWriter2.flush();
                    fileWriter2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (type instanceof ArmorType && !(typeArmorRender = new File(armorRenderConfig, type.internalName + ".render.json")).exists()) {
                try {
                    fileWriter2 = new FileWriter(typeArmorRender, llllllIl[0]);
                    renderConfig2 = new ArmorRenderConfig();
                    ((ArmorRenderConfig)renderConfig2).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                    ((ArmorRenderConfig)renderConfig2).modelFileName = ((ArmorRenderConfig)renderConfig2).modelFileName + ".obj";
                    gson.toJson(renderConfig2, (Appendable)fileWriter2);
                    fileWriter2.flush();
                    fileWriter2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (type instanceof AmmoType) {
                File typeAmmoRender;
                ammoType = (AmmoType)type;
                if (ammoType.isDynamicAmmo && !(typeAmmoRender = new File(ammoRenderConfig, type.internalName + ".render.json")).exists()) {
                    try {
                        fileWriter = new FileWriter(typeAmmoRender, llllllIl[0]);
                        renderConfig = new AmmoRenderConfig();
                        ((AmmoRenderConfig)renderConfig).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                        ((AmmoRenderConfig)renderConfig).modelFileName = ((AmmoRenderConfig)renderConfig).modelFileName + ".obj";
                        gson.toJson(renderConfig, (Appendable)fileWriter);
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (type instanceof BulletType) {
                File typeBulletRender;
                ammoType = (BulletType)type;
                if (((BulletType)ammoType).renderBulletModel && !(typeBulletRender = new File(bulletRenderConfig, type.internalName + ".render.json")).exists()) {
                    try {
                        fileWriter = new FileWriter(typeBulletRender, llllllIl[0]);
                        renderConfig = new BulletRenderConfig();
                        ((BulletRenderConfig)renderConfig).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                        ((BulletRenderConfig)renderConfig).modelFileName = ((BulletRenderConfig)renderConfig).modelFileName + ".obj";
                        gson.toJson(renderConfig, (Appendable)fileWriter);
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (type instanceof BackpackType && !(typeBackpackRender = new File(backpacksRenderConfig, type.internalName + ".render.json")).exists()) {
                try {
                    fileWriter2 = new FileWriter(typeBackpackRender, llllllIl[0]);
                    renderConfig2 = new BackpackRenderConfig();
                    ((BackpackRenderConfig)renderConfig2).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                    ((BackpackRenderConfig)renderConfig2).modelFileName = ((BackpackRenderConfig)renderConfig2).modelFileName + ".obj";
                    gson.toJson(renderConfig2, (Appendable)fileWriter2);
                    fileWriter2.flush();
                    fileWriter2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(type instanceof GrenadeType) || (typeGrenadeRender = new File(grenadeRenderConfig, type.internalName + ".render.json")).exists()) continue;
            try {
                fileWriter2 = new FileWriter(typeGrenadeRender, llllllIl[0]);
                renderConfig2 = new GrenadeRenderConfig();
                ((GrenadeRenderConfig)renderConfig2).modelFileName = type.internalName.replaceAll(type.contentPack + ".", "");
                ((GrenadeRenderConfig)renderConfig2).modelFileName = ((GrenadeRenderConfig)renderConfig2).modelFileName + ".obj";
                gson.toJson(renderConfig2, (Appendable)fileWriter2);
                fileWriter2.flush();
                fileWriter2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (SoundEvent soundEvent : modSounds.values()) {
            registry.register((IForgeRegistryEntry)soundEvent);
        }
        WeaponSoundType[] weaponSoundTypeArray = WeaponSoundType.values();
        int n = weaponSoundTypeArray.length;
        for (int i = llllllIl[1]; i < n; ++i) {
            WeaponSoundType weaponSoundType = weaponSoundTypeArray[i];
            if (weaponSoundType.defaultSound == null) continue;
            this.registerSound(weaponSoundType.defaultSound);
            registry.register((IForgeRegistryEntry)modSounds.get(weaponSoundType.defaultSound));
        }
    }

    @Override
    public void load() {
        SoundSystemConfig.setNumberNormalChannels((int)llllllIl[2]);
        SoundSystemConfig.setNumberStreamingChannels((int)llllllIl[3]);
        new KeyInputHandler();
        new ClientTickHandler();
        new ClientGunHandler();
        new RenderGuiHandler();
        renderHooks = new ClientRenderHooks();
        MinecraftForge.EVENT_BUS.register((Object)renderHooks);
        scopeUtils = new ScopeUtils();
        MinecraftForge.EVENT_BUS.register((Object)scopeUtils);
        attachmentUI = new AttachmentUI();
        MinecraftForge.EVENT_BUS.register((Object)attachmentUI);
        gunUI = new GunUI();
        MinecraftForge.EVENT_BUS.register((Object)gunUI);
        killFeedManager = new KillFeedManager();
        MinecraftForge.EVENT_BUS.register((Object)new KillFeedRender(killFeedManager));
        WeaponAnimations.registerAnimation("rifle", new AnimationRifle());
        WeaponAnimations.registerAnimation("rifle2", new AnimationRifle2());
        WeaponAnimations.registerAnimation("rifle3", new AnimationRifle3());
        WeaponAnimations.registerAnimation("rifle4", new AnimationRifle4());
        WeaponAnimations.registerAnimation("pistol", new AnimationPistol());
        WeaponAnimations.registerAnimation("revolver", new AnimationRevolver());
        WeaponAnimations.registerAnimation("shotgun", new AnimationShotgun());
        WeaponAnimations.registerAnimation("sniper", new AnimationSniperBottom());
        WeaponAnimations.registerAnimation("sniper_top", new AnimationSniperTop());
        WeaponAnimations.registerAnimation("sideclip", new AnimationSideClip());
        WeaponAnimations.registerAnimation("toprifle", new AnimationTopRifle());
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (RenderPlayer renderer : skinMap.values()) {
            this.setupLayers(renderer);
        }
    }

    private ItemModelExport createJson(BaseType type, String iconName) {
        ItemModelExport exportedModel = new ItemModelExport();
        exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[1]] = 0.4f;
        exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[0]] = 0.4f;
        exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[4]] = 0.4f;
        exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[1]] = 0.4f;
        exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[0]] = 0.4f;
        exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[4]] = 0.4f;
        exportedModel.setBaseLayer(type.getAssetDir() + "/" + iconName);
        return exportedModel;
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        for (ItemGun itemGun : ModularWarfare.gunTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemGun, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemGun.type.internalName));
        }
        for (ItemAmmo itemAmmo : ModularWarfare.ammoTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemAmmo, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemAmmo.type.internalName));
        }
        for (ItemAttachment itemAttachment : ModularWarfare.attachmentTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemAttachment, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemAttachment.type.internalName));
        }
        for (ItemBullet itemBullet : ModularWarfare.bulletTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBullet, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemBullet.type.internalName));
        }
        for (ItemMWArmor itemMWArmor : ModularWarfare.armorTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemMWArmor, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemMWArmor.internalName));
        }
        for (ItemSpecialArmor itemSpecialArmor : ModularWarfare.specialArmorTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemSpecialArmor, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemSpecialArmor.type.internalName));
        }
        for (ItemSpray itemSpray : ModularWarfare.sprayTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemSpray, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemSpray.type.internalName));
        }
        for (ItemBackpack itemBackpack : ModularWarfare.backpackTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBackpack, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemBackpack.type.internalName));
        }
        for (ItemGrenade itemGrenade : ModularWarfare.grenadeTypes.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemGrenade, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation("modularwarfare:" + itemGrenade.type.internalName));
        }
        ModelLoader.setCustomModelResourceLocation((Item)itemLight, (int)llllllIl[1], (ModelResourceLocation)new ModelResourceLocation(itemLight.getRegistryName(), "inventory"));
    }

    public void startPatches() {
        if (Loader.isModLoaded((String)"customnpcs")) {
            CustomNPCListener customNPCListener = new CustomNPCListener();
            MinecraftForge.EVENT_BUS.register((Object)customNPCListener);
        }
        if (Loader.isModLoaded((String)"galacticraftcore")) {
            try {
                galacticraftInterop = Class.forName("com.modularwarfare.client.patch.galacticraft.GCInteropImpl").asSubclass(GCCompatInterop.class).newInstance();
                ModularWarfare.LOGGER.info("Galatic Craft has been detected! Will attempt to patch.");
                galacticraftInterop.applyFix();
            }
            catch (Exception e) {
                e.printStackTrace();
                galacticraftInterop = new GCDummyInterop();
            }
        } else {
            galacticraftInterop = new GCDummyInterop();
        }
    }

    @Override
    public void reloadModels(boolean reloadSkins) {
        for (BaseType baseType : ModularWarfare.baseTypes) {
            if (!baseType.hasModel()) continue;
            baseType.reloadModel();
        }
        if (reloadSkins) {
            this.forceReload();
        }
    }

    private ItemModelExport createJson(BaseType type) {
        ItemModelExport exportedModel = new ItemModelExport();
        if (!(type instanceof GunType) && !(type instanceof GrenadeType)) {
            exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[1]] = 0.4f;
            exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[0]] = 0.4f;
            exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[4]] = 0.4f;
            exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[1]] = 0.4f;
            exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[0]] = 0.4f;
            exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[4]] = 0.4f;
        } else {
            exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[1]] = 0.0f;
            exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[0]] = 0.0f;
            exportedModel.display.thirdperson_lefthand.scale[ClientProxy.llllllIl[4]] = 0.0f;
            exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[1]] = 0.0f;
            exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[0]] = 0.0f;
            exportedModel.display.thirdperson_righthand.scale[ClientProxy.llllllIl[4]] = 0.0f;
        }
        exportedModel.setBaseLayer(type.getAssetDir() + "/" + (type.iconName != null ? type.iconName : type.internalName));
        return exportedModel;
    }

    private String getModelName(String in) {
        String[] split = in.split("\\.");
        if (split.length == llllllIl[0]) {
            return in;
        }
        if (split.length > llllllIl[0]) {
            String out = split[split.length - llllllIl[0]];
            for (int i = split.length - llllllIl[4]; i >= 0; --i) {
                out = split[i] + "." + out;
            }
            return out;
        }
        return in;
    }

    @Override
    public void preload() {
        SmoothSwingTicker smoothSwingTicker = new SmoothSwingTicker();
        Thread smoothTickThread = new Thread((Runnable)smoothSwingTicker, "SmoothSwingThread");
        smoothTickThread.start();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.startPatches();
    }

    static {
        ClientProxy.lIIlIIIl();
        modelDir = "com.modularwarfare.client.model.";
        modSounds = new HashMap();
        itemLight = new ItemLight("light");
    }

    @Override
    public <T> T loadModel(String s, String shortName, Class<T> typeClass) {
        if (s == null || shortName == null) {
            return null;
        }
        try {
            return typeClass.cast(Class.forName(modelDir + this.getModelName(s)).getConstructor(new Class[llllllIl[1]]).newInstance(new Object[llllllIl[1]]));
        }
        catch (Exception e) {
            ModularWarfare.LOGGER.error("Failed to load staticModel : " + shortName + " (" + s + ")");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void resetSens() {
        ClientRenderHooks.isAimingScope = llllllIl[1];
        ClientRenderHooks.isAiming = llllllIl[1];
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }
}

