/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.entity.decals;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityDecal
extends Entity {
    protected int maxTimeAlive;
    private static final DataParameter AGE;
    private static final DataParameter TEXTURE_NUMBER;
    private static final int[] lIIlIIllI;
    private static final DataParameter SEED;
    private static final DataParameter SIDE_ID;
    private static final DataParameter PERMANENT;
    private EnumDecalSide side;

    public void func_70014_b(NBTTagCompound var1) {
        var1.func_74757_a("Permanent", this.isPermanent());
        var1.func_74768_a("Age", this.getAge());
        var1.func_74768_a("Seed", this.getSeed());
        var1.func_74768_a("SideID", this.getSideID());
        var1.func_74768_a("TextureNumber", this.getTextureNumber());
    }

    public int getSideID() {
        return (Integer)this.field_70180_af.func_187225_a(SIDE_ID);
    }

    public void func_174812_G() {
    }

    public EntityDecal(World var1) {
        super(var1);
        this.field_70178_ae = lIIlIIllI[0];
        this.setSide(EnumDecalSide.ALL);
        this.func_70105_a(0.0f, 0.0f);
        this.maxTimeAlive = lIIlIIllI[1];
    }

    public void func_70071_h_() {
        this.field_70145_X = lIIlIIllI[0];
        if (!this.isPermanent()) {
            if (this.getAge() > -this.maxTimeAlive) {
                this.setAge(this.getAge() - lIIlIIllI[0]);
            } else {
                this.func_70106_y();
            }
        }
        this.field_70145_X = lIIlIIllI[2];
        this.func_189654_d(lIIlIIllI[0]);
    }

    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setPermanent(boolean bool) {
        this.field_70180_af.func_187227_b(PERMANENT, (Object)bool);
    }

    public int getTextureNumber() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE_NUMBER);
    }

    public boolean func_70067_L() {
        return lIIlIIllI[2];
    }

    public EnumDecalSide getSide() {
        return this.side;
    }

    protected boolean func_70041_e_() {
        return lIIlIIllI[2];
    }

    public abstract ResourceLocation getDecalTexture();

    public abstract int getTextureCount();

    public int getSeed() {
        return (Integer)this.field_70180_af.func_187225_a(SEED);
    }

    public void setSide(EnumDecalSide side) {
        this.side = side;
        this.setSideID(side.getId());
    }

    public void func_70037_a(NBTTagCompound var1) {
        this.setPermanent(var1.func_74767_n("Permanent"));
        this.setAge(var1.func_74762_e("Age"));
        this.setSeed(var1.func_74762_e("Seed"));
        this.setSideID(var1.func_74762_e("SideID"));
        if (var1.func_74764_b("TextureNumber")) {
            this.setTextureNumber(var1.func_74762_e("TextureNumber"));
        }
    }

    public void setSideID(int num) {
        this.field_70180_af.func_187227_b(SIDE_ID, (Object)num);
    }

    static {
        EntityDecal.lIlIIlll();
        PERMANENT = EntityDataManager.func_187226_a(EntityDecal.class, (DataSerializer)DataSerializers.field_187198_h);
        AGE = EntityDataManager.func_187226_a(EntityDecal.class, (DataSerializer)DataSerializers.field_187192_b);
        SEED = EntityDataManager.func_187226_a(EntityDecal.class, (DataSerializer)DataSerializers.field_187192_b);
        SIDE_ID = EntityDataManager.func_187226_a(EntityDecal.class, (DataSerializer)DataSerializers.field_187192_b);
        TEXTURE_NUMBER = EntityDataManager.func_187226_a(EntityDecal.class, (DataSerializer)DataSerializers.field_187192_b);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double var1) {
        return lIIlIIllI[0];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return lIIlIIllI[0];
    }

    public void setSeed(int num) {
        this.field_70180_af.func_187227_b(SEED, (Object)num);
    }

    public void setAge(int num) {
        this.field_70180_af.func_187227_b(AGE, (Object)num);
    }

    public boolean func_70094_T() {
        return lIIlIIllI[2];
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void setTextureNumber(int textureNumber) {
        this.field_70180_af.func_187227_b(TEXTURE_NUMBER, (Object)textureNumber);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PERMANENT, (Object)lIIlIIllI[2]);
        this.field_70180_af.func_187214_a(AGE, (Object)lIIlIIllI[2]);
        this.field_70180_af.func_187214_a(SEED, (Object)lIIlIIllI[2]);
        this.field_70180_af.func_187214_a(SIDE_ID, (Object)lIIlIIllI[2]);
        this.field_70180_af.func_187214_a(TEXTURE_NUMBER, (Object)this.field_70170_p.field_73012_v.nextInt(this.getTextureCount()));
    }

    private static void lIlIIlll() {
        lIIlIIllI = new int[3];
        EntityDecal.lIIlIIllI[0] = " ".length();
        EntityDecal.lIIlIIllI[1] = 0xFFFF8FCF & 0x73B4;
        EntityDecal.lIIlIIllI[2] = (4 ^ 0x46 ^ (0x4B ^ 0x68)) & (0x23 ^ 0x66 ^ (0x20 ^ 4) ^ -" ".length());
    }

    public boolean isPermanent() {
        return (Boolean)this.field_70180_af.func_187225_a(PERMANENT);
    }

    public float getAgeRatio() {
        return Math.max(0.0f, (float)(this.getAge() + this.maxTimeAlive) / (float)this.maxTimeAlive);
    }

    public static final class EnumDecalSide
    extends Enum<EnumDecalSide> {
        private static final int[] lIIlIII;
        public static final /* enum */ EnumDecalSide SOUTH;
        public static final /* enum */ EnumDecalSide WEST;
        public static final /* enum */ EnumDecalSide WALLS;
        public static final /* enum */ EnumDecalSide EAST;
        private final int id;
        public static final /* enum */ EnumDecalSide ALL;
        private static final /* synthetic */ EnumDecalSide[] $VALUES;
        public static final /* enum */ EnumDecalSide FLOOR;
        public static final /* enum */ EnumDecalSide NORTH;

        private EnumDecalSide(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        static {
            EnumDecalSide.lIllll();
            ALL = new EnumDecalSide(lIIlIII[0]);
            WALLS = new EnumDecalSide(lIIlIII[1]);
            FLOOR = new EnumDecalSide(lIIlIII[2]);
            NORTH = new EnumDecalSide(lIIlIII[3]);
            EAST = new EnumDecalSide(lIIlIII[4]);
            SOUTH = new EnumDecalSide(lIIlIII[5]);
            WEST = new EnumDecalSide(lIIlIII[6]);
            EnumDecalSide[] enumDecalSideArray = new EnumDecalSide[lIIlIII[7]];
            enumDecalSideArray[EnumDecalSide.lIIlIII[0]] = ALL;
            enumDecalSideArray[EnumDecalSide.lIIlIII[1]] = WALLS;
            enumDecalSideArray[EnumDecalSide.lIIlIII[2]] = FLOOR;
            enumDecalSideArray[EnumDecalSide.lIIlIII[3]] = NORTH;
            enumDecalSideArray[EnumDecalSide.lIIlIII[4]] = EAST;
            enumDecalSideArray[EnumDecalSide.lIIlIII[5]] = SOUTH;
            enumDecalSideArray[EnumDecalSide.lIIlIII[6]] = WEST;
            $VALUES = enumDecalSideArray;
        }

        private static void lIllll() {
            lIIlIII = new int[8];
            EnumDecalSide.lIIlIII[0] = (26 + 21 - -70 + 100 ^ 70 + 5 - 65 + 125) & (27 + 78 - -66 + 57 ^ 45 + 68 - -61 + 12 ^ -" ".length());
            EnumDecalSide.lIIlIII[1] = " ".length();
            EnumDecalSide.lIIlIII[2] = "  ".length();
            EnumDecalSide.lIIlIII[3] = "   ".length();
            EnumDecalSide.lIIlIII[4] = 0x28 ^ 0x2C;
            EnumDecalSide.lIIlIII[5] = 0x85 ^ 0x80;
            EnumDecalSide.lIIlIII[6] = 0x91 ^ 0x97;
            EnumDecalSide.lIIlIII[7] = 0x20 ^ 0x27;
        }

        public static EnumDecalSide getEnumFromId(int id) {
            return EnumDecalSide.values()[id];
        }

        public static EnumDecalSide[] values() {
            return (EnumDecalSide[])$VALUES.clone();
        }

        public static EnumDecalSide valueOf(String name) {
            return Enum.valueOf(EnumDecalSide.class, name);
        }
    }
}

