/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.guns;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.client.ClientProxy;
import com.modularwarfare.client.config.GunRenderConfig;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.common.guns.AttachmentEnum;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponFireMode;
import com.modularwarfare.common.guns.WeaponScopeType;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.common.network.PacketPlaySound;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.objects.SoundEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunType
extends BaseType {
    public String[] acceptedAmmo;
    public float recoilAimReducer = 0.8f;
    public boolean dynamicAmmo;
    public float randomRecoilYaw = 0.5f;
    public WeaponType weaponType;
    private SoundEntry[] weaponSounds;
    public boolean allowDefaultSounds;
    public float recoilYaw = 1.0f;
    public String[] acceptedBullets;
    public float moveSpeedModifier = 1.0f;
    public WeaponFireMode[] fireModes;
    public WeaponScopeType scopeType = WeaponScopeType.DEFAULT;
    public int weaponEffectiveRange;
    public float gunDamageHeadshotBonus = 0.0f;
    public float accuracySneakFactor = 0.75f;
    public float bulletSpread;
    public int numBullets;
    public transient int fireTickDelay;
    public Vec3d shellEjectOffsetAiming;
    public HashMap<WeaponSoundType, ArrayList<SoundEntry>> weaponSoundMap;
    public boolean isEnergyGun;
    public int roundsPerMin;
    @SideOnly(value=Side.CLIENT)
    public ModelBiped.ArmPose armPoseAiming;
    public float emptyPitch;
    private static final int[] lllII;
    public float randomRecoilPitch = 0.5f;
    public float gunDamage = 0.0f;
    public Vec3d shellEjectOffsetNormal;
    public float recoilPitch = 10.0f;
    public int weaponMaxRange = lllII[0];
    public int reloadTime;
    @SideOnly(value=Side.CLIENT)
    public ModelBiped.ArmPose armPose;
    public int numBurstRounds;
    public boolean allowSprintFiring;
    public boolean dropBulletCasing;
    public Integer internalAmmoStorage;
    public HashMap<AttachmentEnum, ArrayList<String>> acceptedAttachments;
    public Integer offhandReloadTime;

    @Override
    public void reloadModel() {
        this.model = new ModelGun(ModularWarfare.getRenderConfig(this, GunRenderConfig.class), this);
    }

    public static void setFireMode(ItemStack heldStack, WeaponFireMode fireMode) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            nbtTagCompound.func_74778_a("firemode", fireMode.name().toLowerCase());
            heldStack.func_77982_d(nbtTagCompound);
        }
    }

    public void playClientSound(EntityPlayer player, WeaponSoundType weaponSoundType) {
        if (this.weaponSoundMap.containsKey((Object)weaponSoundType)) {
            for (SoundEntry soundEntry : this.weaponSoundMap.get((Object)weaponSoundType)) {
                Minecraft.func_71410_x().field_71441_e.func_184133_a(player, player.func_180425_c(), ClientProxy.modSounds.get(soundEntry.soundName), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void playSoundPos(BlockPos pos, World world, WeaponSoundType weaponSoundType, EntityPlayer excluded, float volume) {
        block3: {
            block4: {
                if (weaponSoundType == null) break block3;
                if (!this.weaponSoundMap.containsKey((Object)weaponSoundType)) break block4;
                Random random = new Random();
                for (SoundEntry soundEntry : this.weaponSoundMap.get((Object)weaponSoundType)) {
                    int soundRange = soundEntry.soundRange != null ? soundEntry.soundRange : weaponSoundType.defaultRange;
                    for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> e.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) <= (double)soundRange ? lllII[2] : lllII[3])) {
                        if (hearingPlayer.equals((Object)excluded)) continue;
                        ModularWarfare.NETWORK.sendTo(new PacketPlaySound(pos, soundEntry.soundName, (float)(soundRange / lllII[8]) * soundEntry.soundVolumeMultiplier * volume, random.nextFloat() / soundEntry.soundRandomPitch + soundEntry.soundPitch), (EntityPlayerMP)hearingPlayer);
                    }
                }
                break block3;
            }
            if (!this.allowDefaultSounds || weaponSoundType.defaultSound == null) break block3;
            Random random = new Random();
            String soundName = weaponSoundType.defaultSound;
            float soundRange = weaponSoundType.defaultRange.intValue();
            for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> e.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) <= (double)soundRange ? lllII[2] : lllII[3])) {
                if (hearingPlayer.equals((Object)excluded)) continue;
                ModularWarfare.NETWORK.sendTo(new PacketPlaySound(pos, soundName, soundRange / 16.0f * 1.0f, random.nextFloat() / 5.0f + 1.0f), (EntityPlayerMP)hearingPlayer);
            }
        }
    }

    private static void lIlII() {
        lllII = new int[11];
        GunType.lllII[0] = (0x13 ^ 0x1A) + (100 + 16 - -11 + 71) - (0xC2 ^ 0x99) + (0xE6 ^ 0xB2);
        GunType.lllII[1] = 0x34 ^ 6;
        GunType.lllII[2] = " ".length();
        GunType.lllII[3] = (0x26 ^ 0x7D) & ~(0x29 ^ 0x72);
        GunType.lllII[4] = "   ".length();
        GunType.lllII[5] = 0x68 ^ 0x3B ^ (0x38 ^ 0x43);
        GunType.lllII[6] = -(0xFFFFE94F & 0x17B3) & (0xFFFF97BB & 0x6DF6);
        GunType.lllII[7] = "  ".length();
        GunType.lllII[8] = 0x98 ^ 0x88;
        GunType.lllII[9] = 0x5E ^ 0x16 ^ (0xE6 ^ 0xA8);
        GunType.lllII[10] = 0xA1 ^ 0xBC ^ (0xDC ^ 0xC4);
    }

    public void playSound(EntityLivingBase entityPlayer, WeaponSoundType weaponSoundType, ItemStack gunStack, @Nullable EntityPlayer excluded) {
        block7: {
            block8: {
                if (weaponSoundType == null) break block7;
                if (!this.weaponSoundMap.containsKey((Object)weaponSoundType)) break block8;
                BlockPos originPos = entityPlayer.func_180425_c();
                World world = entityPlayer.field_70170_p;
                Random random = new Random();
                for (SoundEntry soundEntry : this.weaponSoundMap.get((Object)weaponSoundType)) {
                    int soundRange = soundEntry.soundRange != null ? soundEntry.soundRange : weaponSoundType.defaultRange;
                    if (soundEntry.soundNameDistant != null && soundEntry.soundMaxRange != null) {
                        int maxSoundRange = soundEntry.soundMaxRange;
                        for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> e.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p()) <= (double)maxSoundRange ? lllII[2] : lllII[3])) {
                            if (hearingPlayer.equals((Object)excluded)) continue;
                            double distance = hearingPlayer.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p());
                            float volume = 0.0f;
                            String soundName = "";
                            if (((distance > (double)soundRange ? lllII[2] : lllII[3]) & (distance <= (double)maxSoundRange ? lllII[2] : lllII[3])) != 0) {
                                soundName = soundEntry.soundNameDistant;
                                volume = (float)((distance + (double)(maxSoundRange / lllII[9])) / 16.0 * (double)soundEntry.soundFarVolumeMultiplier);
                            } else {
                                soundName = soundEntry.soundName;
                                volume = (float)((distance + (double)(maxSoundRange / lllII[9])) / 16.0 * (double)soundEntry.soundVolumeMultiplier);
                            }
                            float customPitch = random.nextFloat() / soundEntry.soundRandomPitch + soundEntry.soundPitch;
                            float modifyPitch = ItemGun.getMagazineBullets(gunStack) <= lllII[10] && this.emptyPitch != 0.0f ? 0.3f - this.emptyPitch * (float)ItemGun.getMagazineBullets(gunStack) : 0.0f;
                            ModularWarfare.NETWORK.sendTo(new PacketPlaySound(originPos, soundName, volume, customPitch += modifyPitch), (EntityPlayerMP)hearingPlayer);
                        }
                        continue;
                    }
                    for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> e.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p()) <= (double)soundRange ? lllII[2] : lllII[3])) {
                        if (hearingPlayer.equals((Object)excluded)) continue;
                        ModularWarfare.NETWORK.sendTo(new PacketPlaySound(originPos, soundEntry.soundName, (float)(soundRange / lllII[8]) * soundEntry.soundVolumeMultiplier, random.nextFloat() / soundEntry.soundRandomPitch + soundEntry.soundPitch), (EntityPlayerMP)hearingPlayer);
                    }
                }
                break block7;
            }
            if (!this.allowDefaultSounds || weaponSoundType.defaultSound == null) break block7;
            BlockPos originPos = entityPlayer.func_180425_c();
            World world = entityPlayer.field_70170_p;
            Random random = new Random();
            String soundName = weaponSoundType.defaultSound;
            float soundRange = weaponSoundType.defaultRange.intValue();
            for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> e.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p()) <= (double)soundRange ? lllII[2] : lllII[3])) {
                ModularWarfare.NETWORK.sendTo(new PacketPlaySound(originPos, soundName, soundRange / 16.0f * 1.0f, random.nextFloat() / 5.0f + 1.0f), (EntityPlayerMP)hearingPlayer);
            }
        }
    }

    public void playSoundPos(BlockPos pos, World world, WeaponSoundType weaponSoundType) {
        this.playSoundPos(pos, world, weaponSoundType, null, 1.0f);
    }

    @Override
    public void loadExtraValues() {
        if (this.maxStackSize == null) {
            this.maxStackSize = lllII[2];
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.armPose = ModelBiped.ArmPose.BLOCK;
            this.armPoseAiming = ModelBiped.ArmPose.BOW_AND_ARROW;
        }
        this.loadBaseValues();
        this.fireTickDelay = lllII[6] / this.roundsPerMin;
        try {
            for (ArrayList<SoundEntry> entryList : this.weaponSoundMap.values()) {
                for (SoundEntry soundEntry : entryList) {
                    if (soundEntry.soundName != null) {
                        ModularWarfare.PROXY.registerSound(soundEntry.soundName);
                        if (soundEntry.soundNameDistant == null) continue;
                        ModularWarfare.PROXY.registerSound(soundEntry.soundNameDistant);
                        continue;
                    }
                    Object[] objectArray = new Object[lllII[7]];
                    objectArray[GunType.lllII[3]] = soundEntry.soundEvent;
                    objectArray[GunType.lllII[2]] = this.internalName;
                    ModularWarfare.LOGGER.error(String.format("Sound entry event '%s' has null soundName for type '%s'", objectArray));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void playSound(EntityLivingBase entityPlayer, WeaponSoundType weaponSoundType, ItemStack gunStack) {
        this.playSound(entityPlayer, weaponSoundType, gunStack, null);
    }

    static {
        GunType.lIlII();
    }

    public static boolean isPackAPunched(ItemStack heldStack) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            return nbtTagCompound.func_74764_b("punched") ? nbtTagCompound.func_74767_n("punched") : lllII[3];
        }
        return lllII[3];
    }

    public boolean hasFireMode(WeaponFireMode fireMode) {
        if (this.fireModes != null) {
            for (int i = lllII[3]; i < this.fireModes.length; ++i) {
                if (this.fireModes[i] != fireMode) continue;
                return lllII[2];
            }
        }
        return lllII[3];
    }

    public GunType() {
        this.weaponEffectiveRange = lllII[1];
        this.numBullets = lllII[2];
        this.roundsPerMin = lllII[2];
        this.fireTickDelay = lllII[3];
        this.numBurstRounds = lllII[4];
        this.isEnergyGun = lllII[3];
        WeaponFireMode[] weaponFireModeArray = new WeaponFireMode[lllII[2]];
        weaponFireModeArray[GunType.lllII[3]] = WeaponFireMode.SEMI;
        this.fireModes = weaponFireModeArray;
        this.reloadTime = lllII[5];
        this.dropBulletCasing = lllII[2];
        this.dynamicAmmo = lllII[3];
        this.allowSprintFiring = lllII[2];
        this.allowDefaultSounds = lllII[2];
        this.shellEjectOffsetNormal = new Vec3d(-1.0, 0.0, 1.0);
        this.shellEjectOffsetAiming = new Vec3d(0.0, (double)0.12f, 1.0);
        this.emptyPitch = 0.05f;
    }

    @Override
    public String getAssetDir() {
        return "guns";
    }

    public static WeaponFireMode getFireMode(ItemStack heldStack) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            return nbtTagCompound.func_74764_b("firemode") ? WeaponFireMode.fromString(nbtTagCompound.func_74779_i("firemode")) : null;
        }
        return null;
    }

    public static void addAttachment(ItemStack heldStack, AttachmentEnum type, ItemStack attachment) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            nbtTagCompound.func_74782_a("attachment_" + type.typeName, (NBTBase)attachment.func_77955_b(new NBTTagCompound()));
        }
    }

    public static void removeAttachment(ItemStack heldStack, AttachmentEnum type) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            nbtTagCompound.func_82580_o("attachment_" + type.typeName);
        }
    }

    public static ItemStack getAttachment(ItemStack heldStack, AttachmentEnum type) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            return nbtTagCompound.func_74764_b("attachment_" + type.typeName) ? new ItemStack(nbtTagCompound.func_74775_l("attachment_" + type.typeName)) : null;
        }
        return null;
    }

    public static void setPackAPunched(ItemStack heldStack, boolean bool) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            nbtTagCompound.func_74757_a("punched", bool);
            heldStack.func_77982_d(nbtTagCompound);
        }
    }
}

