/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.network;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketClientAnimation
extends PacketBase {
    public int reloadTime;
    public int fireDelay;
    public String wepType;
    public int reloadType;
    public float recoilPitch;
    public int reloadCount;
    private AnimationType animType;
    public float recoilYaw;

    public PacketClientAnimation() {
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
    }

    public PacketClientAnimation(String wepType, int reloadTime, int reloadCount, int reloadType) {
        this(AnimationType.Reload, wepType);
        this.reloadTime = reloadTime;
        this.reloadCount = reloadCount;
        this.reloadType = reloadType;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeByte(this.animType.i);
        PacketClientAnimation.writeUTF(data, this.wepType);
        switch (1.$SwitchMap$com$modularwarfare$common$network$PacketClientAnimation$AnimationType[this.animType.ordinal()]) {
            case 1: {
                data.writeInt(this.reloadTime);
                data.writeInt(this.reloadCount);
                data.writeInt(this.reloadType);
                break;
            }
            case 2: {
                data.writeInt(this.fireDelay);
                data.writeFloat(this.recoilPitch);
                data.writeFloat(this.recoilYaw);
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer clientPlayer) {
        switch (1.$SwitchMap$com$modularwarfare$common$network$PacketClientAnimation$AnimationType[this.animType.ordinal()]) {
            case 1: {
                ModularWarfare.PROXY.onReloadAnimation(clientPlayer, this.wepType, this.reloadTime, this.reloadCount, this.reloadType);
                break;
            }
            case 2: {
                ModularWarfare.PROXY.onShootAnimation(clientPlayer, this.wepType, this.fireDelay, this.recoilPitch, this.recoilYaw);
            }
        }
    }

    public PacketClientAnimation(String wepType, int fireDelay, float recoilPitch, float recoilYaw) {
        this(AnimationType.Shoot, wepType);
        this.fireDelay = fireDelay;
        this.recoilPitch = recoilPitch;
        this.recoilYaw = recoilYaw;
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.animType = AnimationType.getTypeFromInt(data.readByte());
        this.wepType = PacketClientAnimation.readUTF(data);
        switch (1.$SwitchMap$com$modularwarfare$common$network$PacketClientAnimation$AnimationType[this.animType.ordinal()]) {
            case 1: {
                this.reloadTime = data.readInt();
                this.reloadCount = data.readInt();
                this.reloadType = data.readInt();
                break;
            }
            case 2: {
                this.fireDelay = data.readInt();
                this.recoilPitch = data.readFloat();
                this.recoilYaw = data.readFloat();
            }
        }
    }

    public PacketClientAnimation(AnimationType animType, String wepType) {
        this.animType = animType;
        this.wepType = wepType;
    }

    private static final class AnimationType
    extends Enum<AnimationType> {
        public static final /* enum */ AnimationType Shoot;
        public int i;
        public static final /* enum */ AnimationType Reload;
        private static final /* synthetic */ AnimationType[] $VALUES;
        private static final int[] llIIlll;

        static {
            AnimationType.lIIIIlI();
            Shoot = new AnimationType(llIIlll[0]);
            Reload = new AnimationType(llIIlll[1]);
            AnimationType[] animationTypeArray = new AnimationType[llIIlll[2]];
            animationTypeArray[AnimationType.llIIlll[0]] = Shoot;
            animationTypeArray[AnimationType.llIIlll[1]] = Reload;
            $VALUES = animationTypeArray;
        }

        private static void lIIIIlI() {
            llIIlll = new int[3];
            AnimationType.llIIlll[0] = (87 + 71 - -18 + 14 ^ 145 + 35 - 6 + 0) & (103 + 106 - 136 + 103 ^ 45 + 18 - -56 + 41 ^ -" ".length());
            AnimationType.llIIlll[1] = " ".length();
            AnimationType.llIIlll[2] = "  ".length();
        }

        public static AnimationType[] values() {
            return (AnimationType[])$VALUES.clone();
        }

        public static AnimationType valueOf(String name) {
            return Enum.valueOf(AnimationType.class, name);
        }

        public static AnimationType getTypeFromInt(int i) {
            return i == 0 ? Shoot : Reload;
        }

        private AnimationType(int i) {
            this.i = i;
        }
    }
}

