/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.network;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.WeaponReloadEvent;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.common.guns.AmmoType;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemAmmo;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.handler.ServerTickHandler;
import com.modularwarfare.common.network.PacketBase;
import com.modularwarfare.common.network.PacketClientAnimation;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PacketGunReload
extends PacketBase {
    public boolean unload = llllIlll[0];
    private static final int[] llllIlll;

    public Integer unloadBullets(EntityPlayerMP entityPlayer, ItemStack targetStack) {
        NBTTagCompound nbtTagCompound = targetStack.func_77978_p();
        if (nbtTagCompound.func_74764_b("bullet")) {
            ItemStack returningBullet = new ItemStack(nbtTagCompound.func_74775_l("bullet"));
            int bulletsToUnload = llllIlll[0];
            if (!nbtTagCompound.func_74764_b("magcount")) {
                bulletsToUnload = targetStack.func_77978_p().func_74762_e("ammocount");
                nbtTagCompound.func_74768_a("ammocount", llllIlll[0]);
            } else {
                AmmoType ammoType = ((ItemAmmo)targetStack.func_77973_b()).type;
                for (int i = llllIlll[1]; i < ammoType.magazineCount + llllIlll[1]; ++i) {
                    bulletsToUnload += nbtTagCompound.func_74762_e("ammocount" + i);
                    nbtTagCompound.func_74768_a("ammocount" + i, llllIlll[0]);
                }
            }
            int animBulletsToReload = bulletsToUnload;
            while (bulletsToUnload > 0) {
                if (bulletsToUnload <= llllIlll[3]) {
                    ItemStack clonedBullet = returningBullet;
                    clonedBullet.func_190920_e(bulletsToUnload);
                    entityPlayer.field_71071_by.func_70441_a(clonedBullet);
                    bulletsToUnload -= bulletsToUnload;
                    continue;
                }
                ItemStack clonedBullet = returningBullet;
                clonedBullet.func_190920_e(llllIlll[3]);
                entityPlayer.field_71071_by.func_70441_a(clonedBullet);
                bulletsToUnload -= 64;
            }
            nbtTagCompound.func_82580_o("bullet");
            return animBulletsToReload;
        }
        return null;
    }

    @Override
    public void handleClientSide(EntityPlayer entityPlayer) {
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.unload = data.readBoolean();
    }

    public void handleBulletGunReload(EntityPlayerMP entityPlayer, ItemStack gunStack, ItemGun itemGun, GunType gunType, InventoryPlayer inventory) {
        if (ServerTickHandler.playerReloadCooldown.containsKey(entityPlayer.func_110124_au())) {
            return;
        }
        if (gunType.acceptedBullets != null) {
            if (!this.unload) {
                int loadingCount;
                int n;
                ItemStack itemStack;
                if (gunStack.func_77978_p() != null && gunType.internalAmmoStorage != null && gunStack.func_77978_p().func_74775_l("bullet") != null && gunStack.func_77978_p().func_74762_e("ammocount") >= gunType.internalAmmoStorage) {
                    return;
                }
                NBTTagCompound nbtTagCompound = gunStack.func_77978_p();
                boolean offhandedReload = llllIlll[0];
                int highestBulletCount = llllIlll[0];
                ItemStack bulletStackToLoad = null;
                Integer bulletStackSlotToLoad = null;
                if (inventory.field_184439_c.get(llllIlll[0]) != ItemStack.field_190927_a && (itemStack = (ItemStack)inventory.field_184439_c.get(llllIlll[0])) != null && itemStack.func_77973_b() instanceof ItemBullet) {
                    ItemBullet itemBullet = (ItemBullet)itemStack.func_77973_b();
                    String[] stringArray = gunType.acceptedBullets;
                    int n2 = stringArray.length;
                    for (n = llllIlll[0]; n < n2; ++n) {
                        String bulletName = stringArray[n];
                        if (!bulletName.equalsIgnoreCase(itemBullet.baseType.internalName)) continue;
                        offhandedReload = llllIlll[1];
                        bulletStackToLoad = itemStack;
                        break;
                    }
                }
                if (!offhandedReload) {
                    for (int i = llllIlll[0]; i < inventory.func_70302_i_(); ++i) {
                        ItemStack itemStack2 = inventory.func_70301_a(i);
                        if (itemStack2 == null || !(itemStack2.func_77973_b() instanceof ItemBullet)) continue;
                        ItemBullet itemBullet = (ItemBullet)itemStack2.func_77973_b();
                        String[] stringArray = gunType.acceptedBullets;
                        n = stringArray.length;
                        for (int bulletName = llllIlll[0]; bulletName < n; ++bulletName) {
                            int count;
                            String bulletName2 = stringArray[bulletName];
                            if (!bulletName2.equalsIgnoreCase(itemBullet.baseType.internalName) || (count = itemStack2.func_190916_E()) <= highestBulletCount) continue;
                            bulletStackToLoad = itemStack2;
                            highestBulletCount = count;
                            bulletStackSlotToLoad = i;
                        }
                    }
                }
                if (bulletStackToLoad == null) {
                    return;
                }
                boolean loadOnly = llllIlll[0];
                WeaponReloadEvent.Pre preReloadEvent = new WeaponReloadEvent.Pre((EntityPlayer)entityPlayer, gunStack, itemGun, offhandedReload, llllIlll[0]);
                MinecraftForge.EVENT_BUS.post((Event)preReloadEvent);
                if (preReloadEvent.isCanceled()) {
                    return;
                }
                ItemBullet bulletItemToLoad = (ItemBullet)bulletStackToLoad.func_77973_b();
                if (nbtTagCompound.func_74764_b("bullet")) {
                    ItemStack currentBullet = new ItemStack(nbtTagCompound.func_74775_l("bullet"));
                    ItemBullet currentBulletItem = (ItemBullet)currentBullet.func_77973_b();
                    if (!currentBulletItem.baseType.internalName.equalsIgnoreCase(bulletItemToLoad.baseType.internalName)) {
                        this.unloadBullets(entityPlayer, gunStack);
                    }
                } else {
                    loadOnly = llllIlll[1];
                }
                ItemStack loadingItemStack = bulletStackToLoad.func_77946_l();
                int reserve = bulletStackToLoad.func_190916_E();
                int ammoCount = gunStack.func_77978_p().func_74762_e("ammocount");
                int amountToLoad = gunType.internalAmmoStorage - ammoCount;
                if (amountToLoad >= loadingItemStack.func_190916_E()) {
                    loadingCount = loadingItemStack.func_190916_E();
                    reserve = llllIlll[0];
                } else {
                    loadingCount = amountToLoad;
                    reserve = loadingItemStack.func_190916_E() - loadingCount;
                }
                gunStack.func_77978_p().func_74768_a("ammocount", ammoCount + loadingCount);
                gunStack.func_77978_p().func_74782_a("bullet", (NBTBase)loadingItemStack.func_77955_b(new NBTTagCompound()));
                bulletStackToLoad.func_190920_e(reserve);
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    if (offhandedReload) {
                        inventory.field_184439_c.set(llllIlll[0], (Object)(reserve >= llllIlll[1] ? bulletStackToLoad : ItemStack.field_190927_a));
                    } else {
                        inventory.func_70299_a(bulletStackSlotToLoad.intValue(), reserve >= llllIlll[1] ? bulletStackToLoad : ItemStack.field_190927_a);
                    }
                }
                WeaponReloadEvent.Post postReloadEvent = new WeaponReloadEvent.Post((EntityPlayer)entityPlayer, gunStack, itemGun, offhandedReload, loadOnly, llllIlll[0], preReloadEvent.getReloadTime(), loadingCount);
                MinecraftForge.EVENT_BUS.post((Event)postReloadEvent);
                ServerTickHandler.playerReloadCooldown.put(entityPlayer.func_110124_au(), preReloadEvent.getReloadTime());
                int reloadType = (postReloadEvent.isLoadOnly() ? ReloadType.Load : (postReloadEvent.isUnload() ? ReloadType.Unload : ReloadType.Full)).i;
                ModularWarfare.NETWORK.sendTo(new PacketClientAnimation(gunType.internalName, postReloadEvent.getReloadTime(), postReloadEvent.getReloadCount(), reloadType), entityPlayer);
            } else {
                WeaponReloadEvent.Pre preReloadEvent = new WeaponReloadEvent.Pre((EntityPlayer)entityPlayer, gunStack, itemGun, llllIlll[0], llllIlll[0]);
                MinecraftForge.EVENT_BUS.post((Event)preReloadEvent);
                if (preReloadEvent.isCanceled()) {
                    return;
                }
                Integer bulletCount = this.unloadBullets(entityPlayer, gunStack);
                if (bulletCount != null) {
                    WeaponReloadEvent.Post postReloadEvent = new WeaponReloadEvent.Post((EntityPlayer)entityPlayer, gunStack, itemGun, llllIlll[0], llllIlll[0], llllIlll[1], preReloadEvent.getReloadTime(), (int)bulletCount);
                    MinecraftForge.EVENT_BUS.post((Event)postReloadEvent);
                    if (postReloadEvent.isUnload()) {
                        gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Unload, gunStack);
                    }
                }
            }
        }
    }

    public void handleMagGunReload(EntityPlayerMP entityPlayer, ItemStack gunStack, ItemGun itemGun, GunType gunType, InventoryPlayer inventory) {
        if (ServerTickHandler.playerReloadCooldown.containsKey(entityPlayer.func_110124_au())) {
            return;
        }
        if (!this.unload) {
            int highestAmmo;
            ItemStack itemStack;
            NBTTagCompound nbtTagCompound = gunStack.func_77978_p();
            boolean hasAmmoLoaded = ItemGun.hasAmmoLoaded(gunStack);
            boolean offhandedReload = llllIlll[0];
            ItemStack ammoStackToLoad = null;
            Integer ammoStackSlotToLoad = null;
            Integer highestAmmoCount = llllIlll[0];
            Integer multiMagToLoad = null;
            if (inventory.field_184439_c.get(llllIlll[0]) != ItemStack.field_190927_a && (itemStack = (ItemStack)inventory.field_184439_c.get(llllIlll[0])) != null && itemStack.func_77973_b() instanceof ItemAmmo) {
                ItemAmmo itemAmmo = (ItemAmmo)itemStack.func_77973_b();
                String[] stringArray = gunType.acceptedAmmo;
                int n = stringArray.length;
                for (int i = llllIlll[0]; i < n; ++i) {
                    String ammoName = stringArray[i];
                    if (!ammoName.equalsIgnoreCase(itemAmmo.baseType.internalName)) continue;
                    offhandedReload = llllIlll[1];
                    ammoStackToLoad = itemStack;
                    break;
                }
            }
            if (hasAmmoLoaded) {
                ItemStack currentAmmoStack = new ItemStack(nbtTagCompound.func_74775_l("ammo"));
                ItemAmmo currentAmmoItem = (ItemAmmo)currentAmmoStack.func_77973_b();
                NBTTagCompound currentAmmoTag = currentAmmoStack.func_77978_p();
                if (currentAmmoTag.func_74764_b("magcount")) {
                    Integer selectedMagazine = null;
                    highestAmmo = llllIlll[2];
                    for (int j = llllIlll[1]; j < currentAmmoItem.type.magazineCount + llllIlll[1]; ++j) {
                        int ammoCount = currentAmmoTag.func_74762_e("ammocount" + j);
                        if (ammoCount <= highestAmmo) continue;
                        selectedMagazine = j;
                        highestAmmo = ammoCount;
                    }
                    if (selectedMagazine != null) {
                        currentAmmoTag.func_74768_a("magcount", selectedMagazine.intValue());
                        ammoStackToLoad = currentAmmoStack;
                        highestAmmoCount = highestAmmo;
                    }
                }
            }
            if (!offhandedReload) {
                for (int i = llllIlll[0]; i < inventory.func_70302_i_(); ++i) {
                    ItemStack itemStack2 = inventory.func_70301_a(i);
                    if (itemStack2 == null || !(itemStack2.func_77973_b() instanceof ItemAmmo)) continue;
                    ItemAmmo itemAmmo = (ItemAmmo)itemStack2.func_77973_b();
                    String[] selectedMagazine = gunType.acceptedAmmo;
                    highestAmmo = selectedMagazine.length;
                    for (int j = llllIlll[0]; j < highestAmmo; ++j) {
                        String ammoName = selectedMagazine[j];
                        if (!ammoName.equalsIgnoreCase(itemAmmo.baseType.internalName)) continue;
                        if (itemAmmo.type.magazineCount > llllIlll[1]) {
                            for (int j2 = llllIlll[1]; j2 < itemAmmo.type.magazineCount + llllIlll[1]; ++j2) {
                                int ammoCount = itemStack2.func_77978_p().func_74762_e("ammocount" + j2);
                                if (ammoCount <= highestAmmoCount) continue;
                                ammoStackToLoad = itemStack2;
                                ammoStackSlotToLoad = i;
                                highestAmmoCount = ammoCount;
                                multiMagToLoad = j2;
                            }
                            continue;
                        }
                        int ammoCount = itemStack2.func_77978_p().func_74762_e("ammocount");
                        if (ammoCount <= highestAmmoCount) continue;
                        ammoStackToLoad = itemStack2;
                        highestAmmoCount = ammoCount;
                        ammoStackSlotToLoad = i;
                    }
                }
            }
            if (ammoStackToLoad == null) {
                return;
            }
            if (!ammoStackToLoad.func_77978_p().func_74764_b("magcount")) {
                multiMagToLoad = null;
            }
            boolean multiMagReload = hasAmmoLoaded && ammoStackToLoad.func_77978_p().func_74764_b("magcount") ? llllIlll[1] : llllIlll[0];
            boolean loadOnly = llllIlll[0];
            WeaponReloadEvent.Pre preReloadEvent = new WeaponReloadEvent.Pre((EntityPlayer)entityPlayer, gunStack, itemGun, offhandedReload, multiMagReload);
            MinecraftForge.EVENT_BUS.post((Event)preReloadEvent);
            if (preReloadEvent.isCanceled()) {
                return;
            }
            if (gunStack.func_77978_p().func_74764_b("shotsremaining") && gunStack.func_77978_p().func_74762_e("shotsremaining") > 0) {
                gunStack.func_77978_p().func_74768_a("shotsremaining", llllIlll[0]);
            }
            if (!multiMagReload || multiMagToLoad != null) {
                if (ItemGun.hasAmmoLoaded(gunStack)) {
                    this.unloadAmmo(entityPlayer, gunStack);
                } else {
                    loadOnly = llllIlll[1];
                }
            }
            ItemStack loadingItemStack = ammoStackToLoad.func_77946_l();
            loadingItemStack.func_190920_e(llllIlll[1]);
            if (multiMagReload && multiMagToLoad != null) {
                loadingItemStack.func_77978_p().func_74768_a("magcount", multiMagToLoad.intValue());
            }
            nbtTagCompound.func_74782_a("ammo", (NBTBase)loadingItemStack.func_77955_b(new NBTTagCompound()));
            ammoStackToLoad.func_190920_e(ammoStackToLoad.func_190916_E() - llllIlll[1]);
            if (ammoStackSlotToLoad != null && !entityPlayer.field_71075_bZ.field_75098_d) {
                if (offhandedReload) {
                    inventory.field_184439_c.set(llllIlll[0], (Object)(ammoStackToLoad.func_190916_E() >= llllIlll[1] ? ammoStackToLoad : ItemStack.field_190927_a));
                } else {
                    inventory.func_70299_a(ammoStackSlotToLoad.intValue(), ammoStackToLoad.func_190916_E() >= llllIlll[1] ? ammoStackToLoad : ItemStack.field_190927_a);
                }
            }
            int reloadTime = preReloadEvent.getReloadTime();
            if (loadingItemStack.func_77973_b() instanceof ItemAmmo) {
                ItemAmmo itemAmmo = (ItemAmmo)loadingItemStack.func_77973_b();
                reloadTime = (int)((float)reloadTime * itemAmmo.type.reloadTimeFactor);
            }
            WeaponReloadEvent.Post postReloadEvent = new WeaponReloadEvent.Post((EntityPlayer)entityPlayer, gunStack, itemGun, offhandedReload, multiMagReload, loadOnly, llllIlll[0], reloadTime);
            MinecraftForge.EVENT_BUS.post((Event)postReloadEvent);
            if (postReloadEvent.isLoadOnly()) {
                gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Load, gunStack);
            } else if (!postReloadEvent.isLoadOnly() && !postReloadEvent.isUnload()) {
                gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Reload, gunStack);
            }
            int reloadType = (postReloadEvent.isLoadOnly() ? ReloadType.Load : (postReloadEvent.isUnload() ? ReloadType.Unload : ReloadType.Full)).i;
            ModularWarfare.NETWORK.sendTo(new PacketClientAnimation(gunType.internalName, reloadTime, postReloadEvent.getReloadCount(), reloadType), entityPlayer);
            ServerTickHandler.playerReloadCooldown.put(entityPlayer.func_110124_au(), reloadTime);
        } else {
            WeaponReloadEvent.Pre preReloadEvent = new WeaponReloadEvent.Pre((EntityPlayer)entityPlayer, gunStack, itemGun, llllIlll[0], llllIlll[0]);
            MinecraftForge.EVENT_BUS.post((Event)preReloadEvent);
            if (preReloadEvent.isCanceled()) {
                return;
            }
            if (this.unloadAmmo(entityPlayer, gunStack)) {
                WeaponReloadEvent.Post postReloadEvent = new WeaponReloadEvent.Post((EntityPlayer)entityPlayer, gunStack, itemGun, llllIlll[0], llllIlll[0], llllIlll[0], llllIlll[1], preReloadEvent.getReloadTime());
                MinecraftForge.EVENT_BUS.post((Event)postReloadEvent);
                if (postReloadEvent.isUnload()) {
                    gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Unload, gunStack);
                }
            }
        }
    }

    public PacketGunReload(boolean unload) {
        this.unload = unload;
    }

    @Override
    public void handleServerSide(EntityPlayerMP entityPlayer) {
        if (entityPlayer.func_184614_ca() != null) {
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun) {
                ItemStack gunStack = entityPlayer.func_184614_ca();
                ItemGun itemGun = (ItemGun)entityPlayer.func_184614_ca().func_77973_b();
                GunType gunType = itemGun.type;
                InventoryPlayer inventory = entityPlayer.field_71071_by;
                if (gunType.acceptedAmmo != null) {
                    this.handleMagGunReload(entityPlayer, gunStack, itemGun, gunType, inventory);
                } else {
                    this.handleBulletGunReload(entityPlayer, gunStack, itemGun, gunType, inventory);
                }
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemAmmo) {
                this.handleAmmoReload(entityPlayer);
            }
        }
    }

    public boolean unloadAmmo(EntityPlayerMP entityPlayer, ItemStack gunStack) {
        NBTTagCompound nbtTagCompound = gunStack.func_77978_p();
        if (ItemGun.hasAmmoLoaded(gunStack)) {
            ItemStack returningAmmo = new ItemStack(nbtTagCompound.func_74775_l("ammo"));
            ItemAmmo returningAmmoItem = (ItemAmmo)returningAmmo.func_77973_b();
            if (returningAmmoItem.type.subAmmo != null || ItemAmmo.hasAmmo(returningAmmo) || returningAmmoItem.type.allowEmptyMagazines) {
                int currentAmmoCount = ItemGun.getMagazineBullets(gunStack);
                returningAmmo.func_77964_b(returningAmmo.func_77958_k() - currentAmmoCount);
                entityPlayer.field_71071_by.func_70441_a(returningAmmo);
            }
            nbtTagCompound.func_82580_o("ammo");
            return llllIlll[1];
        }
        return llllIlll[0];
    }

    public PacketGunReload() {
    }

    static {
        PacketGunReload.lIIIllII();
    }

    private static void lIIIllII() {
        llllIlll = new int[4];
        PacketGunReload.llllIlll[0] = (0x32 ^ 0x13 ^ (0x1B ^ 0x32)) & (97 + 200 - 174 + 80 ^ 60 + 130 - 169 + 174 ^ -" ".length());
        PacketGunReload.llllIlll[1] = " ".length();
        PacketGunReload.llllIlll[2] = -" ".length();
        PacketGunReload.llllIlll[3] = 0x5F ^ 0x1F;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeBoolean(this.unload);
    }

    public void handleAmmoReload(EntityPlayerMP entityPlayer) {
        ItemStack ammoStack = entityPlayer.func_184614_ca();
        ItemAmmo itemAmmo = (ItemAmmo)entityPlayer.func_184614_ca().func_77973_b();
        AmmoType ammoType = itemAmmo.type;
        InventoryPlayer inventory = entityPlayer.field_71071_by;
        if (ServerTickHandler.playerReloadCooldown.containsKey(entityPlayer.func_110124_au())) {
            return;
        }
        if (ammoType.subAmmo != null) {
            if (!this.unload) {
                int n;
                ItemStack itemStack;
                NBTTagCompound nbtTagCompound = ammoStack.func_77978_p();
                int offhandedReload = llllIlll[0];
                int highestBulletCount = llllIlll[0];
                ItemStack bulletStackToLoad = null;
                Integer bulletStackSlotToLoad = null;
                if (inventory.field_184439_c.get(llllIlll[0]) != ItemStack.field_190927_a && (itemStack = (ItemStack)inventory.field_184439_c.get(llllIlll[0])) != null && itemStack.func_77973_b() instanceof ItemBullet) {
                    ItemBullet itemBullet = (ItemBullet)itemStack.func_77973_b();
                    String[] stringArray = ammoType.subAmmo;
                    int n2 = stringArray.length;
                    for (n = llllIlll[0]; n < n2; ++n) {
                        String ammoName = stringArray[n];
                        if (!ammoName.equalsIgnoreCase(itemBullet.baseType.internalName)) continue;
                        offhandedReload = llllIlll[1];
                        bulletStackToLoad = itemStack;
                        break;
                    }
                }
                if (offhandedReload == 0) {
                    for (int i = llllIlll[0]; i < inventory.func_70302_i_(); ++i) {
                        ItemStack itemStack2 = inventory.func_70301_a(i);
                        if (itemStack2 == null || !(itemStack2.func_77973_b() instanceof ItemBullet)) continue;
                        ItemBullet itemBullet = (ItemBullet)itemStack2.func_77973_b();
                        String[] stringArray = ammoType.subAmmo;
                        n = stringArray.length;
                        for (int ammoName = llllIlll[0]; ammoName < n; ++ammoName) {
                            int count;
                            String bulletName = stringArray[ammoName];
                            if (!bulletName.equalsIgnoreCase(itemBullet.baseType.internalName) || (count = itemStack2.func_190916_E()) <= highestBulletCount) continue;
                            bulletStackToLoad = itemStack2;
                            highestBulletCount = count;
                            bulletStackSlotToLoad = i;
                        }
                    }
                }
                if (bulletStackToLoad == null) {
                    return;
                }
                ItemBullet bulletItemToLoad = (ItemBullet)bulletStackToLoad.func_77973_b();
                if (nbtTagCompound.func_74764_b("bullet")) {
                    ItemStack currentBullet = new ItemStack(nbtTagCompound.func_74775_l("bullet"));
                    ItemBullet currentBulletItem = (ItemBullet)currentBullet.func_77973_b();
                    if (!currentBulletItem.baseType.internalName.equalsIgnoreCase(bulletItemToLoad.baseType.internalName)) {
                        this.unloadBullets(entityPlayer, ammoStack);
                    }
                }
                ItemStack loadingItemStack = bulletStackToLoad.func_77946_l();
                int reserve = bulletStackToLoad.func_190916_E();
                if (!nbtTagCompound.func_74764_b("magcount")) {
                    int loadingCount;
                    int ammoCount = ammoStack.func_77978_p().func_74762_e("ammocount");
                    int amountToLoad = ammoType.ammoCapacity - ammoCount;
                    if (amountToLoad >= loadingItemStack.func_190916_E()) {
                        loadingCount = loadingItemStack.func_190916_E();
                        reserve = llllIlll[0];
                    } else {
                        loadingCount = amountToLoad;
                        reserve = loadingItemStack.func_190916_E() - loadingCount;
                    }
                    ammoStack.func_77978_p().func_74768_a("ammocount", ammoCount + loadingCount);
                } else {
                    for (int i = llllIlll[1]; i < ammoType.magazineCount + llllIlll[1]; ++i) {
                        int loadingCount;
                        int ammoCount = ammoStack.func_77978_p().func_74762_e("ammocount" + i);
                        if (ammoCount >= ammoType.ammoCapacity) continue;
                        int amountToLoad = ammoType.ammoCapacity - ammoCount;
                        if (amountToLoad >= reserve) {
                            loadingCount = reserve;
                            reserve = llllIlll[0];
                        } else {
                            loadingCount = amountToLoad;
                            reserve -= loadingCount;
                        }
                        ammoStack.func_77978_p().func_74768_a("ammocount" + i, ammoCount + loadingCount);
                        if (reserve == 0) break;
                    }
                }
                ammoStack.func_77978_p().func_74782_a("bullet", (NBTBase)loadingItemStack.func_77955_b(new NBTTagCompound()));
                bulletStackToLoad.func_190920_e(reserve);
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    if (offhandedReload != 0) {
                        inventory.field_184439_c.set(llllIlll[0], (Object)(reserve >= llllIlll[1] ? bulletStackToLoad : ItemStack.field_190927_a));
                    } else {
                        inventory.func_70299_a(bulletStackSlotToLoad.intValue(), reserve >= llllIlll[1] ? bulletStackToLoad : ItemStack.field_190927_a);
                    }
                }
            } else {
                this.unloadBullets(entityPlayer, ammoStack);
            }
            String key = itemAmmo.type.magazineCount > llllIlll[1] ? "ammocount" + ammoStack.func_77978_p().func_74762_e("magcount") : "ammocount";
            int ammoCount = ammoStack.func_77978_p().func_74762_e(key);
            ammoStack.func_77964_b(ammoStack.func_77958_k() - ammoCount);
        }
    }
}

