/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.utility;

import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.GlStateManager;

public final class ColorUtils {
    private static final int[] llIIllll;

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> llIIllll[4] & llIIllll[5]) / 255.0f;
        float green = (float)(color >> llIIllll[6] & llIIllll[5]) / 255.0f;
        float blue = (float)(color & llIIllll[5]) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    static {
        ColorUtils.lllIlll();
    }

    public static int getRGB(@Nullable Color color) {
        return color == null ? llIIllll[0] : ColorUtils.getRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Nonnull
    public static Vector4f toFloat(@Nonnull Color color) {
        float[] rgba = color.getComponents(null);
        return new Vector4f(rgba[llIIllll[0]], rgba[llIIllll[1]], rgba[llIIllll[2]], rgba[llIIllll[3]]);
    }

    public static int getRGB(@Nonnull Vector3f rgb) {
        return ColorUtils.getRGB(rgb.x, rgb.y, rgb.z);
    }

    private ColorUtils() {
    }

    public static int toHex(int r, int g, int b) {
        int hex = llIIllll[0];
        hex |= r << llIIllll[4];
        hex |= g << llIIllll[6];
        return hex |= b;
    }

    @Nonnull
    public static Vector3f toFloat(int rgb) {
        int r = rgb >> llIIllll[4] & llIIllll[5];
        int g = rgb >> llIIllll[6] & llIIllll[5];
        int b = rgb & llIIllll[5];
        return new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static int getRGBA(@Nonnull Vector4f col) {
        return ColorUtils.getRGBA(col.x, col.y, col.z, col.w);
    }

    public static int getRGB(int r, int g, int b) {
        return (r & llIIllll[5]) << llIIllll[4] | (g & llIIllll[5]) << llIIllll[6] | b & llIIllll[5];
    }

    public static int getARGB(@Nullable Color color) {
        return color == null ? llIIllll[0] : ColorUtils.getRGBA(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getRGBA(int r, int g, int b, int a) {
        return (r & llIIllll[5]) << llIIllll[7] | (g & llIIllll[5]) << llIIllll[4] | (b & llIIllll[5]) << llIIllll[6] | a & llIIllll[5];
    }

    public static int getRGBA(@Nullable Color color) {
        return color == null ? llIIllll[0] : ColorUtils.getRGBA(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static int getARGB(int r, int g, int b, int a) {
        return (a & llIIllll[5]) << llIIllll[7] | (r & llIIllll[5]) << llIIllll[4] | (g & llIIllll[5]) << llIIllll[6] | b & llIIllll[5];
    }

    private static void lllIlll() {
        llIIllll = new int[8];
        ColorUtils.llIIllll[0] = (0x6B ^ 0x1B ^ (0xE4 ^ 0xB9)) & (150 + 78 - 215 + 146 ^ 134 + 166 - 176 + 54 ^ -" ".length());
        ColorUtils.llIIllll[1] = " ".length();
        ColorUtils.llIIllll[2] = "  ".length();
        ColorUtils.llIIllll[3] = "   ".length();
        ColorUtils.llIIllll[4] = 0x7C ^ 0x6C;
        ColorUtils.llIIllll[5] = 81 + 10 - -158 + 6;
        ColorUtils.llIIllll[6] = 0x73 ^ 0x3F ^ (0xE6 ^ 0xA2);
        ColorUtils.llIIllll[7] = 0x43 ^ 0x5B;
    }

    public static int getARGB(float r, float g, float b, float a) {
        return ColorUtils.getARGB((int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    @Nonnull
    public static Vector4f toFloat4(int rgb) {
        int r = rgb >> llIIllll[4] & llIIllll[5];
        int g = rgb >> llIIllll[6] & llIIllll[5];
        int b = rgb & llIIllll[5];
        return new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public static int getRGB(float r, float g, float b) {
        return ColorUtils.getRGB((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int[] toRGB(int rgb) {
        int r = rgb >> llIIllll[4] & llIIllll[5];
        int g = rgb >> llIIllll[6] & llIIllll[5];
        int b = rgb & llIIllll[5];
        int[] nArray = new int[llIIllll[3]];
        nArray[ColorUtils.llIIllll[0]] = r;
        nArray[ColorUtils.llIIllll[1]] = g;
        nArray[ColorUtils.llIIllll[2]] = b;
        return nArray;
    }

    public static int getRGBA(float r, float g, float b, float a) {
        return ColorUtils.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }
}

