/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.utility;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NonDumbAxisABB {
    public double minY;
    public double maxX;
    public double maxZ;
    public double minZ;
    public double minX;
    private static final int[] lIII;
    public double maxY;

    public double calculateXOffset(NonDumbAxisABB other, double offsetX) {
        if (other.maxY > this.minY && other.minY < this.maxY && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            double d0;
            if (offsetX > 0.0 && other.maxX <= this.minX) {
                double d1 = this.minX - other.maxX;
                if (d1 < offsetX) {
                    offsetX = d1;
                }
            } else if (offsetX < 0.0 && other.minX >= this.maxX && (d0 = this.maxX - other.minX) > offsetX) {
                offsetX = d0;
            }
            return offsetX;
        }
        return offsetX;
    }

    public NonDumbAxisABB setMaxY(double y2) {
        return new NonDumbAxisABB(this.minX, this.minY, this.minZ, this.maxX, y2, this.maxZ);
    }

    public double calculateZOffset(NonDumbAxisABB other, double offsetZ) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxY > this.minY && other.minY < this.maxY) {
            double d0;
            if (offsetZ > 0.0 && other.maxZ <= this.minZ) {
                double d1 = this.minZ - other.maxZ;
                if (d1 < offsetZ) {
                    offsetZ = d1;
                }
            } else if (offsetZ < 0.0 && other.minZ >= this.maxZ && (d0 = this.maxZ - other.minZ) > offsetZ) {
                offsetZ = d0;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasNaN() {
        return (Double.isNaN(this.minX) || Double.isNaN(this.minY) || Double.isNaN(this.minZ) || Double.isNaN(this.maxX) || Double.isNaN(this.maxY) || Double.isNaN(this.maxZ) ? lIII[0] : lIII[1]) != 0;
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithXPlane(double p_186671_1_, Vec3d p_186671_3_, Vec3d p_186671_4_) {
        Vec3d vec3d = p_186671_3_.func_72429_b(p_186671_4_, p_186671_1_);
        return vec3d != null && this.intersectsWithYZ(vec3d) ? vec3d : null;
    }

    static {
        NonDumbAxisABB.llI();
    }

    public String toString() {
        return "box[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public double calculateYOffset(NonDumbAxisABB other, double offsetY) {
        if (other.maxX > this.minX && other.minX < this.maxX && other.maxZ > this.minZ && other.minZ < this.maxZ) {
            double d0;
            if (offsetY > 0.0 && other.maxY <= this.minY) {
                double d1 = this.minY - other.maxY;
                if (d1 < offsetY) {
                    offsetY = d1;
                }
            } else if (offsetY < 0.0 && other.minY >= this.maxY && (d0 = this.maxY - other.minY) > offsetY) {
                offsetY = d0;
            }
            return offsetY;
        }
        return offsetY;
    }

    @VisibleForTesting
    boolean isClosest(Vec3d p_186661_1_, @Nullable Vec3d p_186661_2_, Vec3d p_186661_3_) {
        return (p_186661_2_ == null || p_186661_1_.func_72436_e(p_186661_3_) < p_186661_1_.func_72436_e(p_186661_2_) ? lIII[0] : lIII[1]) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean intersects(Vec3d min, Vec3d max) {
        return this.intersects(Math.min(min.field_72450_a, max.field_72450_a), Math.min(min.field_72448_b, max.field_72448_b), Math.min(min.field_72449_c, max.field_72449_c), Math.max(min.field_72450_a, max.field_72450_a), Math.max(min.field_72448_b, max.field_72448_b), Math.max(min.field_72449_c, max.field_72449_c));
    }

    @VisibleForTesting
    public boolean intersectsWithXZ(Vec3d vec) {
        return (vec.field_72450_a >= this.minX && vec.field_72450_a <= this.maxX && vec.field_72449_c >= this.minZ && vec.field_72449_c <= this.maxZ ? lIII[0] : lIII[1]) != 0;
    }

    public NonDumbAxisABB grow(double x, double y, double z) {
        double d0 = this.minX - x;
        double d1 = this.minY - y;
        double d2 = this.minZ - z;
        double d3 = this.maxX + x;
        double d4 = this.maxY + y;
        double d5 = this.maxZ + z;
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    @Nullable
    public RayTraceResult calculateIntercept(Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = this.collideWithXPlane(this.minX, vecA, vecB);
        EnumFacing enumfacing = EnumFacing.WEST;
        Vec3d vec3d1 = this.collideWithXPlane(this.maxX, vecA, vecB);
        if (vec3d1 != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.EAST;
        }
        if ((vec3d1 = this.collideWithYPlane(this.minY, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.DOWN;
        }
        if ((vec3d1 = this.collideWithYPlane(this.maxY, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.UP;
        }
        if ((vec3d1 = this.collideWithZPlane(this.minZ, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.NORTH;
        }
        if ((vec3d1 = this.collideWithZPlane(this.maxZ, vecA, vecB)) != null && this.isClosest(vecA, vec3d, vec3d1)) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.SOUTH;
        }
        return vec3d == null ? null : new RayTraceResult(vec3d, enumfacing);
    }

    public NonDumbAxisABB shrink(double value) {
        return this.grow(-value);
    }

    public NonDumbAxisABB offset(Vec3d vec) {
        return this.offset(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public int hashCode() {
        long i = Double.doubleToLongBits(this.minX);
        int j = (int)(i ^ i >>> lIII[2]);
        i = Double.doubleToLongBits(this.minY);
        j = lIII[3] * j + (int)(i ^ i >>> lIII[2]);
        i = Double.doubleToLongBits(this.minZ);
        j = lIII[3] * j + (int)(i ^ i >>> lIII[2]);
        i = Double.doubleToLongBits(this.maxX);
        j = lIII[3] * j + (int)(i ^ i >>> lIII[2]);
        i = Double.doubleToLongBits(this.maxY);
        j = lIII[3] * j + (int)(i ^ i >>> lIII[2]);
        i = Double.doubleToLongBits(this.maxZ);
        j = lIII[3] * j + (int)(i ^ i >>> lIII[2]);
        return j;
    }

    public boolean intersects(NonDumbAxisABB other) {
        return this.intersects(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public boolean contains(Vec3d vec) {
        if (vec.field_72450_a > this.minX && vec.field_72450_a < this.maxX) {
            if (vec.field_72448_b > this.minY && vec.field_72448_b < this.maxY) {
                return (vec.field_72449_c > this.minZ && vec.field_72449_c < this.maxZ ? lIII[0] : lIII[1]) != 0;
            }
            return lIII[1];
        }
        return lIII[1];
    }

    public NonDumbAxisABB offset(double x, double y, double z) {
        return new NonDumbAxisABB(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithYPlane(double p_186663_1_, Vec3d p_186663_3_, Vec3d p_186663_4_) {
        Vec3d vec3d = p_186663_3_.func_72435_c(p_186663_4_, p_186663_1_);
        return vec3d != null && this.intersectsWithXZ(vec3d) ? vec3d : null;
    }

    public double getAverageEdgeLength() {
        double d0 = this.maxX - this.minX;
        double d1 = this.maxY - this.minY;
        double d2 = this.maxZ - this.minZ;
        return (d0 + d1 + d2) / 3.0;
    }

    public NonDumbAxisABB union(NonDumbAxisABB other) {
        double d0 = Math.min(this.minX, other.minX);
        double d1 = Math.min(this.minY, other.minY);
        double d2 = Math.min(this.minZ, other.minZ);
        double d3 = Math.max(this.maxX, other.maxX);
        double d4 = Math.max(this.maxY, other.maxY);
        double d5 = Math.max(this.maxZ, other.maxZ);
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    public NonDumbAxisABB contract(double x, double y, double z) {
        double d0 = this.minX;
        double d1 = this.minY;
        double d2 = this.minZ;
        double d3 = this.maxX;
        double d4 = this.maxY;
        double d5 = this.maxZ;
        if (x < 0.0) {
            d0 -= x;
        } else if (x > 0.0) {
            d3 -= x;
        }
        if (y < 0.0) {
            d1 -= y;
        } else if (y > 0.0) {
            d4 -= y;
        }
        if (z < 0.0) {
            d2 -= z;
        } else if (z > 0.0) {
            d5 -= z;
        }
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    @VisibleForTesting
    public boolean intersectsWithYZ(Vec3d vec) {
        return (vec.field_72448_b >= this.minY && vec.field_72448_b <= this.maxY && vec.field_72449_c >= this.minZ && vec.field_72449_c <= this.maxZ ? lIII[0] : lIII[1]) != 0;
    }

    public NonDumbAxisABB intersect(NonDumbAxisABB other) {
        double d0 = Math.max(this.minX, other.minX);
        double d1 = Math.max(this.minY, other.minY);
        double d2 = Math.max(this.minZ, other.minZ);
        double d3 = Math.min(this.maxX, other.maxX);
        double d4 = Math.min(this.maxY, other.maxY);
        double d5 = Math.min(this.maxZ, other.maxZ);
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    @VisibleForTesting
    public boolean intersectsWithXY(Vec3d vec) {
        return (vec.field_72450_a >= this.minX && vec.field_72450_a <= this.maxX && vec.field_72448_b >= this.minY && vec.field_72448_b <= this.maxY ? lIII[0] : lIII[1]) != 0;
    }

    public boolean intersects(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (this.minX < x2 && this.maxX > x1 && this.minY < y2 && this.maxY > y1 && this.minZ < z2 && this.maxZ > z1 ? lIII[0] : lIII[1]) != 0;
    }

    public NonDumbAxisABB(BlockPos pos1, BlockPos pos2) {
        this(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public NonDumbAxisABB(AxisAlignedBB axis) {
        this.minX = axis.field_72340_a;
        this.minY = axis.field_72338_b;
        this.minZ = axis.field_72339_c;
        this.maxX = axis.field_72336_d;
        this.maxY = axis.field_72337_e;
        this.maxZ = axis.field_72334_f;
    }

    private static void llI() {
        lIII = new int[4];
        NonDumbAxisABB.lIII[0] = " ".length();
        NonDumbAxisABB.lIII[1] = (0x17 ^ 0x10 ^ (1 ^ 0x40)) & (81 + 32 - 86 + 188 ^ 71 + 119 - 67 + 22 ^ -" ".length());
        NonDumbAxisABB.lIII[2] = 75 + 80 - 38 + 32 ^ 148 + 132 - 111 + 12;
        NonDumbAxisABB.lIII[3] = 0xDE ^ 0xB1 ^ (0xEF ^ 0x9F);
    }

    public NonDumbAxisABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    @SideOnly(value=Side.CLIENT)
    public NonDumbAxisABB(Vec3d min, Vec3d max) {
        this(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public NonDumbAxisABB expand(double x, double y, double z) {
        double d0 = this.minX;
        double d1 = this.minY;
        double d2 = this.minZ;
        double d3 = this.maxX;
        double d4 = this.maxY;
        double d5 = this.maxZ;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new NonDumbAxisABB(d0, d1, d2, d3, d4, d5);
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithZPlane(double p_186665_1_, Vec3d p_186665_3_, Vec3d p_186665_4_) {
        Vec3d vec3d = p_186665_3_.func_72434_d(p_186665_4_, p_186665_1_);
        return vec3d != null && this.intersectsWithXY(vec3d) ? vec3d : null;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return lIII[0];
        }
        if (!(p_equals_1_ instanceof NonDumbAxisABB)) {
            return lIII[1];
        }
        NonDumbAxisABB axisalignedbb = (NonDumbAxisABB)p_equals_1_;
        if (Double.compare(axisalignedbb.minX, this.minX) != 0) {
            return lIII[1];
        }
        if (Double.compare(axisalignedbb.minY, this.minY) != 0) {
            return lIII[1];
        }
        if (Double.compare(axisalignedbb.minZ, this.minZ) != 0) {
            return lIII[1];
        }
        if (Double.compare(axisalignedbb.maxX, this.maxX) != 0) {
            return lIII[1];
        }
        if (Double.compare(axisalignedbb.maxY, this.maxY) != 0) {
            return lIII[1];
        }
        return Double.compare(axisalignedbb.maxZ, this.maxZ) == 0 ? lIII[0] : lIII[1];
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCenter() {
        return new Vec3d(this.minX + (this.maxX - this.minX) * 0.5, this.minY + (this.maxY - this.minY) * 0.5, this.minZ + (this.maxZ - this.minZ) * 0.5);
    }

    public NonDumbAxisABB offset(BlockPos pos) {
        return new NonDumbAxisABB(this.minX + (double)pos.func_177958_n(), this.minY + (double)pos.func_177956_o(), this.minZ + (double)pos.func_177952_p(), this.maxX + (double)pos.func_177958_n(), this.maxY + (double)pos.func_177956_o(), this.maxZ + (double)pos.func_177952_p());
    }

    public NonDumbAxisABB(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + lIII[0], pos.func_177956_o() + lIII[0], pos.func_177952_p() + lIII[0]);
    }

    public NonDumbAxisABB grow(double value) {
        return this.grow(value, value, value);
    }
}

