/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.utility;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class RenderHelperMW {
    private static final int[] lIlIlI;
    private static final DecimalFormat energyValue;

    public static void renderRectWithGradient(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel) {
        GL11.glPushMatrix();
        givenWidth = givenPosX + givenWidth;
        givenHeight = givenPosY + givenHeight;
        float f = (float)(startColor >> lIlIlI[12] & lIlIlI[11]) / 255.0f;
        float f1 = (float)(startColor >> lIlIlI[10] & lIlIlI[11]) / 255.0f;
        float f2 = (float)(startColor >> lIlIlI[5] & lIlIlI[11]) / 255.0f;
        float f3 = (float)(startColor & lIlIlI[11]) / 255.0f;
        float f4 = (float)(endColor >> lIlIlI[12] & lIlIlI[11]) / 255.0f;
        float f5 = (float)(endColor >> lIlIlI[10] & lIlIlI[11]) / 255.0f;
        float f6 = (float)(endColor >> lIlIlI[5] & lIlIlI[11]) / 255.0f;
        float f7 = (float)(endColor & lIlIlI[11]) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)lIlIlI[14]);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenPosY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenPosY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)lIlIlI[15]);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
    }

    public static void renderBackgroundImage(double offsx, double offsy, int width, int height, float brightness, ResourceLocation background) {
        GL11.glPushMatrix();
        GL11.glDisable((int)lIlIlI[16]);
        GL11.glDepthMask((boolean)lIlIlI[9]);
        GL11.glBlendFunc((int)lIlIlI[1], (int)lIlIlI[2]);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GL11.glDisable((int)lIlIlI[32]);
        GL11.glEnable((int)lIlIlI[0]);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(background);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glEnable((int)lIlIlI[17]);
        GL11.glHint((int)lIlIlI[18], (int)lIlIlI[19]);
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(offsx, offsy + (double)height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(offsx + (double)width, offsy + (double)height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(offsx + (double)width, offsy, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(offsx, offsy, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)lIlIlI[7]);
        GL11.glEnable((int)lIlIlI[16]);
        GL11.glEnable((int)lIlIlI[32]);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private static final String pad(String s) {
        return s.length() == lIlIlI[7] ? "0" + s : s;
    }

    public static void renderText(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(text, posX, posY, color);
    }

    public static void renderPositionedTextScaled(String givenText, double par2, double par3, double par4, float par5, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glBlendFunc((int)lIlIlI[1], (int)lIlIlI[2]);
        RenderHelperMW.renderCenteredTextScaled(givenText, lIlIlI[9], lIlIlI[9], givenColor, par5);
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glPopMatrix();
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return (mouseX >= x && mouseX < x + xSize && mouseY >= y && mouseY < y + ySize ? lIlIlI[7] : lIlIlI[9]) != 0;
    }

    public static void renderImageCentered(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight) {
        GL11.glPushMatrix();
        RenderHelperMW.renderImage(givenX - givenWidth / 2.0, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static void renderImageSpecial(double x, double y, double i, double j, double k, double l, float alpha, ResourceLocation image) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glEnable((int)lIlIlI[17]);
        GL11.glHint((int)lIlIlI[18], (int)lIlIlI[19]);
        double w = i;
        double h = j;
        double we = k;
        double he = l;
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x + w, y + he, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + we, y + he, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + we, y + h, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x + w, y + h, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glDisable((int)lIlIlI[17]);
    }

    public static void renderCenteredTextScaledWithOutlineFade(String text, int posX, int posY, double par4, int givenColor, double givenFade) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / lIlIlI[8]) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        GL11.glScaled((double)par4, (double)par4, (double)par4);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[20], lIlIlI[20], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[7], lIlIlI[20], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[20], lIlIlI[7], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[7], lIlIlI[7], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[9], lIlIlI[20], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[20], lIlIlI[9], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[7], lIlIlI[9], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[9], lIlIlI[7], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(text, lIlIlI[9], lIlIlI[9], givenColor);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithShadow(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        RenderHelperMW.renderCenteredTextWithShadow(text, lIlIlI[9], lIlIlI[9], color);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextInView(String par1, double par2, double par3, double par4, float par5, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = mc.field_71466_p.func_78256_a(par1);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.01f, (float)-0.01f, (float)0.01f);
        GL11.glDisable((int)lIlIlI[21]);
        GL11.glDepthMask((boolean)lIlIlI[9]);
        GL11.glDisable((int)lIlIlI[16]);
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glBlendFunc((int)lIlIlI[1], (int)lIlIlI[2]);
        java.awt.Color color = new java.awt.Color(1.0f, 1.0f, 1.0f, alpha);
        FontRenderer fr = mc.field_71466_p;
        fr.func_78276_b(par1, -(width / lIlIlI[8]), lIlIlI[9], color.getRGB());
        GL11.glDepthMask((boolean)lIlIlI[7]);
        GL11.glEnable((int)lIlIlI[16]);
        GL11.glEnable((int)lIlIlI[21]);
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glPopMatrix();
    }

    public static void renderPositionedImage(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glBlendFunc((int)lIlIlI[1], (int)lIlIlI[2]);
        RenderHelperMW.renderImage(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glPopMatrix();
    }

    public static void renderTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_175063_a(text, (float)posX, (float)posY, color);
    }

    static {
        RenderHelperMW.lIIIlI();
        energyValue = new DecimalFormat("###,###,###,###,###");
    }

    public static void renderPlayerHead(String playerName, int xPos, int yPos, String givenPlayerUUID) {
        ResourceLocation resourceLocation = new ResourceLocation("textures/hologram/steve.png");
        if (playerName.length() > 0) {
            RenderHelperMW.getDownloadImageSkin(resourceLocation, givenPlayerUUID);
        }
        GL11.glPushMatrix();
        RenderHelperMW.renderRect(xPos - lIlIlI[7], yPos - lIlIlI[7], lIlIlI[22], lIlIlI[23], lIlIlI[24]);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
        GL11.glTranslated((double)xPos, (double)yPos, (double)30.0);
        GL11.glScaled((double)0.75, (double)0.39, (double)0.0);
        double scale = 0.75;
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71456_v.func_73729_b(lIlIlI[9], lIlIlI[9], lIlIlI[25], lIlIlI[26], lIlIlI[25], lIlIlI[26]);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(lIlIlI[9], lIlIlI[9], lIlIlI[27], lIlIlI[26], lIlIlI[25], lIlIlI[26]);
        GL11.glPopMatrix();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + lIlIlI[9]), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + lIlIlI[9]) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + lIlIlI[9]), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + lIlIlI[9]) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + lIlIlI[9]), (double)(y + lIlIlI[9]), 0.0).func_187315_a((double)((float)(textureX + lIlIlI[9]) * f), (double)((float)(textureY + lIlIlI[9]) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderCenteredTextScaledWithOutline(String text, int posX, int posY, double par4, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / lIlIlI[8]) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        GL11.glScaled((double)par4, (double)par4, (double)par4);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[20], lIlIlI[20], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[7], lIlIlI[20], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[20], lIlIlI[7], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[7], lIlIlI[7], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[9], lIlIlI[20], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[20], lIlIlI[9], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[7], lIlIlI[9], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(TextFormatting.BLACK + text, lIlIlI[9], lIlIlI[7], lIlIlI[9]);
        mc.field_71466_p.func_78276_b(text, lIlIlI[9], lIlIlI[9], givenColor);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaled(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        RenderHelperMW.renderCenteredText(text, lIlIlI[9], lIlIlI[9], color);
        GL11.glPopMatrix();
    }

    public static void renderTranspImage(double x, double y, ResourceLocation image, double width, double height) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glEnable((int)lIlIlI[17]);
        GL11.glHint((int)lIlIlI[18], (int)lIlIlI[19]);
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glDisable((int)lIlIlI[17]);
    }

    public static void drawNameplate(FontRenderer fontRendererIn, String str, float x, float y, float z, int verticalShift, float viewerYaw, float viewerPitch, boolean isThirdPersonFrontal, boolean isSneaking) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(isThirdPersonFrontal ? lIlIlI[20] : lIlIlI[7]) * viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)lIlIlI[9]);
        if (!isSneaking) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRendererIn.func_78256_a(str) / lIlIlI[8];
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(-i - lIlIlI[7]), (double)(lIlIlI[20] + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-i - lIlIlI[7]), (double)(lIlIlI[5] + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + lIlIlI[7]), (double)(lIlIlI[5] + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + lIlIlI[7]), (double)(lIlIlI[20] + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        if (!isSneaking) {
            fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / lIlIlI[8], verticalShift, lIlIlI[36]);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179132_a((boolean)lIlIlI[7]);
        fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / lIlIlI[8], verticalShift, isSneaking ? lIlIlI[36] : lIlIlI[20]);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void renderMainMenuPlayer(int width, int height, float offsetx, float offsety, int par1, int par2) {
    }

    public static void renderRectWithOutline(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor, int givenOutlineColor, int outlineThickness) {
        GL11.glPushMatrix();
        RenderHelperMW.renderRect(givenPosX - outlineThickness, givenPosY - outlineThickness, givenWidth + outlineThickness * lIlIlI[8], givenHeight + outlineThickness * lIlIlI[8], givenOutlineColor);
        RenderHelperMW.renderRect(givenPosX, givenPosY, givenWidth, givenHeight, givenColor);
        GL11.glPopMatrix();
    }

    public static void renderCenteredText(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderHelperMW.renderText(text, posX - mc.field_71466_p.func_78256_a(text) / lIlIlI[8], posY, color);
    }

    public static void drawTextInWorld(Minecraft mc, RenderManager renderManager, String text, double x, double y, double z, int color, int backgroundColour, float scale) {
        int strWidth = renderManager.func_78716_a().func_78256_a(text);
        int strCenter = strWidth / lIlIlI[8];
        int yOffset = lIlIlI[34];
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-0.025f * scale), (float)(-0.025f * scale), (float)(0.025f * scale));
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)lIlIlI[9]);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        RenderHelperMW.drawColouredRect(-strCenter - lIlIlI[7], yOffset - lIlIlI[7], strWidth + lIlIlI[7], lIlIlI[35], backgroundColour);
        mc.field_71466_p.func_78276_b(text, -strCenter, yOffset, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void drawColouredRect(int posX, int posY, int xSize, int ySize, int colour) {
        RenderHelperMW.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour, 1.0f, 0.0);
    }

    public static void renderLine(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, int givenColor, float width) {
        Minecraft mc = Minecraft.func_71410_x();
        float red = (float)(givenColor >> lIlIlI[10] & lIlIlI[11]) / 255.0f;
        float blue = (float)(givenColor >> lIlIlI[5] & lIlIlI[11]) / 255.0f;
        float green = (float)(givenColor & lIlIlI[11]) / 255.0f;
        float alpha = (float)(givenColor >> lIlIlI[12] & lIlIlI[11]) / 255.0f;
        double d0 = mc.field_71439_g.field_70169_q + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70169_q);
        double d2 = mc.field_71439_g.field_70167_r + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70167_r);
        double d3 = mc.field_71439_g.field_70166_s + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70166_s);
        GL11.glPushMatrix();
        GL11.glDisable((int)lIlIlI[21]);
        GL11.glDisable((int)lIlIlI[4]);
        GL11.glDisable((int)lIlIlI[16]);
        GL11.glLineWidth((float)width);
        GL11.glTranslated((double)(-d0), (double)(-d2), (double)(-d3));
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glEnable((int)lIlIlI[28]);
        GL11.glHint((int)lIlIlI[29], (int)lIlIlI[30]);
        GL11.glBegin((int)lIlIlI[31]);
        GL11.glVertex3d((double)posX, (double)posY, (double)posZ);
        GL11.glVertex3d((double)posX2, (double)posY2, (double)posZ2);
        GL11.glEnd();
        GL11.glEnable((int)lIlIlI[21]);
        GL11.glEnable((int)lIlIlI[4]);
        GL11.glEnable((int)lIlIlI[16]);
        GL11.glPopMatrix();
    }

    public static String addCommas(long value) {
        return energyValue.format(value);
    }

    public static void renderTextScaledWithOutline(String text, int x, int y, int color, int outlineColor, double givenScale) {
        RenderHelperMW.renderTextScaled(text, x - lIlIlI[7], y + lIlIlI[7], outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x, y + lIlIlI[7], outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x + lIlIlI[7], y + lIlIlI[7], outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x - lIlIlI[7], y, outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x + lIlIlI[7], y, outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x - lIlIlI[7], y - lIlIlI[7], outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x, y - lIlIlI[7], outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x + lIlIlI[7], y - lIlIlI[7], outlineColor, givenScale);
        RenderHelperMW.renderTextScaled(text, x, y, color, givenScale);
    }

    public static void drawHoveringText(List list, int x, int y, FontRenderer font, int guiWidth, int guiHeight) {
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)guiWidth, (int)guiHeight, (int)lIlIlI[20], (FontRenderer)font);
    }

    public static ThreadDownloadImageData getDownloadImageSkin(ResourceLocation resourceLocationIn, String givenUUID) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(resourceLocationIn);
        if (object == null) {
            Object[] objectArray = new Object[lIlIlI[7]];
            objectArray[RenderHelperMW.lIlIlI[9]] = StringUtils.func_76338_a((String)givenUUID);
            object = new ThreadDownloadImageData(null, String.format("https://crafatar.com/skins/%s.png", objectArray), new ResourceLocation("textures/hologram/steve.png"), (IImageBuffer)new ImageBufferDownload());
            texturemanager.func_110579_a(resourceLocationIn, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public static void renderPlayer(int x, int y, float givenScale, float givenRotation) {
        GL11.glPushMatrix();
        GL11.glPopMatrix();
    }

    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return (double)Math.round(value) / 1000.0 + "K";
        }
        if (value < 1.0E9) {
            return (double)Math.round(value / 1000.0) / 1000.0 + "M";
        }
        if (value < 1.0E12) {
            return (double)Math.round(value / 1000000.0) / 1000.0 + "B";
        }
        return (double)Math.round(value / 1.0E9) / 1000.0 + "T";
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return (double)Math.round(value) / 1000.0 + "K";
        }
        if (value < 1000000000L) {
            return (double)Math.round(value / 1000L) / 1000.0 + "M";
        }
        if (value < 1000000000000L) {
            return (double)Math.round(value / 1000000L) / 1000.0 + "G";
        }
        if (value < 1000000000000000L) {
            return (double)Math.round(value / 1000000000L) / 1000.0 + "T";
        }
        if (value < 1000000000000000000L) {
            return (double)Math.round(value / 1000000000000L) / 1000.0 + "P";
        }
        if (value <= Long.MAX_VALUE) {
            return (double)Math.round(value / 1000000000000000L) / 1000.0 + "E";
        }
        return "Something is very broken!!!!";
    }

    public static void renderItemStack(ItemStack stack, int x, int y, float partialTicks, boolean isJustOne) {
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glBlendFunc((int)lIlIlI[1], (int)lIlIlI[2]);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)lIlIlI[3]);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)lIlIlI[4]);
        GL11.glEnable((int)lIlIlI[3]);
        RenderHelper.func_74520_c();
        if (stack != null) {
            float f1 = (float)stack.func_190921_D() - partialTicks;
            if (f1 > 0.0f) {
                GL11.glPushMatrix();
                float f2 = 1.0f + f1 / 5.0f;
                GL11.glTranslatef((float)(x + lIlIlI[5]), (float)(y + lIlIlI[6]), (float)0.0f);
                GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(x + lIlIlI[5])), (float)(-(y + lIlIlI[6])), (float)0.0f);
            }
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y);
            if (f1 > 0.0f) {
                GL11.glPopMatrix();
            }
            ItemStack fits = new ItemStack(stack.func_77973_b(), lIlIlI[7]);
            if (isJustOne) {
                Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, fits, x, y, null);
            } else {
                Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, x, y, null);
            }
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)lIlIlI[3]);
    }

    public static void renderTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        RenderHelperMW.renderText(text, x - lIlIlI[7], y + lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x, y + lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x + lIlIlI[7], y + lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x - lIlIlI[7], y, outlineColor);
        RenderHelperMW.renderText(text, x + lIlIlI[7], y, outlineColor);
        RenderHelperMW.renderText(text, x - lIlIlI[7], y - lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x, y - lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x + lIlIlI[7], y - lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x, y, color);
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int colour1, int colour2, float fade, double zLevel) {
        float f = (float)(colour1 >> lIlIlI[12] & lIlIlI[11]) / 255.0f * fade;
        float f1 = (float)(colour1 >> lIlIlI[10] & lIlIlI[11]) / 255.0f;
        float f2 = (float)(colour1 >> lIlIlI[5] & lIlIlI[11]) / 255.0f;
        float f3 = (float)(colour1 & lIlIlI[11]) / 255.0f;
        float f4 = (float)(colour2 >> lIlIlI[12] & lIlIlI[11]) / 255.0f * fade;
        float f5 = (float)(colour2 >> lIlIlI[10] & lIlIlI[11]) / 255.0f;
        float f6 = (float)(colour2 >> lIlIlI[5] & lIlIlI[11]) / 255.0f;
        float f7 = (float)(colour2 & lIlIlI[11]) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)lIlIlI[14]);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)right, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)lIlIlI[15]);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void renderCenteredTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderHelperMW.renderTextWithShadow(text, posX - mc.field_71466_p.func_78256_a(text) / lIlIlI[8], posY, color);
    }

    public static void renderTextScaled(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        RenderHelperMW.renderText(text, lIlIlI[9], lIlIlI[9], color);
        GL11.glPopMatrix();
    }

    public static void drawTextInWorld(Minecraft mc, RenderManager renderManager, String text, double x, double y, double z, int color) {
        RenderHelperMW.drawTextInWorld(mc, renderManager, text, x, y, z, color, lIlIlI[33], 1.0f);
    }

    public static void renderImageAlpha(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glEnable((int)lIlIlI[17]);
        GL11.glHint((int)lIlIlI[18], (int)lIlIlI[19]);
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glDisable((int)lIlIlI[17]);
    }

    public static int toHex(Color color) {
        String alpha = RenderHelperMW.pad(Integer.toHexString(color.getAlpha()));
        String red = RenderHelperMW.pad(Integer.toHexString(color.getRed()));
        String green = RenderHelperMW.pad(Integer.toHexString(color.getGreen()));
        String blue = RenderHelperMW.pad(Integer.toHexString(color.getBlue()));
        String hex = "0x" + alpha + red + green + blue;
        return Integer.parseInt(hex, lIlIlI[10]);
    }

    public static void renderCenteredTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        RenderHelperMW.renderText(text, x - lIlIlI[7] - fr.func_78256_a(text) / lIlIlI[8], y + lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x - fr.func_78256_a(text) / lIlIlI[8], y + lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x + lIlIlI[7] - fr.func_78256_a(text) / lIlIlI[8], y + lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x - lIlIlI[7] - fr.func_78256_a(text) / lIlIlI[8], y, outlineColor);
        RenderHelperMW.renderText(text, x + lIlIlI[7] - fr.func_78256_a(text) / lIlIlI[8], y, outlineColor);
        RenderHelperMW.renderText(text, x - lIlIlI[7] - fr.func_78256_a(text) / lIlIlI[8], y - lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x - fr.func_78256_a(text) / lIlIlI[8], y - lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x + lIlIlI[7] - fr.func_78256_a(text) / lIlIlI[8], y - lIlIlI[7], outlineColor);
        RenderHelperMW.renderText(text, x - fr.func_78256_a(text) / lIlIlI[8], y, color);
    }

    public static String addCommas(int value) {
        return energyValue.format(value);
    }

    public static void renderImageCenteredScaled(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        RenderHelperMW.renderImageCentered(givenX - givenWidth / 2.0, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public static void renderPositionedImageNoDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)lIlIlI[9]);
        GL11.glDisable((int)lIlIlI[16]);
        RenderHelperMW.renderPositionedImage(par1, par2, par3, par4, par5, width, height);
        GL11.glDepthMask((boolean)lIlIlI[7]);
        GL11.glEnable((int)lIlIlI[16]);
        GL11.glPopMatrix();
    }

    public static void renderImage(double x, double y, ResourceLocation image, double width, double height) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)lIlIlI[0]);
        GL11.glEnable((int)lIlIlI[17]);
        GL11.glHint((int)lIlIlI[18], (int)lIlIlI[19]);
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)lIlIlI[0]);
        GL11.glDisable((int)lIlIlI[17]);
    }

    public static void renderRect(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor) {
        GL11.glPushMatrix();
        givenWidth = givenPosX + givenWidth;
        givenHeight = givenPosY + givenHeight;
        if (givenPosX < givenWidth) {
            int i = givenPosX;
            givenPosX = givenWidth;
            givenWidth = i;
        }
        if (givenPosY < givenHeight) {
            int j = givenPosY;
            givenPosY = givenHeight;
            givenHeight = j;
        }
        float f = (float)(givenColor >> lIlIlI[10] & lIlIlI[11]) / 255.0f;
        float f1 = (float)(givenColor >> lIlIlI[5] & lIlIlI[11]) / 255.0f;
        float f2 = (float)(givenColor & lIlIlI[11]) / 255.0f;
        float f3 = (float)(givenColor >> lIlIlI[12] & lIlIlI[11]) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(lIlIlI[13], DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenPosY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenPosY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    private static void lIIIlI() {
        lIlIlI = new int[37];
        RenderHelperMW.lIlIlI[0] = -(0xFFFFA51D & 0x7AF7) & (0xFFFFAFF7 & 0x7BFE);
        RenderHelperMW.lIlIlI[1] = 0xFFFFC73B & 0x3BC6;
        RenderHelperMW.lIlIlI[2] = -(0xFFFFF867 & 0x4FFD) & (0xFFFFCF6F & 0x7BF7);
        RenderHelperMW.lIlIlI[3] = 0xFFFFDA3B & 0xA5FE;
        RenderHelperMW.lIlIlI[4] = -(0xFFFFF2BF & 0x4D5B) & (0xFFFFDDFB & 0x6FFF);
        RenderHelperMW.lIlIlI[5] = 0xAA ^ 0xA2;
        RenderHelperMW.lIlIlI[6] = 0xF3 ^ 0xA6 ^ (0xEF ^ 0xB6);
        RenderHelperMW.lIlIlI[7] = " ".length();
        RenderHelperMW.lIlIlI[8] = "  ".length();
        RenderHelperMW.lIlIlI[9] = "  ".length() & ~"  ".length();
        RenderHelperMW.lIlIlI[10] = 0xB ^ 0x1B;
        RenderHelperMW.lIlIlI[11] = 13 + 4 - -104 + 11 + (96 + 35 - -28 + 80) - (125 + 146 - 233 + 160) + (0xC7 ^ 0x95);
        RenderHelperMW.lIlIlI[12] = 0x20 ^ 6 ^ (0x36 ^ 8);
        RenderHelperMW.lIlIlI[13] = 0x7E ^ 0x13 ^ (0x6C ^ 6);
        RenderHelperMW.lIlIlI[14] = 0xFFFF9F73 & 0x7D8D;
        RenderHelperMW.lIlIlI[15] = -(0xFFFFCAEA & 0x37DF) & (0xFFFFDFFD & 0x3FCB);
        RenderHelperMW.lIlIlI[16] = 0xFFFFEFF1 & 0x1B7F;
        RenderHelperMW.lIlIlI[17] = -(0xFFFFFC97 & 0x676A) & (0xFFFFFF1B & 0x6FF5);
        RenderHelperMW.lIlIlI[18] = -(0xFFFFBFFB & 0x53AF) & (0xFFFFBFFF & 0x5FFB);
        RenderHelperMW.lIlIlI[19] = -(0xFFFFFA77 & 0x67AF) & (0xFFFFF7A7 & 0x7B7F);
        RenderHelperMW.lIlIlI[20] = -" ".length();
        RenderHelperMW.lIlIlI[21] = -(0xFFFFF1FF & 0x3EAD) & (0xFFFFFFFE & 0x3BFD);
        RenderHelperMW.lIlIlI[22] = 0x7F ^ 0x6B;
        RenderHelperMW.lIlIlI[23] = 0xA4 ^ 0xB1;
        RenderHelperMW.lIlIlI[24] = -(0xFFFFFAFA & 0x2767) & (0xFFFFFEF5 & 0x4400236B);
        RenderHelperMW.lIlIlI[25] = 0xE ^ 0x1F ^ (0xBB ^ 0x8A);
        RenderHelperMW.lIlIlI[26] = 0x7F ^ 0x3F;
        RenderHelperMW.lIlIlI[27] = (0x4F ^ 0x3E) + (0x3C ^ 0x54) - (26 + 115 - 125 + 196) + (79 + 62 - 96 + 110);
        RenderHelperMW.lIlIlI[28] = -(0xFFFFEDBD & 0x76DB) & (0xFFFFEFFF & 0x7FB8);
        RenderHelperMW.lIlIlI[29] = -(0xFFFFFAB6 & 0x45EF) & (0xFFFFDFF7 & 0x6CFF);
        RenderHelperMW.lIlIlI[30] = 0xFFFFB14E & 0x5FB3;
        RenderHelperMW.lIlIlI[31] = "   ".length();
        RenderHelperMW.lIlIlI[32] = -(0xFFFFDE3F & 0x35FB) & (0xFFFFDFFE & 0x3FFB);
        RenderHelperMW.lIlIlI[33] = 0xFFFFC58C & 0x7F003A73;
        RenderHelperMW.lIlIlI[34] = -(0xE ^ 0xA);
        RenderHelperMW.lIlIlI[35] = 102 + 99 - 140 + 128 ^ 168 + 10 - 49 + 51;
        RenderHelperMW.lIlIlI[36] = -" ".length() & (0xFFFFFFFF & 0x20FFFFFF);
    }

    public static void renderPositionedTextInView(String par1, double par2, double par3, double par4, float par5) {
        RenderHelperMW.renderPositionedTextInView(par1, par2, par3, par4, par5, 1.0f);
    }
}

