/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndCentralDirLocator;
import net.lingala.zip4j.model.Zip64EndCentralDirRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderWriter {
    private final int ZIP64_EXTRA_BUF = lIlIl[0];
    private static final int[] lIlIl;

    private void updateCompressedSizeInLocalFileHeader(SplitOutputStream outputStream, LocalFileHeader localFileHeader, long offset, long toUpdate, byte[] bytesToWrite, boolean isZip64Format) throws ZipException {
        if (outputStream == null) {
            throw new ZipException("invalid output stream, cannot update compressed size for local file header");
        }
        try {
            if (localFileHeader.isWriteComprSizeInZip64ExtraRecord()) {
                if (bytesToWrite.length != lIlIl[4]) {
                    throw new ZipException("attempting to write a non 8-byte compressed size block for a zip64 file");
                }
                long zip64CompressedSizeOffset = offset + toUpdate + 4L + 4L + 2L + 2L + (long)localFileHeader.getFileNameLength() + 2L + 2L + 8L;
                outputStream.seek(zip64CompressedSizeOffset);
                outputStream.write(bytesToWrite);
            } else {
                outputStream.seek(offset + toUpdate);
                outputStream.write(bytesToWrite);
            }
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    private int countNumberOfFileHeaderEntriesOnDisk(ArrayList fileHeaders, int numOfDisk) throws ZipException {
        if (fileHeaders == null) {
            throw new ZipException("file headers are null, cannot calculate number of entries on this disk");
        }
        int noEntries = lIlIl[1];
        for (int i = lIlIl[1]; i < fileHeaders.size(); ++i) {
            FileHeader fileHeader = (FileHeader)fileHeaders.get(i);
            if (fileHeader.getDiskNumberStart() != numOfDisk - lIlIl[5]) continue;
            ++noEntries;
        }
        return noEntries;
    }

    public void finalizeZipFile(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file");
        }
        try {
            long offsetCentralDir = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
            int sizeOfCentralDir = this.writeCentralDirectory(zipModel, outputStream);
            if (zipModel.isZip64Format()) {
                if (zipModel.getZip64EndCentralDirRecord() == null) {
                    zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
                }
                if (zipModel.getZip64EndCentralDirLocator() == null) {
                    zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
                }
                zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(offsetCentralDir + (long)sizeOfCentralDir);
                if (outputStream instanceof SplitOutputStream) {
                    zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(((SplitOutputStream)outputStream).getCurrSplitFileCounter());
                    zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(((SplitOutputStream)outputStream).getCurrSplitFileCounter() + lIlIl[5]);
                } else {
                    zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(lIlIl[1]);
                    zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(lIlIl[5]);
                }
                this.writeZip64EndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel, outputStream);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private static void lIIIl() {
        lIlIl = new int[15];
        HeaderWriter.lIlIl[0] = 48 + 92 - 62 + 59 ^ 94 + 51 - 107 + 149;
        HeaderWriter.lIlIl[1] = (0x78 ^ 0x16 ^ (0xC7 ^ 0x86)) & (0x39 ^ 0x5D ^ (0x3F ^ 0x74) ^ -" ".length());
        HeaderWriter.lIlIl[2] = "  ".length();
        HeaderWriter.lIlIl[3] = 0x89 ^ 0xB3 ^ (0x39 ^ 7);
        HeaderWriter.lIlIl[4] = 0x39 ^ 0x31;
        HeaderWriter.lIlIl[5] = " ".length();
        HeaderWriter.lIlIl[6] = "   ".length();
        HeaderWriter.lIlIl[7] = 0x2A ^ 0x2F;
        HeaderWriter.lIlIl[8] = 136 + 67 - 165 + 151 ^ 2 + 130 - -53 + 2;
        HeaderWriter.lIlIl[9] = 0xA5 ^ 0xA2;
        HeaderWriter.lIlIl[10] = 0x5A ^ 0x4A;
        HeaderWriter.lIlIl[11] = -(90 + 0 - -76 + 6) & (0xFFFFFFFB & 0x8074BFF);
        HeaderWriter.lIlIl[12] = 0xFFFFFFD6 & 0x6064B79;
        HeaderWriter.lIlIl[13] = -(0xFFFFB5F3 & 0x5E8E) & (0xFFFFFFF7 & 0x7065FD9);
        HeaderWriter.lIlIl[14] = 0xBC ^ 0xB5;
    }

    public void updateLocalFileHeader(LocalFileHeader localFileHeader, long offset, int toUpdate, ZipModel zipModel, byte[] bytesToWrite, int noOfDisk, SplitOutputStream outputStream) throws ZipException {
        if (localFileHeader == null || offset < 0L || zipModel == null) {
            throw new ZipException("invalid input parameters, cannot update local file header");
        }
        try {
            int closeFlag = lIlIl[1];
            SplitOutputStream currOutputStream = null;
            if (noOfDisk != outputStream.getCurrSplitFileCounter()) {
                File zipFile = new File(zipModel.getZipFile());
                String parentFile = zipFile.getParent();
                String fileNameWithoutExt = Zip4jUtil.getZipFileNameWithoutExt(zipFile.getName());
                String fileName = parentFile + System.getProperty("file.separator");
                fileName = noOfDisk < lIlIl[14] ? fileName + fileNameWithoutExt + ".z0" + (noOfDisk + lIlIl[5]) : fileName + fileNameWithoutExt + ".z" + (noOfDisk + lIlIl[5]);
                currOutputStream = new SplitOutputStream(new File(fileName));
                closeFlag = lIlIl[5];
            } else {
                currOutputStream = outputStream;
            }
            long currOffset = currOutputStream.getFilePointer();
            if (currOutputStream == null) {
                throw new ZipException("invalid output stream handler, cannot update local file header");
            }
            switch (toUpdate) {
                case 14: {
                    currOutputStream.seek(offset + (long)toUpdate);
                    currOutputStream.write(bytesToWrite);
                    break;
                }
                case 18: {
                    this.updateCompressedSizeInLocalFileHeader(currOutputStream, localFileHeader, offset, toUpdate, bytesToWrite, zipModel.isZip64Format());
                    break;
                }
            }
            if (closeFlag != 0) {
                currOutputStream.close();
            } else {
                outputStream.seek(currOffset);
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void writeZip64EndOfCentralDirectoryLocator(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write zip64 end of central directory locator");
        }
        try {
            ArrayList byteArrayList = new ArrayList();
            byte[] intByte = new byte[lIlIl[3]];
            byte[] longByte = new byte[lIlIl[4]];
            Raw.writeIntLittleEndian(intByte, lIlIl[1], lIlIl[13]);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, lIlIl[1], zipModel.getZip64EndCentralDirLocator().getNoOfDiskStartOfZip64EndOfCentralDirRec());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeLongLittleEndian(longByte, lIlIl[1], zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec());
            this.copyByteArrayToArrayList(longByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, lIlIl[1], zipModel.getZip64EndCentralDirLocator().getTotNumberOfDiscs());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            outputStream.write(this.byteArrayListToByteArray(byteArrayList));
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private int writeFileHeader(ZipModel zipModel, FileHeader fileHeader, OutputStream outputStream) throws ZipException {
        if (fileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write local file header");
        }
        try {
            int sizeOfFileHeader = lIlIl[1];
            ArrayList byteArrayList = new ArrayList();
            byte[] shortByte = new byte[lIlIl[2]];
            byte[] intByte = new byte[lIlIl[3]];
            byte[] longByte = new byte[lIlIl[4]];
            byte[] byArray = new byte[lIlIl[2]];
            byArray[HeaderWriter.lIlIl[1]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[5]] = lIlIl[1];
            byte[] emptyShortByte = byArray;
            byte[] byArray2 = new byte[lIlIl[3]];
            byArray2[HeaderWriter.lIlIl[1]] = lIlIl[1];
            byArray2[HeaderWriter.lIlIl[5]] = lIlIl[1];
            byArray2[HeaderWriter.lIlIl[2]] = lIlIl[1];
            byArray2[HeaderWriter.lIlIl[6]] = lIlIl[1];
            byte[] emptyIntByte = byArray2;
            int writeZip64FileSize = lIlIl[1];
            int writeZip64OffsetLocalHeader = lIlIl[1];
            Raw.writeIntLittleEndian(intByte, lIlIl[1], fileHeader.getSignature());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            sizeOfFileHeader += 4;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)fileHeader.getVersionMadeBy());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            sizeOfFileHeader += 2;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)fileHeader.getVersionNeededToExtract());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            sizeOfFileHeader += 2;
            this.copyByteArrayToArrayList(fileHeader.getGeneralPurposeFlag(), byteArrayList);
            sizeOfFileHeader += 2;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)fileHeader.getCompressionMethod());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            sizeOfFileHeader += 2;
            int dateTime = fileHeader.getLastModFileTime();
            Raw.writeIntLittleEndian(intByte, lIlIl[1], dateTime);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            sizeOfFileHeader += 4;
            Raw.writeIntLittleEndian(intByte, lIlIl[1], (int)fileHeader.getCrc32());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            sizeOfFileHeader += 4;
            if (fileHeader.getCompressedSize() >= 0xFFFFFFFFL || fileHeader.getUncompressedSize() + 50L >= 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], 0xFFFFFFFFL);
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                sizeOfFileHeader += 4;
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                sizeOfFileHeader += 4;
                writeZip64FileSize = lIlIl[5];
            } else {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], fileHeader.getCompressedSize());
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                sizeOfFileHeader += 4;
                Raw.writeLongLittleEndian(longByte, lIlIl[1], fileHeader.getUncompressedSize());
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                sizeOfFileHeader += 4;
            }
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)fileHeader.getFileNameLength());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            sizeOfFileHeader += 2;
            byte[] offsetLocalHeaderBytes = new byte[lIlIl[3]];
            if (fileHeader.getOffsetLocalHeader() > 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], 0xFFFFFFFFL);
                System.arraycopy(longByte, lIlIl[1], offsetLocalHeaderBytes, lIlIl[1], lIlIl[3]);
                writeZip64OffsetLocalHeader = lIlIl[5];
            } else {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], fileHeader.getOffsetLocalHeader());
                System.arraycopy(longByte, lIlIl[1], offsetLocalHeaderBytes, lIlIl[1], lIlIl[3]);
            }
            int extraFieldLength = lIlIl[1];
            if (writeZip64FileSize != 0 || writeZip64OffsetLocalHeader != 0) {
                extraFieldLength += 4;
                if (writeZip64FileSize != 0) {
                    extraFieldLength += 16;
                }
                if (writeZip64OffsetLocalHeader != 0) {
                    extraFieldLength += 8;
                }
            }
            if (fileHeader.getAesExtraDataRecord() != null) {
                extraFieldLength += 11;
            }
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)extraFieldLength);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            sizeOfFileHeader += 2;
            this.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
            sizeOfFileHeader += 2;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)fileHeader.getDiskNumberStart());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            sizeOfFileHeader += 2;
            this.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
            sizeOfFileHeader += 2;
            if (fileHeader.getExternalFileAttr() != null) {
                this.copyByteArrayToArrayList(fileHeader.getExternalFileAttr(), byteArrayList);
            } else {
                this.copyByteArrayToArrayList(emptyIntByte, byteArrayList);
            }
            sizeOfFileHeader += 4;
            this.copyByteArrayToArrayList(offsetLocalHeaderBytes, byteArrayList);
            sizeOfFileHeader += 4;
            if (Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getFileNameCharset())) {
                byte[] fileNameBytes = fileHeader.getFileName().getBytes(zipModel.getFileNameCharset());
                this.copyByteArrayToArrayList(fileNameBytes, byteArrayList);
                sizeOfFileHeader += fileNameBytes.length;
            } else {
                this.copyByteArrayToArrayList(Zip4jUtil.convertCharset(fileHeader.getFileName()), byteArrayList);
                sizeOfFileHeader += Zip4jUtil.getEncodedStringLength(fileHeader.getFileName());
            }
            if (writeZip64FileSize != 0 || writeZip64OffsetLocalHeader != 0) {
                zipModel.setZip64Format(lIlIl[5]);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], lIlIl[5]);
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                sizeOfFileHeader += 2;
                int dataSize = lIlIl[1];
                if (writeZip64FileSize != 0) {
                    dataSize += 16;
                }
                if (writeZip64OffsetLocalHeader != 0) {
                    dataSize += 8;
                }
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)dataSize);
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                sizeOfFileHeader += 2;
                if (writeZip64FileSize != 0) {
                    Raw.writeLongLittleEndian(longByte, lIlIl[1], fileHeader.getUncompressedSize());
                    this.copyByteArrayToArrayList(longByte, byteArrayList);
                    sizeOfFileHeader += 8;
                    Raw.writeLongLittleEndian(longByte, lIlIl[1], fileHeader.getCompressedSize());
                    this.copyByteArrayToArrayList(longByte, byteArrayList);
                    sizeOfFileHeader += 8;
                }
                if (writeZip64OffsetLocalHeader != 0) {
                    Raw.writeLongLittleEndian(longByte, lIlIl[1], fileHeader.getOffsetLocalHeader());
                    this.copyByteArrayToArrayList(longByte, byteArrayList);
                    sizeOfFileHeader += 8;
                }
            }
            if (fileHeader.getAesExtraDataRecord() != null) {
                AESExtraDataRecord aesExtraDataRecord = fileHeader.getAesExtraDataRecord();
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getSignature());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getDataSize());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getVersionNumber());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                this.copyByteArrayToArrayList(aesExtraDataRecord.getVendorID().getBytes(), byteArrayList);
                byte[] aesStrengthBytes = new byte[lIlIl[5]];
                aesStrengthBytes[HeaderWriter.lIlIl[1]] = (byte)aesExtraDataRecord.getAesStrength();
                this.copyByteArrayToArrayList(aesStrengthBytes, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getCompressionMethod());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                sizeOfFileHeader += 11;
            }
            outputStream.write(this.byteArrayListToByteArray(byteArrayList));
            return sizeOfFileHeader;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void writeZip64EndOfCentralDirectoryRecord(ZipModel zipModel, OutputStream outputStream, int sizeOfCentralDir, long offsetCentralDir) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write zip64 end of central directory record");
        }
        try {
            ArrayList byteArrayList = new ArrayList();
            byte[] shortByte = new byte[lIlIl[2]];
            byte[] byArray = new byte[lIlIl[2]];
            byArray[HeaderWriter.lIlIl[1]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[5]] = lIlIl[1];
            byte[] emptyShortByte = byArray;
            byte[] intByte = new byte[lIlIl[3]];
            byte[] longByte = new byte[lIlIl[4]];
            Raw.writeIntLittleEndian(intByte, lIlIl[1], lIlIl[12]);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeLongLittleEndian(longByte, lIlIl[1], 44L);
            this.copyByteArrayToArrayList(longByte, byteArrayList);
            if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(lIlIl[1])).getVersionMadeBy());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(lIlIl[1])).getVersionNeededToExtract());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
            } else {
                this.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
                this.copyByteArrayToArrayList(emptyShortByte, byteArrayList);
            }
            Raw.writeIntLittleEndian(intByte, lIlIl[1], zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, lIlIl[1], zipModel.getEndCentralDirRecord().getNoOfThisDiskStartOfCentralDir());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            int numEntries = lIlIl[1];
            int numEntriesOnThisDisk = lIlIl[1];
            if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid central directory/file headers, cannot write end of central directory record");
            }
            numEntries = zipModel.getCentralDirectory().getFileHeaders().size();
            if (zipModel.isSplitArchive()) {
                this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            } else {
                numEntriesOnThisDisk = numEntries;
            }
            Raw.writeLongLittleEndian(longByte, lIlIl[1], numEntriesOnThisDisk);
            this.copyByteArrayToArrayList(longByte, byteArrayList);
            Raw.writeLongLittleEndian(longByte, lIlIl[1], numEntries);
            this.copyByteArrayToArrayList(longByte, byteArrayList);
            Raw.writeLongLittleEndian(longByte, lIlIl[1], sizeOfCentralDir);
            this.copyByteArrayToArrayList(longByte, byteArrayList);
            Raw.writeLongLittleEndian(longByte, lIlIl[1], offsetCentralDir);
            this.copyByteArrayToArrayList(longByte, byteArrayList);
            outputStream.write(this.byteArrayListToByteArray(byteArrayList));
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public void finalizeZipFileWithoutValidations(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        }
        long offsetCentralDir = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
        int sizeOfCentralDir = this.writeCentralDirectory(zipModel, outputStream);
        if (zipModel.isZip64Format()) {
            if (zipModel.getZip64EndCentralDirRecord() == null) {
                zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
            }
            if (zipModel.getZip64EndCentralDirLocator() == null) {
                zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
            }
            zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(offsetCentralDir + (long)sizeOfCentralDir);
            this.writeZip64EndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
            this.writeZip64EndOfCentralDirectoryLocator(zipModel, outputStream);
        }
        this.writeEndOfCentralDirectoryRecord(zipModel, outputStream, sizeOfCentralDir, offsetCentralDir);
    }

    static {
        HeaderWriter.lIIIl();
    }

    private byte[] byteArrayListToByteArray(ArrayList arrayList) throws ZipException {
        if (arrayList == null) {
            throw new ZipException("input byte array list is null, cannot conver to byte array");
        }
        if (arrayList.size() <= 0) {
            return null;
        }
        byte[] retBytes = new byte[arrayList.size()];
        for (int i = lIlIl[1]; i < arrayList.size(); ++i) {
            retBytes[i] = Byte.parseByte((String)arrayList.get(i));
        }
        return retBytes;
    }

    public int writeLocalFileHeader(ZipModel zipModel, LocalFileHeader localFileHeader, OutputStream outputStream) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("input parameters are null, cannot write local file header");
        }
        try {
            ArrayList byteArrayList = new ArrayList();
            int headerLength = lIlIl[1];
            byte[] shortByte = new byte[lIlIl[2]];
            byte[] intByte = new byte[lIlIl[3]];
            byte[] longByte = new byte[lIlIl[4]];
            byte[] byArray = new byte[lIlIl[4]];
            byArray[HeaderWriter.lIlIl[1]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[5]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[2]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[6]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[3]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[7]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[8]] = lIlIl[1];
            byArray[HeaderWriter.lIlIl[9]] = lIlIl[1];
            byte[] emptyLongByte = byArray;
            Raw.writeIntLittleEndian(intByte, lIlIl[1], localFileHeader.getSignature());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            headerLength += 4;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)localFileHeader.getVersionNeededToExtract());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            headerLength += 2;
            this.copyByteArrayToArrayList(localFileHeader.getGeneralPurposeFlag(), byteArrayList);
            headerLength += 2;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)localFileHeader.getCompressionMethod());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            headerLength += 2;
            int dateTime = localFileHeader.getLastModFileTime();
            Raw.writeIntLittleEndian(intByte, lIlIl[1], dateTime);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            headerLength += 4;
            Raw.writeIntLittleEndian(intByte, lIlIl[1], (int)localFileHeader.getCrc32());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            headerLength += 4;
            int writingZip64Rec = lIlIl[1];
            long uncompressedSize = localFileHeader.getUncompressedSize();
            if (uncompressedSize + 50L >= 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], 0xFFFFFFFFL);
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                zipModel.setZip64Format(lIlIl[5]);
                writingZip64Rec = lIlIl[5];
                localFileHeader.setWriteComprSizeInZip64ExtraRecord(lIlIl[5]);
            } else {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], localFileHeader.getCompressedSize());
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                Raw.writeLongLittleEndian(longByte, lIlIl[1], localFileHeader.getUncompressedSize());
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
                localFileHeader.setWriteComprSizeInZip64ExtraRecord(lIlIl[1]);
            }
            headerLength += 8;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)localFileHeader.getFileNameLength());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            headerLength += 2;
            int extraFieldLength = lIlIl[1];
            if (writingZip64Rec != 0) {
                extraFieldLength += 20;
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                extraFieldLength += 11;
            }
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)extraFieldLength);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            headerLength += 2;
            if (Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getFileNameCharset())) {
                byte[] fileNameBytes = localFileHeader.getFileName().getBytes(zipModel.getFileNameCharset());
                this.copyByteArrayToArrayList(fileNameBytes, byteArrayList);
                headerLength += fileNameBytes.length;
            } else {
                this.copyByteArrayToArrayList(Zip4jUtil.convertCharset(localFileHeader.getFileName()), byteArrayList);
                headerLength += Zip4jUtil.getEncodedStringLength(localFileHeader.getFileName());
            }
            if (writingZip64Rec != 0) {
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], lIlIl[5]);
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                headerLength += 2;
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], lIlIl[10]);
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                headerLength += 2;
                Raw.writeLongLittleEndian(longByte, lIlIl[1], localFileHeader.getUncompressedSize());
                this.copyByteArrayToArrayList(longByte, byteArrayList);
                headerLength += 8;
                this.copyByteArrayToArrayList(emptyLongByte, byteArrayList);
                headerLength += 8;
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                AESExtraDataRecord aesExtraDataRecord = localFileHeader.getAesExtraDataRecord();
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getSignature());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getDataSize());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getVersionNumber());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
                this.copyByteArrayToArrayList(aesExtraDataRecord.getVendorID().getBytes(), byteArrayList);
                byte[] aesStrengthBytes = new byte[lIlIl[5]];
                aesStrengthBytes[HeaderWriter.lIlIl[1]] = (byte)aesExtraDataRecord.getAesStrength();
                this.copyByteArrayToArrayList(aesStrengthBytes, byteArrayList);
                Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)aesExtraDataRecord.getCompressionMethod());
                this.copyByteArrayToArrayList(shortByte, byteArrayList);
            }
            byte[] lhBytes = this.byteArrayListToByteArray(byteArrayList);
            outputStream.write(lhBytes);
            return lhBytes.length;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void writeEndOfCentralDirectoryRecord(ZipModel zipModel, OutputStream outputStream, int sizeOfCentralDir, long offsetCentralDir) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write end of central directory record");
        }
        try {
            ArrayList byteArrayList = new ArrayList();
            byte[] shortByte = new byte[lIlIl[2]];
            byte[] intByte = new byte[lIlIl[3]];
            byte[] longByte = new byte[lIlIl[4]];
            Raw.writeIntLittleEndian(intByte, lIlIl[1], (int)zipModel.getEndCentralDirRecord().getSignature());
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)zipModel.getEndCentralDirRecord().getNoOfThisDiskStartOfCentralDir());
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            int numEntries = lIlIl[1];
            int numEntriesOnThisDisk = lIlIl[1];
            if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid central directory/file headers, cannot write end of central directory record");
            }
            numEntries = zipModel.getCentralDirectory().getFileHeaders().size();
            numEntriesOnThisDisk = zipModel.isSplitArchive() ? this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndCentralDirRecord().getNoOfThisDisk()) : numEntries;
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)numEntriesOnThisDisk);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)numEntries);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            Raw.writeIntLittleEndian(intByte, lIlIl[1], sizeOfCentralDir);
            this.copyByteArrayToArrayList(intByte, byteArrayList);
            if (offsetCentralDir > 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], 0xFFFFFFFFL);
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
            } else {
                Raw.writeLongLittleEndian(longByte, lIlIl[1], offsetCentralDir);
                System.arraycopy(longByte, lIlIl[1], intByte, lIlIl[1], lIlIl[3]);
                this.copyByteArrayToArrayList(intByte, byteArrayList);
            }
            int commentLength = lIlIl[1];
            if (zipModel.getEndCentralDirRecord().getComment() != null) {
                commentLength = zipModel.getEndCentralDirRecord().getComment().length();
            }
            Raw.writeShortLittleEndian(shortByte, lIlIl[1], (short)commentLength);
            this.copyByteArrayToArrayList(shortByte, byteArrayList);
            if (commentLength > 0) {
                this.copyByteArrayToArrayList(zipModel.getEndCentralDirRecord().getComment().getBytes(), byteArrayList);
            }
            outputStream.write(this.byteArrayListToByteArray(byteArrayList));
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public int writeExtendedLocalHeader(LocalFileHeader localFileHeader, OutputStream outputStream) throws ZipException, IOException {
        if (localFileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write extended local header");
        }
        ArrayList byteArrayList = new ArrayList();
        byte[] intByte = new byte[lIlIl[3]];
        Raw.writeIntLittleEndian(intByte, lIlIl[1], lIlIl[11]);
        this.copyByteArrayToArrayList(intByte, byteArrayList);
        Raw.writeIntLittleEndian(intByte, lIlIl[1], (int)localFileHeader.getCrc32());
        this.copyByteArrayToArrayList(intByte, byteArrayList);
        long compressedSize = localFileHeader.getCompressedSize();
        if (compressedSize >= Integer.MAX_VALUE) {
            compressedSize = Integer.MAX_VALUE;
        }
        Raw.writeIntLittleEndian(intByte, lIlIl[1], (int)compressedSize);
        this.copyByteArrayToArrayList(intByte, byteArrayList);
        long uncompressedSize = localFileHeader.getUncompressedSize();
        if (uncompressedSize >= Integer.MAX_VALUE) {
            uncompressedSize = Integer.MAX_VALUE;
        }
        Raw.writeIntLittleEndian(intByte, lIlIl[1], (int)uncompressedSize);
        this.copyByteArrayToArrayList(intByte, byteArrayList);
        byte[] extLocHdrBytes = this.byteArrayListToByteArray(byteArrayList);
        outputStream.write(extLocHdrBytes);
        return extLocHdrBytes.length;
    }

    private int writeCentralDirectory(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write central directory");
        }
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return lIlIl[1];
        }
        int sizeOfCentralDir = lIlIl[1];
        for (int i = lIlIl[1]; i < zipModel.getCentralDirectory().getFileHeaders().size(); ++i) {
            FileHeader fileHeader = (FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i);
            int sizeOfFileHeader = this.writeFileHeader(zipModel, fileHeader, outputStream);
            sizeOfCentralDir += sizeOfFileHeader;
        }
        return sizeOfCentralDir;
    }

    private void copyByteArrayToArrayList(byte[] byteArray, ArrayList arrayList) throws ZipException {
        if (arrayList == null || byteArray == null) {
            throw new ZipException("one of the input parameters is null, cannot copy byte array to array list");
        }
        for (int i = lIlIl[1]; i < byteArray.length; ++i) {
            arrayList.add(Byte.toString(byteArray[i]));
        }
    }
}

