/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import java.io.UnsupportedEncodingException;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.PBKDF2.PRF;

public class PBKDF2Engine {
    protected PRF prf;
    protected PBKDF2Parameters parameters;
    private static final int[] lllIIlIl;

    protected void INT(byte[] dest, int offset, int i) {
        dest[offset + PBKDF2Engine.lllIIlIl[0]] = (byte)(i / lllIIlIl[3]);
        dest[offset + PBKDF2Engine.lllIIlIl[1]] = (byte)(i / lllIIlIl[4]);
        dest[offset + PBKDF2Engine.lllIIlIl[5]] = (byte)(i / lllIIlIl[6]);
        dest[offset + PBKDF2Engine.lllIIlIl[7]] = (byte)i;
    }

    public PRF getPseudoRandomFunction() {
        return this.prf;
    }

    public void setParameters(PBKDF2Parameters parameters) {
        this.parameters = parameters;
    }

    public byte[] deriveKey(String inputPassword, int dkLen) {
        byte[] r = null;
        byte[] P = null;
        String charset = this.parameters.getHashCharset();
        if (inputPassword == null) {
            inputPassword = "";
        }
        try {
            P = charset == null ? inputPassword.getBytes() : inputPassword.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.assertPRF(P);
        if (dkLen == 0) {
            dkLen = this.prf.getHLen();
        }
        r = this.PBKDF2(this.prf, this.parameters.getSalt(), this.parameters.getIterationCount(), dkLen);
        return r;
    }

    static {
        PBKDF2Engine.lIIIIIll();
    }

    protected void assertPRF(byte[] P) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(P);
    }

    protected void xor(byte[] dest, byte[] src) {
        for (int i = lllIIlIl[0]; i < dest.length; ++i) {
            int n = i;
            dest[n] = (byte)(dest[n] ^ src[i]);
        }
    }

    private static void lIIIIIll() {
        lllIIlIl = new int[8];
        PBKDF2Engine.lllIIlIl[0] = (0x1D ^ 0x28) & ~(0x40 ^ 0x75);
        PBKDF2Engine.lllIIlIl[1] = " ".length();
        PBKDF2Engine.lllIIlIl[2] = 112 + 120 - 83 + 22 ^ 4 + 110 - 51 + 112;
        PBKDF2Engine.lllIIlIl[3] = -(0xFFFFFF77 & 0x7ADB) & (0xFFFFFAD6 & 0x1007F7B);
        PBKDF2Engine.lllIIlIl[4] = 0xFFFFD282 & 0x12D7D;
        PBKDF2Engine.lllIIlIl[5] = "  ".length();
        PBKDF2Engine.lllIIlIl[6] = 0xFFFFCF85 & 0x317A;
        PBKDF2Engine.lllIIlIl[7] = "   ".length();
    }

    protected void _F(byte[] dest, int offset, PRF prf, byte[] S, int c, int blockIndex) {
        int hLen = prf.getHLen();
        byte[] U_r = new byte[hLen];
        byte[] U_i = new byte[S.length + lllIIlIl[2]];
        System.arraycopy(S, lllIIlIl[0], U_i, lllIIlIl[0], S.length);
        this.INT(U_i, S.length, blockIndex);
        for (int i = lllIIlIl[0]; i < c; ++i) {
            U_i = prf.doFinal(U_i);
            this.xor(U_r, U_i);
        }
        System.arraycopy(U_r, lllIIlIl[0], dest, offset, hLen);
    }

    public PBKDF2Engine(PBKDF2Parameters parameters, PRF prf) {
        this.parameters = parameters;
        this.prf = prf;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public byte[] deriveKey(String inputPassword) {
        return this.deriveKey(inputPassword, lllIIlIl[0]);
    }

    public PBKDF2Engine(PBKDF2Parameters parameters) {
        this.parameters = parameters;
        this.prf = null;
    }

    public PBKDF2Engine() {
        this.parameters = null;
        this.prf = null;
    }

    protected int ceil(int a, int b) {
        int m = lllIIlIl[0];
        if (a % b > 0) {
            m = lllIIlIl[1];
        }
        return a / b + m;
    }

    public void setPseudoRandomFunction(PRF prf) {
        this.prf = prf;
    }

    protected byte[] PBKDF2(PRF prf, byte[] S, int c, int dkLen) {
        if (S == null) {
            S = new byte[lllIIlIl[0]];
        }
        int hLen = prf.getHLen();
        int l = this.ceil(dkLen, hLen);
        int r = dkLen - (l - lllIIlIl[1]) * hLen;
        byte[] T = new byte[l * hLen];
        int ti_offset = lllIIlIl[0];
        for (int i = lllIIlIl[1]; i <= l; ++i) {
            this._F(T, ti_offset, prf, S, c, i);
            ti_offset += hLen;
        }
        if (r < hLen) {
            byte[] DK = new byte[dkLen];
            System.arraycopy(T, lllIIlIl[0], DK, lllIIlIl[0], dkLen);
            return DK;
        }
        return T;
    }

    public boolean verifyKey(String inputPassword) {
        byte[] referenceKey = this.getParameters().getDerivedKey();
        if (referenceKey == null || referenceKey.length == 0) {
            return lllIIlIl[0];
        }
        byte[] inputKey = this.deriveKey(inputPassword, referenceKey.length);
        if (inputKey == null || inputKey.length != referenceKey.length) {
            return lllIIlIl[0];
        }
        for (int i = lllIIlIl[0]; i < inputKey.length; ++i) {
            if (inputKey[i] == referenceKey[i]) continue;
            return lllIIlIl[0];
        }
        return lllIIlIl[1];
    }
}

