/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.Random;
import net.lingala.zip4j.crypto.IEncrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Zip4jUtil;

public class StandardEncrypter
implements IEncrypter {
    private byte[] headerBytes;
    private static final int[] lIIIlll;
    private ZipCryptoEngine zipCryptoEngine;

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }

    public StandardEncrypter(String password, int crc) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
            throw new ZipException("input password is null or empty in standard encrpyter constructor");
        }
        this.zipCryptoEngine = new ZipCryptoEngine();
        this.headerBytes = new byte[lIIIlll[0]];
        this.init(password, crc);
    }

    @Override
    public int encryptData(byte[] buff, int start, int len) throws ZipException {
        if (len < 0) {
            throw new ZipException("invalid length specified to decrpyt data");
        }
        try {
            for (int i = start; i < len; ++i) {
                int val = buff[i] & lIIIlll[4];
                buff[i] = (byte)(val ^ this.zipCryptoEngine.decryptByte() & lIIIlll[4]);
                this.zipCryptoEngine.updateKeys((byte)val);
            }
            return len;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    protected static byte[] generateRandomBytes(int size) throws ZipException {
        if (size <= 0) {
            throw new ZipException("size is either 0 or less than 0, cannot generate header for standard encryptor");
        }
        byte[] buff = new byte[size];
        Random rand = new Random();
        for (int i = lIIIlll[3]; i < buff.length; ++i) {
            buff[i] = (byte)rand.nextInt(lIIIlll[5]);
        }
        return buff;
    }

    @Override
    public int encryptData(byte[] buff) throws ZipException {
        if (buff == null) {
            throw new NullPointerException();
        }
        return this.encryptData(buff, lIIIlll[3], buff.length);
    }

    static {
        StandardEncrypter.lIllIl();
    }

    private static void lIllIl() {
        lIIIlll = new int[6];
        StandardEncrypter.lIIIlll[0] = 0x1E ^ 0x12;
        StandardEncrypter.lIIIlll[1] = 0x16 ^ 0x1D;
        StandardEncrypter.lIIIlll[2] = 0x4F ^ 0x57;
        StandardEncrypter.lIIIlll[3] = (0x40 ^ 0x73) & ~(0x99 ^ 0xAA);
        StandardEncrypter.lIIIlll[4] = 22 + 50 - 38 + 137 + (164 + 96 - 241 + 154) - (79 + 242 - 84 + 8) + (36 + 62 - 18 + 76);
        StandardEncrypter.lIIIlll[5] = -(0xFFFFFF92 & 0x78FF) & (0xFFFFFBFF & 0x7D91);
    }

    private void init(String password, int crc) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
            throw new ZipException("input password is null or empty, cannot initialize standard encrypter");
        }
        this.zipCryptoEngine.initKeys(password);
        this.headerBytes = StandardEncrypter.generateRandomBytes(lIIIlll[0]);
        this.headerBytes[StandardEncrypter.lIIIlll[1]] = (byte)(crc >> lIIIlll[2]);
        if (this.headerBytes.length < lIIIlll[0]) {
            throw new ZipException("invalid header bytes generated, cannot perform standard encryption");
        }
        for (int i = lIIIlll[3]; i < this.headerBytes.length; ++i) {
            int val = this.headerBytes[i] & lIIIlll[4];
            this.headerBytes[i] = (byte)(val ^ this.zipCryptoEngine.decryptByte());
            this.zipCryptoEngine.updateKeys((byte)val);
        }
    }
}

