/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import net.lingala.zip4j.core.HeaderWriter;
import net.lingala.zip4j.crypto.AESEncrpyter;
import net.lingala.zip4j.crypto.IEncrypter;
import net.lingala.zip4j.crypto.StandardEncrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseOutputStream;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.CentralDirectory;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndCentralDirLocator;
import net.lingala.zip4j.model.Zip64EndCentralDirRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class CipherOutputStream
extends BaseOutputStream {
    protected ZipModel zipModel;
    private byte[] pendingBuffer;
    private static final int[] lIllIlll;
    protected CRC32 crc;
    protected FileHeader fileHeader;
    private int pendingBufferLength;
    private long bytesWrittenForThisFile;
    protected ZipParameters zipParameters;
    private long totalBytesWritten;
    private IEncrypter encrypter;
    protected OutputStream outputStream;
    protected LocalFileHeader localFileHeader;
    private File sourceFile;

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    private void initZipModel(ZipModel zipModel) {
        this.zipModel = zipModel == null ? new ZipModel() : zipModel;
        if (this.zipModel.getEndCentralDirRecord() == null) {
            this.zipModel.setEndCentralDirRecord(new EndCentralDirRecord());
        }
        if (this.zipModel.getCentralDirectory() == null) {
            this.zipModel.setCentralDirectory(new CentralDirectory());
        }
        if (this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            this.zipModel.getCentralDirectory().setFileHeaders(new ArrayList());
        }
        if (this.zipModel.getLocalFileHeaderList() == null) {
            this.zipModel.setLocalFileHeaderList(new ArrayList());
        }
        if (this.outputStream instanceof SplitOutputStream && ((SplitOutputStream)this.outputStream).isSplitZipFile()) {
            this.zipModel.setSplitArchive(lIllIlll[6]);
            this.zipModel.setSplitLength(((SplitOutputStream)this.outputStream).getSplitLength());
        }
        this.zipModel.getEndCentralDirRecord().setSignature(101010256L);
    }

    private void createLocalFileHeader() throws ZipException {
        if (this.fileHeader == null) {
            throw new ZipException("file header is null, cannot create local file header");
        }
        this.localFileHeader = new LocalFileHeader();
        this.localFileHeader.setSignature(lIllIlll[14]);
        this.localFileHeader.setVersionNeededToExtract(this.fileHeader.getVersionNeededToExtract());
        this.localFileHeader.setCompressionMethod(this.fileHeader.getCompressionMethod());
        this.localFileHeader.setLastModFileTime(this.fileHeader.getLastModFileTime());
        this.localFileHeader.setUncompressedSize(this.fileHeader.getUncompressedSize());
        this.localFileHeader.setFileNameLength(this.fileHeader.getFileNameLength());
        this.localFileHeader.setFileName(this.fileHeader.getFileName());
        this.localFileHeader.setEncrypted(this.fileHeader.isEncrypted());
        this.localFileHeader.setEncryptionMethod(this.fileHeader.getEncryptionMethod());
        this.localFileHeader.setAesExtraDataRecord(this.fileHeader.getAesExtraDataRecord());
        this.localFileHeader.setCrc32(this.fileHeader.getCrc32());
        this.localFileHeader.setCompressedSize(this.fileHeader.getCompressedSize());
        this.localFileHeader.setGeneralPurposeFlag((byte[])this.fileHeader.getGeneralPurposeFlag().clone());
    }

    private void createFileHeader() throws ZipException {
        this.fileHeader = new FileHeader();
        this.fileHeader.setSignature(lIllIlll[10]);
        this.fileHeader.setVersionMadeBy(lIllIlll[11]);
        this.fileHeader.setVersionNeededToExtract(lIllIlll[11]);
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == lIllIlll[5]) {
            this.fileHeader.setCompressionMethod(lIllIlll[5]);
            this.fileHeader.setAesExtraDataRecord(this.generateAESExtraDataRecord(this.zipParameters));
        } else {
            this.fileHeader.setCompressionMethod(this.zipParameters.getCompressionMethod());
        }
        if (this.zipParameters.isEncryptFiles()) {
            this.fileHeader.setEncrypted(lIllIlll[6]);
            this.fileHeader.setEncryptionMethod(this.zipParameters.getEncryptionMethod());
        }
        String fileName = null;
        if (this.zipParameters.isSourceExternalStream()) {
            this.fileHeader.setLastModFileTime((int)Zip4jUtil.javaToDosTime(System.currentTimeMillis()));
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.zipParameters.getFileNameInZip())) {
                throw new ZipException("fileNameInZip is null or empty");
            }
            fileName = this.zipParameters.getFileNameInZip();
        } else {
            this.fileHeader.setLastModFileTime((int)Zip4jUtil.javaToDosTime(Zip4jUtil.getLastModifiedFileTime(this.sourceFile, this.zipParameters.getTimeZone())));
            this.fileHeader.setUncompressedSize(this.sourceFile.length());
            fileName = Zip4jUtil.getRelativeFileName(this.sourceFile.getAbsolutePath(), this.zipParameters.getRootFolderInZip(), this.zipParameters.getDefaultFolderPath());
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            throw new ZipException("fileName is null or empty. unable to create file header");
        }
        this.fileHeader.setFileName(fileName);
        if (Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getFileNameCharset())) {
            this.fileHeader.setFileNameLength(Zip4jUtil.getEncodedStringLength(fileName, this.zipModel.getFileNameCharset()));
        } else {
            this.fileHeader.setFileNameLength(Zip4jUtil.getEncodedStringLength(fileName));
        }
        if (this.outputStream instanceof SplitOutputStream) {
            this.fileHeader.setDiskNumberStart(((SplitOutputStream)this.outputStream).getCurrSplitFileCounter());
        } else {
            this.fileHeader.setDiskNumberStart(lIllIlll[1]);
        }
        int fileAttrs = lIllIlll[1];
        if (!this.zipParameters.isSourceExternalStream()) {
            fileAttrs = this.getFileAttributes(this.sourceFile);
        }
        byte[] byArray = new byte[lIllIlll[3]];
        byArray[CipherOutputStream.lIllIlll[1]] = (byte)fileAttrs;
        byArray[CipherOutputStream.lIllIlll[6]] = lIllIlll[1];
        byArray[CipherOutputStream.lIllIlll[12]] = lIllIlll[1];
        byArray[CipherOutputStream.lIllIlll[13]] = lIllIlll[1];
        byte[] externalFileAttrs = byArray;
        this.fileHeader.setExternalFileAttr(externalFileAttrs);
        if (this.zipParameters.isSourceExternalStream()) {
            this.fileHeader.setDirectory((fileName.endsWith("/") || fileName.endsWith("\\") ? lIllIlll[6] : lIllIlll[1]) != 0);
        } else {
            this.fileHeader.setDirectory(this.sourceFile.isDirectory());
        }
        if (this.fileHeader.isDirectory()) {
            this.fileHeader.setCompressedSize(0L);
            this.fileHeader.setUncompressedSize(0L);
        } else if (!this.zipParameters.isSourceExternalStream()) {
            long fileSize = Zip4jUtil.getFileLengh(this.sourceFile);
            if (this.zipParameters.getCompressionMethod() == 0) {
                if (this.zipParameters.getEncryptionMethod() == 0) {
                    this.fileHeader.setCompressedSize(fileSize + 12L);
                } else if (this.zipParameters.getEncryptionMethod() == lIllIlll[5]) {
                    int saltLength = lIllIlll[1];
                    switch (this.zipParameters.getAesKeyStrength()) {
                        case 1: {
                            saltLength = lIllIlll[7];
                            break;
                        }
                        case 3: {
                            saltLength = lIllIlll[0];
                            break;
                        }
                        default: {
                            throw new ZipException("invalid aes key strength, cannot determine key sizes");
                        }
                    }
                    this.fileHeader.setCompressedSize(fileSize + (long)saltLength + 10L + 2L);
                } else {
                    this.fileHeader.setCompressedSize(0L);
                }
            } else {
                this.fileHeader.setCompressedSize(0L);
            }
            this.fileHeader.setUncompressedSize(fileSize);
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == 0) {
            this.fileHeader.setCrc32(this.zipParameters.getSourceFileCRC());
        }
        byte[] shortByte = new byte[lIllIlll[12]];
        shortByte[CipherOutputStream.lIllIlll[1]] = Raw.bitArrayToByte(this.generateGeneralPurposeBitArray(this.fileHeader.isEncrypted(), this.zipParameters.getCompressionMethod()));
        shortByte[CipherOutputStream.lIllIlll[6]] = Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getFileNameCharset()) && this.zipModel.getFileNameCharset().equalsIgnoreCase("UTF8") || Zip4jUtil.detectCharSet(this.fileHeader.getFileName()).equals("UTF8") ? lIllIlll[7] : lIllIlll[1];
        this.fileHeader.setGeneralPurposeFlag(shortByte);
    }

    public void putNextEntry(File file, ZipParameters zipParameters) throws ZipException {
        if (!zipParameters.isSourceExternalStream() && file == null) {
            throw new ZipException("input file is null");
        }
        if (!zipParameters.isSourceExternalStream() && !Zip4jUtil.checkFileExists(file)) {
            throw new ZipException("input file does not exist");
        }
        if (zipParameters == null) {
            zipParameters = new ZipParameters();
        }
        try {
            this.sourceFile = file;
            this.zipParameters = (ZipParameters)zipParameters.clone();
            if (!zipParameters.isSourceExternalStream()) {
                if (this.sourceFile.isDirectory()) {
                    this.zipParameters.setEncryptFiles(lIllIlll[1]);
                    this.zipParameters.setEncryptionMethod(lIllIlll[2]);
                    this.zipParameters.setCompressionMethod(lIllIlll[1]);
                }
            } else {
                if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.zipParameters.getFileNameInZip())) {
                    throw new ZipException("file name is empty for external stream");
                }
                if (this.zipParameters.getFileNameInZip().endsWith("/") || this.zipParameters.getFileNameInZip().endsWith("\\")) {
                    this.zipParameters.setEncryptFiles(lIllIlll[1]);
                    this.zipParameters.setEncryptionMethod(lIllIlll[2]);
                    this.zipParameters.setCompressionMethod(lIllIlll[1]);
                }
            }
            this.createFileHeader();
            this.createLocalFileHeader();
            if (this.zipModel.isSplitArchive() && (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() == 0)) {
                byte[] intByte = new byte[lIllIlll[3]];
                Raw.writeIntLittleEndian(intByte, lIllIlll[1], lIllIlll[4]);
                this.outputStream.write(intByte);
                this.totalBytesWritten += 4L;
            }
            if (this.outputStream instanceof SplitOutputStream) {
                if (this.totalBytesWritten == 4L) {
                    this.fileHeader.setOffsetLocalHeader(4L);
                } else {
                    this.fileHeader.setOffsetLocalHeader(((SplitOutputStream)this.outputStream).getFilePointer());
                }
            } else if (this.totalBytesWritten == 4L) {
                this.fileHeader.setOffsetLocalHeader(4L);
            } else {
                this.fileHeader.setOffsetLocalHeader(this.totalBytesWritten);
            }
            HeaderWriter headerWriter = new HeaderWriter();
            this.totalBytesWritten += (long)headerWriter.writeLocalFileHeader(this.zipModel, this.localFileHeader, this.outputStream);
            if (this.zipParameters.isEncryptFiles()) {
                this.initEncrypter();
                if (this.encrypter != null) {
                    if (zipParameters.getEncryptionMethod() == 0) {
                        byte[] headerBytes = ((StandardEncrypter)this.encrypter).getHeaderBytes();
                        this.outputStream.write(headerBytes);
                        this.totalBytesWritten += (long)headerBytes.length;
                        this.bytesWrittenForThisFile += (long)headerBytes.length;
                    } else if (zipParameters.getEncryptionMethod() == lIllIlll[5]) {
                        byte[] saltBytes = ((AESEncrpyter)this.encrypter).getSaltBytes();
                        byte[] passwordVerifier = ((AESEncrpyter)this.encrypter).getDerivedPasswordVerifier();
                        this.outputStream.write(saltBytes);
                        this.outputStream.write(passwordVerifier);
                        this.totalBytesWritten += (long)(saltBytes.length + passwordVerifier.length);
                        this.bytesWrittenForThisFile += (long)(saltBytes.length + passwordVerifier.length);
                    }
                }
            }
            this.crc.reset();
        }
        catch (CloneNotSupportedException e) {
            throw new ZipException(e);
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void initEncrypter() throws ZipException {
        if (!this.zipParameters.isEncryptFiles()) {
            this.encrypter = null;
            return;
        }
        switch (this.zipParameters.getEncryptionMethod()) {
            case 0: {
                this.encrypter = new StandardEncrypter(this.zipParameters.getPassword(), this.zipParameters.getSourceFileCRC());
                break;
            }
            case 99: {
                this.encrypter = new AESEncrpyter(this.zipParameters.getPassword(), this.zipParameters.getAesKeyStrength());
                break;
            }
            default: {
                throw new ZipException("invalid encprytion method");
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == lIllIlll[5]) {
            if (this.pendingBufferLength != 0) {
                if (len >= lIllIlll[0] - this.pendingBufferLength) {
                    System.arraycopy(b, off, this.pendingBuffer, this.pendingBufferLength, lIllIlll[0] - this.pendingBufferLength);
                    this.encryptAndWrite(this.pendingBuffer, lIllIlll[1], this.pendingBuffer.length);
                    off = lIllIlll[0] - this.pendingBufferLength;
                    len -= off;
                    this.pendingBufferLength = lIllIlll[1];
                } else {
                    System.arraycopy(b, off, this.pendingBuffer, this.pendingBufferLength, len);
                    this.pendingBufferLength += len;
                    return;
                }
            }
            if (len != 0 && len % lIllIlll[0] != 0) {
                System.arraycopy(b, len + off - len % lIllIlll[0], this.pendingBuffer, lIllIlll[1], len % lIllIlll[0]);
                this.pendingBufferLength = len % lIllIlll[0];
                len -= this.pendingBufferLength;
            }
        }
        if (len != 0) {
            this.encryptAndWrite(b, off, len);
        }
    }

    public void closeEntry() throws ZipException, IOException {
        if (this.pendingBufferLength != 0) {
            this.encryptAndWrite(this.pendingBuffer, lIllIlll[1], this.pendingBufferLength);
            this.pendingBufferLength = lIllIlll[1];
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == lIllIlll[5]) {
            if (this.encrypter instanceof AESEncrpyter) {
                this.outputStream.write(((AESEncrpyter)this.encrypter).getFinalMac());
                this.bytesWrittenForThisFile += 10L;
                this.totalBytesWritten += 10L;
            } else {
                throw new ZipException("invalid encrypter for AES encrypted file");
            }
        }
        this.fileHeader.setCompressedSize(this.bytesWrittenForThisFile);
        this.localFileHeader.setCompressedSize(this.bytesWrittenForThisFile);
        long crc32 = this.crc.getValue();
        if (this.fileHeader.isEncrypted()) {
            if (this.fileHeader.getEncryptionMethod() == lIllIlll[5]) {
                crc32 = 0L;
            } else if (this.fileHeader.getEncryptionMethod() == 0 && (int)crc32 != this.zipParameters.getSourceFileCRC()) {
                throw new ZipException("source file CRC and calculated CRC do not match for file: " + this.fileHeader.getFileName());
            }
        }
        if (this.zipParameters.isEncryptFiles() && this.zipParameters.getEncryptionMethod() == lIllIlll[5]) {
            this.fileHeader.setCrc32(0L);
            this.localFileHeader.setCrc32(0L);
        } else {
            this.fileHeader.setCrc32(crc32);
            this.localFileHeader.setCrc32(crc32);
        }
        this.zipModel.getLocalFileHeaderList().add(this.localFileHeader);
        this.zipModel.getCentralDirectory().getFileHeaders().add(this.fileHeader);
        HeaderWriter headerWriter = new HeaderWriter();
        if (this.outputStream instanceof SplitOutputStream) {
            byte[] intByte = new byte[lIllIlll[3]];
            if (this.localFileHeader.isWriteComprSizeInZip64ExtraRecord()) {
                byte[] longByte = new byte[lIllIlll[7]];
                Raw.writeLongLittleEndian(longByte, lIllIlll[1], this.localFileHeader.getCompressedSize());
                headerWriter.updateLocalFileHeader(this.localFileHeader, this.fileHeader.getOffsetLocalHeader(), lIllIlll[8], this.zipModel, longByte, this.fileHeader.getDiskNumberStart(), (SplitOutputStream)this.outputStream);
            } else {
                Raw.writeIntLittleEndian(intByte, lIllIlll[1], (int)this.localFileHeader.getCompressedSize());
                headerWriter.updateLocalFileHeader(this.localFileHeader, this.fileHeader.getOffsetLocalHeader(), lIllIlll[8], this.zipModel, intByte, this.fileHeader.getDiskNumberStart(), (SplitOutputStream)this.outputStream);
            }
            if (this.localFileHeader.getCrc32() != 0L) {
                Raw.writeIntLittleEndian(intByte, lIllIlll[1], (int)this.localFileHeader.getCrc32());
                headerWriter.updateLocalFileHeader(this.localFileHeader, this.fileHeader.getOffsetLocalHeader(), lIllIlll[9], this.zipModel, intByte, this.fileHeader.getDiskNumberStart(), (SplitOutputStream)this.outputStream);
            }
        } else {
            this.totalBytesWritten += (long)headerWriter.writeExtendedLocalHeader(this.localFileHeader, this.outputStream);
        }
        this.crc.reset();
        this.bytesWrittenForThisFile = 0L;
        this.encrypter = null;
    }

    @Override
    public void write(int bval) throws IOException {
        byte[] b = new byte[lIllIlll[6]];
        b[CipherOutputStream.lIllIlll[1]] = (byte)bval;
        this.write(b, lIllIlll[1], lIllIlll[6]);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (b.length == 0) {
            return;
        }
        this.write(b, lIllIlll[1], b.length);
    }

    private int getFileAttributes(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot get file attributes");
        }
        if (!file.exists()) {
            return lIllIlll[1];
        }
        if (file.isDirectory()) {
            if (file.isHidden()) {
                return lIllIlll[8];
            }
            return lIllIlll[0];
        }
        if (!file.canWrite() && file.isHidden()) {
            return lIllIlll[13];
        }
        if (!file.canWrite()) {
            return lIllIlll[6];
        }
        if (file.isHidden()) {
            return lIllIlll[12];
        }
        return lIllIlll[1];
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    private AESExtraDataRecord generateAESExtraDataRecord(ZipParameters parameters) throws ZipException {
        if (parameters == null) {
            throw new ZipException("zip parameters are null, cannot generate AES Extra Data record");
        }
        AESExtraDataRecord aesDataRecord = new AESExtraDataRecord();
        aesDataRecord.setSignature(39169L);
        aesDataRecord.setDataSize(lIllIlll[15]);
        aesDataRecord.setVendorID("AE");
        aesDataRecord.setVersionNumber(lIllIlll[12]);
        if (parameters.getAesKeyStrength() == lIllIlll[6]) {
            aesDataRecord.setAesStrength(lIllIlll[6]);
        } else if (parameters.getAesKeyStrength() == lIllIlll[13]) {
            aesDataRecord.setAesStrength(lIllIlll[13]);
        } else {
            throw new ZipException("invalid AES key strength, cannot generate AES Extra data record");
        }
        aesDataRecord.setCompressionMethod(parameters.getCompressionMethod());
        return aesDataRecord;
    }

    public CipherOutputStream(OutputStream outputStream, ZipModel zipModel) {
        this.outputStream = outputStream;
        this.initZipModel(zipModel);
        this.crc = new CRC32();
        this.totalBytesWritten = 0L;
        this.bytesWrittenForThisFile = 0L;
        this.pendingBuffer = new byte[lIllIlll[0]];
        this.pendingBufferLength = lIllIlll[1];
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    private static void llIllII() {
        lIllIlll = new int[16];
        CipherOutputStream.lIllIlll[0] = 0x72 ^ 0x62;
        CipherOutputStream.lIllIlll[1] = ("   ".length() ^ (0xBA ^ 0x86)) & (43 + 85 - 88 + 122 ^ 88 + 153 - 148 + 64 ^ -" ".length());
        CipherOutputStream.lIllIlll[2] = -" ".length();
        CipherOutputStream.lIllIlll[3] = 0xC7 ^ 0xC3;
        CipherOutputStream.lIllIlll[4] = -(0xFFFFB6EF & 0x7DB1) & (0xFFFFFFFC & 0x8077FF3);
        CipherOutputStream.lIllIlll[5] = 0x79 ^ 0x34 ^ (0x65 ^ 0x4B);
        CipherOutputStream.lIllIlll[6] = " ".length();
        CipherOutputStream.lIllIlll[7] = 0x55 ^ 0x5D;
        CipherOutputStream.lIllIlll[8] = 0x31 ^ 0x40 ^ (0x2E ^ 0x4D);
        CipherOutputStream.lIllIlll[9] = 0x53 ^ 0x5D;
        CipherOutputStream.lIllIlll[10] = -(0xFFFFBFAC & 0x64FB) & (0xFFFFEFFF & 0x2017FF7);
        CipherOutputStream.lIllIlll[11] = 32 + 43 - 28 + 167 ^ 81 + 95 - 61 + 79;
        CipherOutputStream.lIllIlll[12] = "  ".length();
        CipherOutputStream.lIllIlll[13] = "   ".length();
        CipherOutputStream.lIllIlll[14] = 0xFFFFFBD4 & 0x4034F7B;
        CipherOutputStream.lIllIlll[15] = 81 + 84 - 113 + 126 ^ 106 + 78 - 50 + 47;
    }

    private int[] generateGeneralPurposeBitArray(boolean isEncrpyted, int compressionMethod) {
        int[] generalPurposeBits = new int[lIllIlll[7]];
        generalPurposeBits[CipherOutputStream.lIllIlll[1]] = isEncrpyted ? lIllIlll[6] : lIllIlll[1];
        if (compressionMethod != lIllIlll[7]) {
            generalPurposeBits[CipherOutputStream.lIllIlll[6]] = lIllIlll[1];
            generalPurposeBits[CipherOutputStream.lIllIlll[12]] = lIllIlll[1];
        }
        generalPurposeBits[CipherOutputStream.lIllIlll[13]] = this.outputStream instanceof SplitOutputStream ? lIllIlll[1] : lIllIlll[6];
        return generalPurposeBits;
    }

    private void encryptAndWrite(byte[] b, int off, int len) throws IOException {
        if (this.encrypter != null) {
            try {
                this.encrypter.encryptData(b, off, len);
            }
            catch (ZipException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.outputStream.write(b, off, len);
        this.totalBytesWritten += (long)len;
        this.bytesWrittenForThisFile += (long)len;
    }

    static {
        CipherOutputStream.llIllII();
    }

    public void finish() throws IOException, ZipException {
        int currSplitFileCounter = lIllIlll[1];
        if (this.outputStream instanceof SplitOutputStream) {
            this.zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(((SplitOutputStream)this.outputStream).getFilePointer());
            currSplitFileCounter = ((SplitOutputStream)this.outputStream).getCurrSplitFileCounter();
        } else {
            this.zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(this.totalBytesWritten);
        }
        if (this.zipModel.isZip64Format()) {
            if (this.zipModel.getZip64EndCentralDirRecord() == null) {
                this.zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
            }
            if (this.zipModel.getZip64EndCentralDirLocator() == null) {
                this.zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
            }
            this.zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(currSplitFileCounter);
            this.zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(currSplitFileCounter + lIllIlll[6]);
        }
        this.zipModel.getEndCentralDirRecord().setNoOfThisDisk(currSplitFileCounter);
        this.zipModel.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(currSplitFileCounter);
        HeaderWriter headerWriter = new HeaderWriter();
        headerWriter.finalizeZipFile(this.zipModel, this.outputStream);
    }
}

