/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lingala.zip4j.io.PartInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class InflaterInputStream
extends PartInputStream {
    private Inflater inflater;
    private byte[] oneByteBuff = new byte[lIIllIIIl[0]];
    private static final int[] lIIllIIIl;
    private byte[] buff;
    private long bytesWritten;
    private long uncompressedSize;
    private UnzipEngine unzipEngine;

    @Override
    public int read() throws IOException {
        return this.read(this.oneByteBuff, lIIllIIIl[2], lIIllIIIl[0]) == lIIllIIIl[3] ? lIIllIIIl[3] : this.oneByteBuff[lIIllIIIl[2]] & lIIllIIIl[4];
    }

    @Override
    public int available() {
        return this.inflater.finished() ? lIIllIIIl[2] : lIIllIIIl[0];
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public InflaterInputStream(RandomAccessFile raf, long start, long len, UnzipEngine unzipEngine) {
        super(raf, start, len, unzipEngine);
        this.inflater = new Inflater(lIIllIIIl[0]);
        this.buff = new byte[lIIllIIIl[1]];
        this.unzipEngine = unzipEngine;
        this.bytesWritten = 0L;
        this.uncompressedSize = unzipEngine.getFileHeader().getUncompressedSize();
    }

    private void fill() throws IOException {
        int len = super.read(this.buff, lIIllIIIl[2], this.buff.length);
        if (len == lIIllIIIl[3]) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inflater.setInput(this.buff, lIIllIIIl[2], len);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("input buffer is null");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return lIIllIIIl[2];
        }
        try {
            int n;
            if (this.bytesWritten >= this.uncompressedSize) {
                return lIIllIIIl[3];
            }
            while ((n = this.inflater.inflate(b, off, len)) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    return lIIllIIIl[3];
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
            }
            this.bytesWritten += (long)n;
            return n;
        }
        catch (DataFormatException e) {
            String s = "Invalid ZLIB data format";
            if (e.getMessage() != null) {
                s = e.getMessage();
            }
            if (this.unzipEngine != null && this.unzipEngine.getLocalFileHeader().isEncrypted() && this.unzipEngine.getLocalFileHeader().getEncryptionMethod() == 0) {
                s = s + " - Wrong Password?";
            }
            throw new IOException(s);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
    }

    private static void lIlIllll() {
        lIIllIIIl = new int[6];
        InflaterInputStream.lIIllIIIl[0] = " ".length();
        InflaterInputStream.lIIllIIIl[1] = -(0xFFFFFBE5 & 0x65BF) & (0xFFFFF9FE & 0x77A5);
        InflaterInputStream.lIIllIIIl[2] = (0x61 ^ 0x7C) & ~(0xE ^ 0x13);
        InflaterInputStream.lIIllIIIl[3] = -" ".length();
        InflaterInputStream.lIIllIIIl[4] = 8 + 72 - 46 + 183 + (0x2F ^ 0x6C) - (106 + 22 - 79 + 152) + (135 + 36 - 106 + 107);
        InflaterInputStream.lIIllIIIl[5] = -(0xFFFFFCBA & 0x7FDF) & (0xFFFFFFBD & 0x7EDB);
    }

    @Override
    public UnzipEngine getUnzipEngine() {
        return super.getUnzipEngine();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("input buffer is null");
        }
        return this.read(b, lIIllIIIl[2], b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        byte[] b = new byte[lIIllIIIl[5]];
        for (total = lIIllIIIl[2]; total < max; total += len) {
            len = max - total;
            if (len > b.length) {
                len = b.length;
            }
            if ((len = this.read(b, lIIllIIIl[2], len)) == lIIllIIIl[3]) break;
        }
        return total;
    }

    static {
        InflaterInputStream.lIlIllll();
    }
}

