/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class PartInputStream
extends BaseInputStream {
    private IDecrypter decrypter;
    private int count;
    private int aesBytesReturned;
    private byte[] oneByteBuff = new byte[lIIllIlI[0]];
    private RandomAccessFile raf;
    private long bytesRead;
    private byte[] aesBlockByte = new byte[lIIllIlI[1]];
    private static final int[] lIIllIlI;
    private boolean isAESEncryptedFile;
    private long length;
    private UnzipEngine unzipEngine;

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, lIIllIlI[2], b.length);
    }

    private void checkAndReadAESMacBytes() throws IOException {
        if (this.isAESEncryptedFile && this.decrypter != null && this.decrypter instanceof AESDecrypter) {
            if (((AESDecrypter)this.decrypter).getStoredMac() != null) {
                return;
            }
            byte[] macBytes = new byte[lIIllIlI[7]];
            int readLen = lIIllIlI[3];
            readLen = this.raf.read(macBytes);
            if (readLen != lIIllIlI[7]) {
                if (this.unzipEngine.getZipModel().isSplitArchive()) {
                    this.raf.close();
                    this.raf = this.unzipEngine.startNextSplitFile();
                    int newlyRead = this.raf.read(macBytes, readLen, lIIllIlI[7] - readLen);
                    readLen += newlyRead;
                } else {
                    throw new IOException("Error occured while reading stored AES authentication bytes");
                }
            }
            ((AESDecrypter)this.unzipEngine.getDecrypter()).setStoredMac(macBytes);
        }
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.length - this.bytesRead && (len = (int)(this.length - this.bytesRead)) == 0) {
            this.checkAndReadAESMacBytes();
            return lIIllIlI[3];
        }
        if (this.unzipEngine.getDecrypter() instanceof AESDecrypter && this.bytesRead + (long)len < this.length && len % lIIllIlI[1] != 0) {
            len -= len % lIIllIlI[1];
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.count = this.raf.read(b, off, len);
            if (this.count < len && this.unzipEngine.getZipModel().isSplitArchive()) {
                int newlyRead;
                this.raf.close();
                this.raf = this.unzipEngine.startNextSplitFile();
                if (this.count < 0) {
                    this.count = lIIllIlI[2];
                }
                if ((newlyRead = this.raf.read(b, this.count, len - this.count)) > 0) {
                    this.count += newlyRead;
                }
            }
        }
        if (this.count > 0) {
            if (this.decrypter != null) {
                try {
                    this.decrypter.decryptData(b, off, this.count);
                }
                catch (ZipException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.bytesRead += (long)this.count;
        }
        if (this.bytesRead >= this.length) {
            this.checkAndReadAESMacBytes();
        }
        return this.count;
    }

    @Override
    public int available() {
        long amount = this.length - this.bytesRead;
        if (amount > Integer.MAX_VALUE) {
            return lIIllIlI[5];
        }
        return (int)amount;
    }

    public PartInputStream(RandomAccessFile raf, long start, long len, UnzipEngine unzipEngine) {
        this.aesBytesReturned = lIIllIlI[2];
        this.isAESEncryptedFile = lIIllIlI[2];
        this.count = lIIllIlI[3];
        this.raf = raf;
        this.unzipEngine = unzipEngine;
        this.decrypter = unzipEngine.getDecrypter();
        this.bytesRead = 0L;
        this.length = len;
        this.isAESEncryptedFile = unzipEngine.getFileHeader().isEncrypted() && unzipEngine.getFileHeader().getEncryptionMethod() == lIIllIlI[4] ? lIIllIlI[0] : lIIllIlI[2];
    }

    private static void lIllIlI() {
        lIIllIlI = new int[8];
        PartInputStream.lIIllIlI[0] = " ".length();
        PartInputStream.lIIllIlI[1] = 0x88 ^ 0x98;
        PartInputStream.lIIllIlI[2] = "  ".length() & ~"  ".length();
        PartInputStream.lIIllIlI[3] = -" ".length();
        PartInputStream.lIIllIlI[4] = 30 + 37 - -26 + 100 ^ 96 + 124 - 78 + 20;
        PartInputStream.lIIllIlI[5] = -" ".length() & (0xFFFFFFFF & Integer.MAX_VALUE);
        PartInputStream.lIIllIlI[6] = 160 + 9 - 90 + 176;
        PartInputStream.lIIllIlI[7] = 0x8F ^ 0x99 ^ (0xAE ^ 0xB2);
    }

    @Override
    public long skip(long amount) throws IOException {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        if (amount > this.length - this.bytesRead) {
            amount = this.length - this.bytesRead;
        }
        this.bytesRead += amount;
        return amount;
    }

    @Override
    public UnzipEngine getUnzipEngine() {
        return this.unzipEngine;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.length) {
            return lIIllIlI[3];
        }
        if (this.isAESEncryptedFile) {
            if (this.aesBytesReturned == 0 || this.aesBytesReturned == lIIllIlI[1]) {
                if (this.read(this.aesBlockByte) == lIIllIlI[3]) {
                    return lIIllIlI[3];
                }
                this.aesBytesReturned = lIIllIlI[2];
            }
            int n = this.aesBytesReturned;
            this.aesBytesReturned = n + lIIllIlI[0];
            return this.aesBlockByte[n] & lIIllIlI[6];
        }
        return this.read(this.oneByteBuff, lIIllIlI[2], lIIllIlI[0]) == lIIllIlI[3] ? lIIllIlI[3] : this.oneByteBuff[lIIllIlI[2]] & lIIllIlI[6];
    }

    static {
        PartInputStream.lIllIlI();
    }
}

