/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip64ExtendedInfo;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.unzip.Unzip;
import net.lingala.zip4j.util.Zip4jUtil;

public class FileHeader {
    private String fileName;
    private byte[] externalFileAttr;
    private int versionNeededToExtract;
    private String password;
    private int signature;
    private int compressionMethod;
    private int extraFieldLength;
    private boolean isDirectory;
    private boolean dataDescriptorExists;
    private int versionMadeBy;
    private long crc32 = 0L;
    private AESExtraDataRecord aesExtraDataRecord;
    private byte[] internalFileAttr;
    private boolean fileNameUTF8Encoded;
    private long offsetLocalHeader;
    private int diskNumberStart;
    private int fileCommentLength;
    private String fileComment;
    private byte[] crcBuff;
    private int fileNameLength;
    private int encryptionMethod = lIIllII[0];
    private long compressedSize;
    private byte[] generalPurposeFlag;
    private Zip64ExtendedInfo zip64ExtendedInfo;
    private static final int[] lIIllII;
    private int lastModFileTime;
    private long uncompressedSize = 0L;
    private boolean isEncrypted;
    private ArrayList extraDataRecords;

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public int getLastModFileTime() {
        return this.lastModFileTime;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public void setOffsetLocalHeader(long offsetLocalHeader) {
        this.offsetLocalHeader = offsetLocalHeader;
    }

    public void setExtraFieldLength(int extraFieldLength) {
        this.extraFieldLength = extraFieldLength;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setFileCommentLength(int fileCommentLength) {
        this.fileCommentLength = fileCommentLength;
    }

    public long getOffsetLocalHeader() {
        return this.offsetLocalHeader;
    }

    public void extractFile(ZipModel zipModel, String outPath, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        this.extractFile(zipModel, outPath, null, progressMonitor, runInThread);
    }

    public void setExtraDataRecords(ArrayList extraDataRecords) {
        this.extraDataRecords = extraDataRecords;
    }

    public void setInternalFileAttr(byte[] internalFileAttr) {
        this.internalFileAttr = internalFileAttr;
    }

    public boolean isFileNameUTF8Encoded() {
        return this.fileNameUTF8Encoded;
    }

    public void setCrc32(long crc32) {
        this.crc32 = crc32;
    }

    public boolean isDataDescriptorExists() {
        return this.dataDescriptorExists;
    }

    public void setGeneralPurposeFlag(byte[] generalPurposeFlag) {
        this.generalPurposeFlag = generalPurposeFlag;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void extractFile(ZipModel zipModel, String outPath, UnzipParameters unzipParameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        this.extractFile(zipModel, outPath, unzipParameters, null, progressMonitor, runInThread);
    }

    public int getExtraFieldLength() {
        return this.extraFieldLength;
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public int getVersionNeededToExtract() {
        return this.versionNeededToExtract;
    }

    public void setLastModFileTime(int lastModFileTime) {
        this.lastModFileTime = lastModFileTime;
    }

    public void setVersionMadeBy(int versionMadeBy) {
        this.versionMadeBy = versionMadeBy;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public byte[] getCrcBuff() {
        return this.crcBuff;
    }

    public void setExternalFileAttr(byte[] externalFileAttr) {
        this.externalFileAttr = externalFileAttr;
    }

    public void setAesExtraDataRecord(AESExtraDataRecord aesExtraDataRecord) {
        this.aesExtraDataRecord = aesExtraDataRecord;
    }

    public int getFileCommentLength() {
        return this.fileCommentLength;
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    private static void llIIll() {
        lIIllII = new int[1];
        FileHeader.lIIllII[0] = -" ".length();
    }

    public byte[] getExternalFileAttr() {
        return this.externalFileAttr;
    }

    public long getCrc32() {
        return this.crc32 & 0xFFFFFFFFL;
    }

    public void setDataDescriptorExists(boolean dataDescriptorExists) {
        this.dataDescriptorExists = dataDescriptorExists;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public void setDiskNumberStart(int diskNumberStart) {
        this.diskNumberStart = diskNumberStart;
    }

    public void setZip64ExtendedInfo(Zip64ExtendedInfo zip64ExtendedInfo) {
        this.zip64ExtendedInfo = zip64ExtendedInfo;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setEncryptionMethod(int encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    static {
        FileHeader.llIIll();
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public void setVersionNeededToExtract(int versionNeededToExtract) {
        this.versionNeededToExtract = versionNeededToExtract;
    }

    public void setCrcBuff(byte[] crcBuff) {
        this.crcBuff = crcBuff;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public byte[] getInternalFileAttr() {
        return this.internalFileAttr;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public int getSignature() {
        return this.signature;
    }

    public ArrayList getExtraDataRecords() {
        return this.extraDataRecords;
    }

    public void extractFile(ZipModel zipModel, String outPath, UnzipParameters unzipParameters, String newFileName, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("input zipModel is null");
        }
        if (!Zip4jUtil.checkOutputFolder(outPath)) {
            throw new ZipException("Invalid output path");
        }
        if (this == null) {
            throw new ZipException("invalid file header");
        }
        Unzip unzip = new Unzip(zipModel);
        unzip.extractFile(this, outPath, unzipParameters, newFileName, progressMonitor, runInThread);
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public int getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public void setFileNameUTF8Encoded(boolean fileNameUTF8Encoded) {
        this.fileNameUTF8Encoded = fileNameUTF8Encoded;
    }

    public AESExtraDataRecord getAesExtraDataRecord() {
        return this.aesExtraDataRecord;
    }

    public Zip64ExtendedInfo getZip64ExtendedInfo() {
        return this.zip64ExtendedInfo;
    }

    public String getPassword() {
        return this.password;
    }

    public byte[] getGeneralPurposeFlag() {
        return this.generalPurposeFlag;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }
}

