/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.progress;

import net.lingala.zip4j.exception.ZipException;

public class ProgressMonitor {
    public static final int OPERATION_CALC_CRC;
    private static final int[] lIlIlIlII;
    private long totalWork;
    public static final int OPERATION_REMOVE;
    private int percentDone;
    public static final int OPERATION_MERGE;
    public static final int RESULT_WORKING;
    public static final int RESULT_SUCCESS;
    private int state;
    private int result;
    private Throwable exception;
    private int currentOperation;
    public static final int STATE_BUSY;
    public static final int STATE_READY;
    private String fileName;
    public static final int RESULT_CANCELLED;
    public static final int OPERATION_EXTRACT;
    private boolean pause;
    public static final int OPERATION_ADD;
    private long workCompleted;
    private boolean cancelAllTasks;
    public static final int OPERATION_NONE;
    public static final int RESULT_ERROR;

    public void updateWorkCompleted(long workCompleted) {
        this.workCompleted += workCompleted;
        this.percentDone = (int)(this.workCompleted * 100L / this.totalWork);
        if (this.percentDone > lIlIlIlII[1]) {
            this.percentDone = lIlIlIlII[1];
        }
        while (this.pause) {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void cancelAllTasks() {
        this.cancelAllTasks = lIlIlIlII[4];
    }

    public void setResult(int result) {
        this.result = result;
    }

    public void endProgressMonitorError(Throwable e) throws ZipException {
        this.reset();
        this.result = lIlIlIlII[2];
        this.exception = e;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void endProgressMonitorSuccess() throws ZipException {
        this.reset();
        this.result = lIlIlIlII[0];
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ProgressMonitor() {
        this.reset();
        this.percentDone = lIlIlIlII[0];
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    static {
        ProgressMonitor.llIIIIlI();
        STATE_BUSY = lIlIlIlII[4];
        RESULT_ERROR = lIlIlIlII[2];
        OPERATION_EXTRACT = lIlIlIlII[4];
        OPERATION_REMOVE = lIlIlIlII[2];
        STATE_READY = lIlIlIlII[0];
        OPERATION_NONE = lIlIlIlII[3];
        OPERATION_MERGE = lIlIlIlII[5];
        RESULT_WORKING = lIlIlIlII[4];
        RESULT_CANCELLED = lIlIlIlII[6];
        RESULT_SUCCESS = lIlIlIlII[0];
        OPERATION_ADD = lIlIlIlII[0];
        OPERATION_CALC_CRC = lIlIlIlII[6];
    }

    private static void llIIIIlI() {
        lIlIlIlII = new int[7];
        ProgressMonitor.lIlIlIlII[0] = (0xCE ^ 0x88) & ~(0x6B ^ 0x2D);
        ProgressMonitor.lIlIlIlII[1] = 0xBC ^ 0x93 ^ (0x2A ^ 0x61);
        ProgressMonitor.lIlIlIlII[2] = "  ".length();
        ProgressMonitor.lIlIlIlII[3] = -" ".length();
        ProgressMonitor.lIlIlIlII[4] = " ".length();
        ProgressMonitor.lIlIlIlII[5] = 0x40 ^ 0x37 ^ (0xDE ^ 0xAD);
        ProgressMonitor.lIlIlIlII[6] = "   ".length();
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public int getResult() {
        return this.result;
    }

    public void fullReset() {
        this.reset();
        this.exception = null;
        this.result = lIlIlIlII[0];
        this.percentDone = lIlIlIlII[0];
    }

    public void setPercentDone(int percentDone) {
        this.percentDone = percentDone;
    }

    public void setTotalWork(long totalWork) {
        this.totalWork = totalWork;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public boolean isCancelAllTasks() {
        return this.cancelAllTasks;
    }

    public void reset() {
        this.currentOperation = lIlIlIlII[3];
        this.state = lIlIlIlII[0];
        this.fileName = null;
        this.totalWork = 0L;
        this.workCompleted = 0L;
    }

    public long getTotalWork() {
        return this.totalWork;
    }

    public long getWorkCompleted() {
        return this.workCompleted;
    }
}

