/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Zip4jUtil;

public class CRCUtil {
    private static final int[] llIllIlI;
    private static final int BUF_SIZE;

    static {
        CRCUtil.lllllIl();
        BUF_SIZE = llIllIlI[0];
    }

    private static void lllllIl() {
        llIllIlI = new int[5];
        CRCUtil.llIllIlI[0] = -(0xFFFFBFBE & 0x7FDD) & (0xFFFFFFBF & 0x7FDB);
        CRCUtil.llIllIlI[1] = -"  ".length();
        CRCUtil.llIllIlI[2] = -" ".length();
        CRCUtil.llIllIlI[3] = (0x46 ^ 0x1F) & ~(0xF9 ^ 0xA0);
        CRCUtil.llIllIlI[4] = "   ".length();
    }

    public static long computeFileCRC(String inputFile) throws ZipException {
        return CRCUtil.computeFileCRC(inputFile, null);
    }

    public static long computeFileCRC(String inputFile, ProgressMonitor progressMonitor) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(inputFile)) {
            throw new ZipException("input file is null or empty, cannot calculate CRC for the file");
        }
        InputStream inputStream = null;
        try {
            Zip4jUtil.checkFileReadAccess(inputFile);
            inputStream = new FileInputStream(new File(inputFile));
            byte[] buff = new byte[llIllIlI[0]];
            int readLen = llIllIlI[1];
            CRC32 crc32 = new CRC32();
            while ((readLen = inputStream.read(buff)) != llIllIlI[2]) {
                crc32.update(buff, llIllIlI[3], readLen);
                if (progressMonitor == null) continue;
                progressMonitor.updateWorkCompleted(readLen);
                if (!progressMonitor.isCancelAllTasks()) continue;
                progressMonitor.setResult(llIllIlI[4]);
                progressMonitor.setState(llIllIlI[3]);
                long l = 0L;
                return l;
            }
            long l = crc32.getValue();
            return l;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ZipException("error while closing the file after calculating crc");
                }
            }
        }
    }
}

