/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.DataInput;
import java.io.IOException;
import net.lingala.zip4j.exception.ZipException;

public class Raw {
    private static final int[] lllIlIlI;

    public static final void writeIntLittleEndian(byte[] array, int pos, int value) {
        array[pos + Raw.lllIlIlI[6]] = (byte)(value >>> lllIlIlI[11]);
        array[pos + Raw.lllIlIlI[7]] = (byte)(value >>> lllIlIlI[10]);
        array[pos + Raw.lllIlIlI[8]] = (byte)(value >>> lllIlIlI[2]);
        array[pos] = (byte)(value & lllIlIlI[1]);
    }

    static {
        Raw.lIIIIllI();
    }

    public static int readIntLittleEndian(byte[] b, int off) {
        return b[off] & lllIlIlI[1] | (b[off + lllIlIlI[8]] & lllIlIlI[1]) << lllIlIlI[2] | (b[off + lllIlIlI[7]] & lllIlIlI[1] | (b[off + lllIlIlI[6]] & lllIlIlI[1]) << lllIlIlI[2]) << lllIlIlI[10];
    }

    public static int readShortLittleEndian(byte[] b, int off) {
        return b[off] & lllIlIlI[1] | (b[off + lllIlIlI[8]] & lllIlIlI[1]) << lllIlIlI[2];
    }

    private static boolean checkBits(int[] bitArray) {
        for (int i = lllIlIlI[9]; i < bitArray.length; ++i) {
            if (bitArray[i] == 0 || bitArray[i] == lllIlIlI[8]) continue;
            return lllIlIlI[9];
        }
        return lllIlIlI[8];
    }

    public static byte[] toByteArray(int in) {
        byte[] out = new byte[lllIlIlI[5]];
        out[Raw.lllIlIlI[9]] = (byte)in;
        out[Raw.lllIlIlI[8]] = (byte)(in >> lllIlIlI[2]);
        out[Raw.lllIlIlI[7]] = (byte)(in >> lllIlIlI[10]);
        out[Raw.lllIlIlI[6]] = (byte)(in >> lllIlIlI[11]);
        return out;
    }

    public static void writeLongLittleEndian(byte[] array, int pos, long value) {
        array[pos + Raw.lllIlIlI[0]] = (byte)(value >>> lllIlIlI[12]);
        array[pos + Raw.lllIlIlI[3]] = (byte)(value >>> lllIlIlI[13]);
        array[pos + Raw.lllIlIlI[4]] = (byte)(value >>> lllIlIlI[14]);
        array[pos + Raw.lllIlIlI[5]] = (byte)(value >>> lllIlIlI[15]);
        array[pos + Raw.lllIlIlI[6]] = (byte)(value >>> lllIlIlI[11]);
        array[pos + Raw.lllIlIlI[7]] = (byte)(value >>> lllIlIlI[10]);
        array[pos + Raw.lllIlIlI[8]] = (byte)(value >>> lllIlIlI[2]);
        array[pos] = (byte)(value & 0xFFL);
    }

    public static byte[] toByteArray(int in, int outSize) {
        byte[] out = new byte[outSize];
        byte[] intArray = Raw.toByteArray(in);
        for (int i = lllIlIlI[9]; i < intArray.length && i < outSize; ++i) {
            out[i] = intArray[i];
        }
        return out;
    }

    public static final void writeShortLittleEndian(byte[] array, int pos, short value) {
        array[pos + Raw.lllIlIlI[8]] = (byte)(value >>> lllIlIlI[2]);
        array[pos] = (byte)(value & lllIlIlI[1]);
    }

    public static byte bitArrayToByte(int[] bitArray) throws ZipException {
        if (bitArray == null) {
            throw new ZipException("bit array is null, cannot calculate byte from bits");
        }
        if (bitArray.length != lllIlIlI[2]) {
            throw new ZipException("invalid bit array length, cannot calculate byte");
        }
        if (!Raw.checkBits(bitArray)) {
            throw new ZipException("invalid bits provided, bits contain other values than 0 or 1");
        }
        int retNum = lllIlIlI[9];
        for (int i = lllIlIlI[9]; i < bitArray.length; ++i) {
            retNum = (int)((double)retNum + Math.pow(2.0, i) * (double)bitArray[i]);
        }
        return (byte)retNum;
    }

    public static long readLongLittleEndian(byte[] array, int pos) {
        long temp = 0L;
        temp |= (long)(array[pos + lllIlIlI[0]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        temp |= (long)(array[pos + lllIlIlI[3]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        temp |= (long)(array[pos + lllIlIlI[4]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        temp |= (long)(array[pos + lllIlIlI[5]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        temp |= (long)(array[pos + lllIlIlI[6]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        temp |= (long)(array[pos + lllIlIlI[7]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        temp |= (long)(array[pos + lllIlIlI[8]] & lllIlIlI[1]);
        temp <<= lllIlIlI[2];
        return temp |= (long)(array[pos] & lllIlIlI[1]);
    }

    private static void lIIIIllI() {
        lllIlIlI = new int[16];
        Raw.lllIlIlI[0] = 0x2E ^ 0x79 ^ (0x76 ^ 0x26);
        Raw.lllIlIlI[1] = (0x2A ^ 0x23) + (0x60 ^ 0x4A) - -(0x41 ^ 6) + (64 + 114 - 112 + 67);
        Raw.lllIlIlI[2] = 0x6A ^ 0x62;
        Raw.lllIlIlI[3] = 0x80 ^ 0x86;
        Raw.lllIlIlI[4] = 0x87 ^ 0x9E ^ (0x5A ^ 0x46);
        Raw.lllIlIlI[5] = 145 + 11 - 44 + 45 ^ 112 + 143 - 145 + 43;
        Raw.lllIlIlI[6] = "   ".length();
        Raw.lllIlIlI[7] = "  ".length();
        Raw.lllIlIlI[8] = " ".length();
        Raw.lllIlIlI[9] = (0x71 ^ 0x4C ^ (0x41 ^ 0x32)) & (0x93 ^ 0xC4 ^ (0x7A ^ 0x63) ^ -" ".length());
        Raw.lllIlIlI[10] = 0x21 ^ 0x59 ^ (0x13 ^ 0x7B);
        Raw.lllIlIlI[11] = 0x64 ^ 0x7C;
        Raw.lllIlIlI[12] = 0xFF ^ 0x82 ^ (0x3D ^ 0x78);
        Raw.lllIlIlI[13] = 0xF9 ^ 0x99 ^ (0xC0 ^ 0x90);
        Raw.lllIlIlI[14] = 138 + 94 - 142 + 64 ^ 148 + 28 - 2 + 4;
        Raw.lllIlIlI[15] = 0x25 ^ 0x20 ^ (0x7E ^ 0x5B);
    }

    public static final short readShortBigEndian(byte[] array, int pos) {
        short temp = lllIlIlI[9];
        temp = (short)(temp | array[pos] & lllIlIlI[1]);
        temp = (short)(temp << lllIlIlI[2]);
        temp = (short)(temp | array[pos + lllIlIlI[8]] & lllIlIlI[1]);
        return temp;
    }

    public static int readLeInt(DataInput di, byte[] b) throws ZipException {
        try {
            di.readFully(b, lllIlIlI[9], lllIlIlI[5]);
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        return b[lllIlIlI[9]] & lllIlIlI[1] | (b[lllIlIlI[8]] & lllIlIlI[1]) << lllIlIlI[2] | (b[lllIlIlI[7]] & lllIlIlI[1] | (b[lllIlIlI[6]] & lllIlIlI[1]) << lllIlIlI[2]) << lllIlIlI[10];
    }
}

