/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.CipherOutputStream;
import net.lingala.zip4j.io.DeflaterOutputStream;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.ArchiveMaintainer;
import net.lingala.zip4j.util.CRCUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipEngine {
    private static final int[] lIIIlIlI;
    private ZipModel zipModel;

    private void removeFilesIfExists(ArrayList fileList, ZipParameters parameters, ProgressMonitor progressMonitor) throws ZipException {
        if (this.zipModel == null || this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return;
        }
        RandomAccessFile outputStream = null;
        try {
            for (int i = lIIIlIlI[0]; i < fileList.size(); ++i) {
                File file = (File)fileList.get(i);
                String fileName = Zip4jUtil.getRelativeFileName(file.getAbsolutePath(), parameters.getRootFolderInZip(), parameters.getDefaultFolderPath());
                FileHeader fileHeader = Zip4jUtil.getFileHeader(this.zipModel, fileName);
                if (fileHeader == null) continue;
                if (outputStream != null) {
                    outputStream.close();
                    outputStream = null;
                }
                ArchiveMaintainer archiveMaintainer = new ArchiveMaintainer();
                progressMonitor.setCurrentOperation(lIIIlIlI[8]);
                HashMap retMap = archiveMaintainer.initRemoveZipFile(this.zipModel, fileHeader, progressMonitor);
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(lIIIlIlI[4]);
                    progressMonitor.setState(lIIIlIlI[0]);
                    return;
                }
                progressMonitor.setCurrentOperation(lIIIlIlI[0]);
                if (outputStream != null) continue;
                outputStream = this.prepareFileOutputStream();
                if (retMap == null || retMap.get("offsetCentralDir") == null) continue;
                long offsetCentralDir = -1L;
                try {
                    offsetCentralDir = Long.parseLong((String)retMap.get("offsetCentralDir"));
                }
                catch (NumberFormatException e) {
                    throw new ZipException("NumberFormatException while parsing offset central directory. Cannot update already existing file header");
                }
                catch (Exception e) {
                    throw new ZipException("Error while parsing offset central directory. Cannot update already existing file header");
                }
                if (offsetCentralDir < 0L) continue;
                outputStream.seek(offsetCentralDir);
            }
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addFolderToZip(File file, ZipParameters parameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (file == null || parameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add folder to zip");
        }
        if (!Zip4jUtil.checkFileExists(file.getAbsolutePath())) {
            throw new ZipException("input folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new ZipException("input file is not a folder, user addFileToZip method to add files");
        }
        if (!Zip4jUtil.checkFileReadAccess(file.getAbsolutePath())) {
            throw new ZipException("cannot read folder: " + file.getAbsolutePath());
        }
        String rootFolderPath = null;
        rootFolderPath = parameters.isIncludeRootFolder() ? (file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : "") : file.getAbsolutePath();
        parameters.setDefaultFolderPath(rootFolderPath);
        this.addFiles(Zip4jUtil.getFilesInDirectoryRec(file, parameters.isReadHiddenFiles()), parameters, progressMonitor, runInThread);
    }

    private RandomAccessFile prepareFileOutputStream() throws ZipException {
        String outPath = this.zipModel.getZipFile();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("invalid output path");
        }
        try {
            File outFile = new File(outPath);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            return new RandomAccessFile(outFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
    }

    public void addFiles(final ArrayList fileList, final ZipParameters parameters, final ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (fileList == null || parameters == null) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (fileList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        progressMonitor.setTotalWork(this.calculateTotalWork(fileList, parameters));
        progressMonitor.setCurrentOperation(lIIIlIlI[0]);
        progressMonitor.setState(lIIIlIlI[1]);
        progressMonitor.setResult(lIIIlIlI[1]);
        if (runInThread) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ZipEngine.this.initAddFiles(fileList, parameters, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initAddFiles(fileList, parameters, progressMonitor);
        }
    }

    private EndCentralDirRecord createEndOfCentralDirectoryRecord() {
        EndCentralDirRecord endCentralDirRecord = new EndCentralDirRecord();
        endCentralDirRecord.setSignature(101010256L);
        endCentralDirRecord.setNoOfThisDisk(lIIIlIlI[0]);
        endCentralDirRecord.setTotNoOfEntriesInCentralDir(lIIIlIlI[0]);
        endCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(lIIIlIlI[0]);
        endCentralDirRecord.setOffsetOfStartOfCentralDir(0L);
        return endCentralDirRecord;
    }

    private void checkParameters(ZipParameters parameters) throws ZipException {
        if (parameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (parameters.getCompressionMethod() != 0 && parameters.getCompressionMethod() != lIIIlIlI[5]) {
            throw new ZipException("unsupported compression type");
        }
        if (parameters.getCompressionMethod() == lIIIlIlI[5] && parameters.getCompressionLevel() < 0 && parameters.getCompressionLevel() > lIIIlIlI[6]) {
            throw new ZipException("invalid compression level. compression level dor deflate should be in the range of 0-9");
        }
        if (parameters.isEncryptFiles()) {
            if (parameters.getEncryptionMethod() != 0 && parameters.getEncryptionMethod() != lIIIlIlI[7]) {
                throw new ZipException("unsupported encryption method");
            }
            String password = parameters.getPassword();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            parameters.setAesKeyStrength(lIIIlIlI[3]);
            parameters.setEncryptionMethod(lIIIlIlI[3]);
        }
    }

    private long calculateTotalWork(ArrayList fileList, ZipParameters parameters) throws ZipException {
        if (fileList == null) {
            throw new ZipException("file list is null, cannot calculate total work");
        }
        long totalWork = 0L;
        for (int i = lIIIlIlI[0]; i < fileList.size(); ++i) {
            String relativeFileName;
            FileHeader fileHeader;
            if (!(fileList.get(i) instanceof File) || !((File)fileList.get(i)).exists()) continue;
            totalWork = parameters.isEncryptFiles() && parameters.getEncryptionMethod() == 0 ? (totalWork += Zip4jUtil.getFileLengh((File)fileList.get(i)) * 2L) : (totalWork += Zip4jUtil.getFileLengh((File)fileList.get(i)));
            if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null || this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0 || (fileHeader = Zip4jUtil.getFileHeader(this.zipModel, relativeFileName = Zip4jUtil.getRelativeFileName(((File)fileList.get(i)).getAbsolutePath(), parameters.getRootFolderInZip(), parameters.getDefaultFolderPath()))) == null) continue;
            totalWork += Zip4jUtil.getFileLengh(new File(this.zipModel.getZipFile())) - fileHeader.getCompressedSize();
        }
        return totalWork;
    }

    private static void lIlIlII() {
        lIIIlIlI = new int[9];
        ZipEngine.lIIIlIlI[0] = (0xB8 ^ 0x8F) & ~(0xAB ^ 0x9C);
        ZipEngine.lIIIlIlI[1] = " ".length();
        ZipEngine.lIIIlIlI[2] = -(0xFFFFFF6F & 0x28F2) & (0xFFFFBA67 & 0x7DF9);
        ZipEngine.lIIIlIlI[3] = -" ".length();
        ZipEngine.lIIIlIlI[4] = "   ".length();
        ZipEngine.lIIIlIlI[5] = 0xA0 ^ 0xA8;
        ZipEngine.lIIIlIlI[6] = 0x45 ^ 0x18 ^ (0xF6 ^ 0xA2);
        ZipEngine.lIIIlIlI[7] = 0x27 ^ 0x39 ^ (0x5C ^ 0x21);
        ZipEngine.lIIIlIlI[8] = "  ".length();
    }

    private void initAddFiles(ArrayList fileList, ZipParameters parameters, ProgressMonitor progressMonitor) throws ZipException {
        if (fileList == null || parameters == null) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (fileList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            this.zipModel.setEndCentralDirRecord(this.createEndOfCentralDirectoryRecord());
        }
        CipherOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            this.checkParameters(parameters);
            this.removeFilesIfExists(fileList, parameters, progressMonitor);
            boolean isZipFileAlreadExists = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
            SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
            outputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
            if (isZipFileAlreadExists) {
                if (this.zipModel.getEndCentralDirRecord() == null) {
                    throw new ZipException("invalid end of central directory record");
                }
                splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            }
            byte[] readBuff = new byte[lIIIlIlI[2]];
            int readLen = lIIIlIlI[3];
            for (int i = lIIIlIlI[0]; i < fileList.size(); ++i) {
                if (parameters.isEncryptFiles() && parameters.getEncryptionMethod() == 0) {
                    progressMonitor.setCurrentOperation(lIIIlIlI[4]);
                    parameters.setSourceFileCRC((int)CRCUtil.computeFileCRC(((File)fileList.get(i)).getAbsolutePath(), progressMonitor));
                    progressMonitor.setCurrentOperation(lIIIlIlI[0]);
                }
                ((DeflaterOutputStream)outputStream).putNextEntry((File)fileList.get(i), parameters);
                if (((File)fileList.get(i)).isDirectory()) {
                    ((DeflaterOutputStream)outputStream).closeEntry();
                    continue;
                }
                inputStream = new FileInputStream((File)fileList.get(i));
                while ((readLen = inputStream.read(readBuff)) != lIIIlIlI[3]) {
                    ((ZipOutputStream)outputStream).write(readBuff, lIIIlIlI[0], readLen);
                    progressMonitor.updateWorkCompleted(readLen);
                }
                ((DeflaterOutputStream)outputStream).closeEntry();
                if (inputStream == null) continue;
                inputStream.close();
            }
            ((DeflaterOutputStream)outputStream).finish();
            progressMonitor.endProgressMonitorSuccess();
        }
        catch (ZipException e) {
            progressMonitor.endProgressMonitorError(e);
            throw e;
        }
        catch (Exception e) {
            progressMonitor.endProgressMonitorError(e);
            throw new ZipException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addStreamToZip(InputStream inputStream, ZipParameters parameters) throws ZipException {
        if (inputStream == null || parameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        }
        CipherOutputStream outputStream = null;
        try {
            this.checkParameters(parameters);
            boolean isZipFileAlreadExists = Zip4jUtil.checkFileExists(this.zipModel.getZipFile());
            SplitOutputStream splitOutputStream = new SplitOutputStream(new File(this.zipModel.getZipFile()), this.zipModel.getSplitLength());
            outputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
            if (isZipFileAlreadExists) {
                if (this.zipModel.getEndCentralDirRecord() == null) {
                    throw new ZipException("invalid end of central directory record");
                }
                splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
            }
            byte[] readBuff = new byte[lIIIlIlI[2]];
            int readLen = lIIIlIlI[3];
            ((DeflaterOutputStream)outputStream).putNextEntry(null, parameters);
            if (!parameters.getFileNameInZip().endsWith("/") && !parameters.getFileNameInZip().endsWith("\\")) {
                while ((readLen = inputStream.read(readBuff)) != lIIIlIlI[3]) {
                    ((ZipOutputStream)outputStream).write(readBuff, lIIIlIlI[0], readLen);
                }
            }
            ((DeflaterOutputStream)outputStream).closeEntry();
            ((DeflaterOutputStream)outputStream).finish();
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        ZipEngine.lIlIlII();
    }

    public ZipEngine(ZipModel zipModel) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null in ZipEngine constructor");
        }
        this.zipModel = zipModel;
    }
}

