/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

class UdpConnection {
    InetSocketAddress connectedAddress;
    DatagramChannel datagramChannel;
    int keepAliveMillis = 19000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    private final Serialization serialization;
    private SelectionKey selectionKey;
    private final Object writeLock = new Object();
    private long lastCommunicationTime;

    public UdpConnection(Serialization serialization, int bufferSize) {
        this.serialization = serialization;
        this.readBuffer = ByteBuffer.allocate(bufferSize);
        this.writeBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void bind(Selector selector, InetSocketAddress localPort) throws IOException {
        this.close();
        this.readBuffer.clear();
        this.writeBuffer.clear();
        try {
            this.datagramChannel = selector.provider().openDatagramChannel();
            this.datagramChannel.socket().bind(localPort);
            this.datagramChannel.configureBlocking(false);
            this.selectionKey = this.datagramChannel.register(selector, 1);
            this.lastCommunicationTime = System.currentTimeMillis();
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void connect(Selector selector, InetSocketAddress remoteAddress) throws IOException {
        this.close();
        this.readBuffer.clear();
        this.writeBuffer.clear();
        try {
            this.datagramChannel = selector.provider().openDatagramChannel();
            this.datagramChannel.socket().bind(null);
            this.datagramChannel.socket().connect(remoteAddress);
            this.datagramChannel.configureBlocking(false);
            this.selectionKey = this.datagramChannel.register(selector, 1);
            this.lastCommunicationTime = System.currentTimeMillis();
            this.connectedAddress = remoteAddress;
        }
        catch (IOException ex) {
            this.close();
            IOException ioEx = new IOException("Unable to connect to: " + remoteAddress);
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    public InetSocketAddress readFromAddress() throws IOException {
        DatagramChannel datagramChannel = this.datagramChannel;
        if (datagramChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        this.lastCommunicationTime = System.currentTimeMillis();
        return (InetSocketAddress)datagramChannel.receive(this.readBuffer);
    }

    public Object readObject(Connection connection) {
        this.readBuffer.flip();
        try {
            Object object = this.serialization.read(connection, this.readBuffer);
            if (this.readBuffer.hasRemaining()) {
                throw new KryoNetException("Incorrect number of bytes (" + this.readBuffer.remaining() + " remaining) used to deserialize object: " + object);
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception ex) {
            throw new KryoNetException("Error during deserialization.", ex);
        }
        finally {
            this.readBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Connection connection, Object object, SocketAddress address) throws IOException {
        DatagramChannel datagramChannel = this.datagramChannel;
        if (datagramChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        Object object2 = this.writeLock;
        synchronized (object2) {
            int n;
            try {
                try {
                    this.serialization.write(connection, this.writeBuffer, object);
                }
                catch (Exception ex) {
                    throw new KryoNetException("Error serializing object of type: " + object.getClass().getName(), ex);
                }
                this.writeBuffer.flip();
                int length = this.writeBuffer.limit();
                datagramChannel.send(this.writeBuffer, address);
                this.lastCommunicationTime = System.currentTimeMillis();
                boolean wasFullWrite = !this.writeBuffer.hasRemaining();
                n = wasFullWrite ? length : -1;
                this.writeBuffer.clear();
            }
            catch (Throwable throwable) {
                this.writeBuffer.clear();
                throw throwable;
            }
            return n;
        }
    }

    public void close() {
        block4: {
            this.connectedAddress = null;
            try {
                if (this.datagramChannel != null) {
                    this.datagramChannel.close();
                    this.datagramChannel = null;
                    if (this.selectionKey != null) {
                        this.selectionKey.selector().wakeup();
                    }
                }
            }
            catch (IOException ex) {
                if (!Log.DEBUG) break block4;
                Log.debug("kryonet", "Unable to close UDP connection.", ex);
            }
        }
    }

    public boolean needsKeepAlive(long time) {
        return this.connectedAddress != null && this.keepAliveMillis > 0 && time - this.lastCommunicationTime > (long)this.keepAliveMillis;
    }
}

