/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.audio.speaker;

import fr.nathanael2611.modularvoicechat.audio.api.NoExceptionCloseable;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerLineInfo;
import fr.nathanael2611.modularvoicechat.proxy.ClientProxy;
import fr.nathanael2611.modularvoicechat.util.AudioUtil;
import fr.nathanael2611.modularvoicechat.util.ThreadUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class SpeakerData
implements NoExceptionCloseable {
    public static final DataLine.Info SPEAKER_INFO = new DataLine.Info(SourceDataLine.class, AudioUtil.FORMAT);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadUtil.createDaemonFactory("speaker data cleanup"));
    private Mixer mixer;
    private final Map<Integer, SpeakerLineInfo> sourceLines = new ConcurrentHashMap<Integer, SpeakerLineInfo>();
    private int volume;
    private final ScheduledFuture<?> cleanupTask;

    public SpeakerData(String speakerName, int volume) {
        this.setMixer(speakerName);
        this.setVolume(volume);
        this.cleanupTask = this.executor.scheduleWithFixedDelay(() -> {
            long currentTime = System.currentTimeMillis();
            this.sourceLines.forEach((id, lineInfo) -> {
                if (currentTime - lineInfo.getLastAccessed() > 30000L) {
                    this.closeLine(this.sourceLines.remove(id));
                }
            });
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private boolean createLine(int id) {
        if (this.mixer != null) {
            try {
                SourceDataLine line = (SourceDataLine)this.mixer.getLine(SPEAKER_INFO);
                line.open(AudioUtil.FORMAT, 15360);
                line.start();
                SpeakerLineInfo lineInfo = new SpeakerLineInfo(line);
                lineInfo.setMasterVolume(this.volume);
                this.sourceLines.put(id, lineInfo);
                return true;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        return false;
    }

    private void closeLine(SpeakerLineInfo lineInfo) {
        SourceDataLine line = lineInfo.getSourceDataLine();
        line.flush();
        line.stop();
        line.close();
    }

    public String getMixer() {
        if (this.mixer != null) {
            return this.mixer.getMixerInfo().getName();
        }
        return null;
    }

    public void setMixer(String name) {
        if (this.mixer != null && this.mixer.getMixerInfo().getName().equals(name)) {
            return;
        }
        Mixer oldMixer = this.mixer;
        this.mixer = AudioUtil.findMixer(name, SPEAKER_INFO);
        this.sourceLines.values().forEach(this::closeLine);
        this.sourceLines.clear();
        if (oldMixer != null && !AudioUtil.hasLinesOpen(oldMixer)) {
            oldMixer.close();
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.sourceLines.values().stream().forEach(lineInfo -> lineInfo.setMasterVolume(volume));
    }

    public boolean isAvailable(int id) {
        if (this.mixer != null) {
            SpeakerLineInfo lineInfo = this.sourceLines.get(id);
            if (lineInfo != null) {
                return lineInfo.getSourceDataLine().isOpen();
            }
            return this.createLine(id);
        }
        return false;
    }

    public void flush(int id) {
        if (this.isAvailable(id)) {
            this.sourceLines.get(id).getSourceDataLine().flush();
        }
    }

    public byte[] write(int id, byte[] array, int volumePercent) {
        if (this.isAvailable(id)) {
            EntityPlayer speaker;
            SpeakerLineInfo lineInfo = this.sourceLines.get(id);
            float factor = (float)this.volume / 100.0f;
            float vol = (float)volumePercent / 100.0f * factor;
            array = AudioUtil.adjustVolume(array, vol);
            if (ClientProxy.getConfig().isStereo() && (speaker = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(id)) != null) {
                try {
                    double atan2 = Math.atan2(speaker.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70161_v, speaker.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70165_t);
                    double angle = Math.toRadians(Minecraft.func_71410_x().field_71439_g.field_70759_as) - atan2;
                    FloatControl control = (FloatControl)lineInfo.getSourceDataLine().getControl(FloatControl.Type.BALANCE);
                    control.setValue(-1.0f * (float)(Math.abs(this.normaliseAngle(angle + Math.PI)) / Math.PI - 0.5) * 2.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            lineInfo.setMasterVolume(volumePercent);
            lineInfo.getSourceDataLine().write(array, 0, array.length);
        }
        return array;
    }

    double normaliseAngle(double x) {
        return Math.atan2(Math.sin(x), Math.cos(x));
    }

    int freeBuffer(int id) {
        if (this.isAvailable(id)) {
            return this.sourceLines.get(id).getSourceDataLine().available();
        }
        return 0;
    }

    @Override
    public void close() {
        this.cleanupTask.cancel(false);
        this.executor.shutdown();
        this.sourceLines.values().forEach(this::closeLine);
        this.sourceLines.clear();
        if (this.mixer != null && !AudioUtil.hasLinesOpen(this.mixer)) {
            this.mixer.close();
        }
    }
}

