/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.client.voice;

import com.esotericsoftware.kryonet.Client;
import fr.nathanael2611.modularvoicechat.client.voice.KryoNetClientListener;
import fr.nathanael2611.modularvoicechat.network.objects.HelloImAPlayer;
import fr.nathanael2611.modularvoicechat.network.objects.KryoObjects;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class VoiceClient {
    private int port;
    private String host;
    private Client client;
    private boolean handshakeDone = false;
    private final ScheduledExecutorService RECONNECT_SERVICE = Executors.newSingleThreadScheduledExecutor();

    VoiceClient(String playerName, String host, int port) {
        this.port = port;
        this.host = host;
        this.client = new Client(10000000, 10000000);
        this.client.start();
        KryoObjects.registerObjects(this.client.getKryo());
        this.client.addListener(new KryoNetClientListener(this));
        this.RECONNECT_SERVICE.scheduleAtFixedRate(() -> {
            if (!this.client.isConnected() && host != null) {
                try {
                    Helpers.log(String.format("Try to connect to the UDP server! [%s:%s]", host, this.port));
                    this.client.connect(5000, host, port, port);
                    this.authenticate(playerName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a74[ModularVoiceChat] \u00a7c" + I18n.func_135052_a((String)"mvc.error.cantconnect", (Object[])new Object[0])));
                    Helpers.log("Failed to connect to VoiceServer.");
                }
            } else if (host == null) {
                Helpers.log("Host is null!");
            } else if (!this.isHandshakeDone()) {
                this.authenticate(playerName);
            }
        }, 5L, 15L, TimeUnit.SECONDS);
    }

    public void setHandshakeDone() {
        this.handshakeDone = true;
        Helpers.log("Successfully authenticate with " + Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a72[ModularVoiceChat] \u00a7a" + I18n.func_135052_a((String)"mvc.messages.connected", (Object[])new Object[0])));
    }

    public boolean isHandshakeDone() {
        return this.handshakeDone;
    }

    public void send(Object object) {
        this.client.sendUDP(object);
    }

    private void authenticate(String name) {
        Helpers.log("Try authenticate with username " + name);
        this.send(new HelloImAPlayer(name));
    }

    public void close() {
        this.client.close();
        this.RECONNECT_SERVICE.shutdown();
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }
}

