/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.client.voice.audio;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import fr.nathanael2611.modularvoicechat.audio.api.NoExceptionCloseable;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerData;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerPlayer;
import fr.nathanael2611.modularvoicechat.client.SpeakingPlayers;
import fr.nathanael2611.modularvoicechat.config.ClientConfig;
import fr.nathanael2611.modularvoicechat.proxy.ClientProxy;
import fr.nathanael2611.modularvoicechat.proxy.CommonProxy;
import fr.nathanael2611.modularvoicechat.util.Helpers;

public class SpeakerHandler
implements NoExceptionCloseable {
    private ClientConfig config = ClientProxy.getConfig();
    private final SpeakerData data = new SpeakerData(this.config.get(ClientConfig.SPEAKER).getAsString(), this.config.get(ClientConfig.SPEAKER_VOLUME).getAsInt());
    private final SpeakerPlayer player = new SpeakerPlayer(this.data);

    public void receiveVoicePacket(int id, byte[] opusPacket, int volumePercent, VoiceProperties properties) {
        String name = Helpers.clientGetPlayerNameForId(id);
        if (name == null || !CommonProxy.getMutedPlayers().isMuted(name)) {
            this.player.accept(id, opusPacket, volumePercent, properties);
        }
        SpeakingPlayers.updateTalking(id);
    }

    public void receiveEnd(int id) {
        this.player.accept(id, null, 0, null);
    }

    public String getSpeaker() {
        return this.data.getMixer();
    }

    public void setSpeaker(String mixer) {
        this.data.setMixer(mixer);
        this.config.set(ClientConfig.SPEAKER, (JsonElement)new JsonPrimitive(mixer));
    }

    public int getVolume() {
        return this.data.getVolume();
    }

    public void setVolume(int volume) {
        this.data.setVolume(volume);
        this.config.set(ClientConfig.SPEAKER_VOLUME, (JsonElement)new JsonPrimitive((Number)volume));
    }

    @Override
    public void close() {
        this.player.close();
        this.data.close();
    }
}

