/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.config;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.nathanael2611.modularvoicechat.config.ConfigProperty;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class GameConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private File configFile;
    private final HashMap<String, JsonElement> CONFIG_VALUES = Maps.newHashMap();

    public GameConfig(File configFile) {
        this.configFile = configFile;
    }

    public void read() throws IOException {
        if (this.isConfigValid()) {
            this.CONFIG_VALUES.clear();
            JsonObject object = this.getConfigAsJsonObject();
            object.entrySet().forEach(entry -> this.CONFIG_VALUES.put((String)entry.getKey(), (JsonElement)entry.getValue()));
        } else {
            this.configFile.delete();
            this.configFile.createNewFile();
            FileWriter writer = new FileWriter(this.configFile);
            writer.write("{}");
            writer.close();
            this.read();
        }
    }

    public void save() throws IOException {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : this.CONFIG_VALUES.entrySet()) {
            object.add(entry.getKey(), entry.getValue());
        }
        FileUtils.writeStringToFile((File)this.configFile, (String)GSON.toJson((JsonElement)object));
    }

    private boolean isConfigValid() {
        return this.configFile.exists() && Helpers.isValidJson(Helpers.readFileToString(this.configFile)) && this.getConfigAsJsonObject() != null;
    }

    private JsonObject getConfigAsJsonObject() {
        return new JsonParser().parse(Helpers.readFileToString(this.configFile)).getAsJsonObject();
    }

    public JsonElement get(ConfigProperty prop) {
        return this.CONFIG_VALUES.getOrDefault(prop.getKey(), prop.getDefaultValue());
    }

    public void set(ConfigProperty prop, JsonElement element) {
        this.CONFIG_VALUES.put(prop.getKey(), element);
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initProperty(ConfigProperty prop) {
        if (!this.CONFIG_VALUES.containsKey(prop.getKey())) {
            this.set(prop, prop.getDefaultValue());
        }
    }
}

