/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.config;

import fr.nathanael2611.modularvoicechat.api.dispatcher.IVoiceDispatcher;
import fr.nathanael2611.modularvoicechat.server.dispatcher.DistanceBasedVoiceDispatcher;
import fr.nathanael2611.modularvoicechat.server.dispatcher.GlobalVoiceDispatcher;
import net.minecraftforge.common.config.Config;

@Config(modid="modularvc", name="ModularVoiceChat/ServerConfig")
public class ServerConfig {
    @Config.Comment(value={"This is the general config of ModularVoiceChat"})
    public static General generalConfig = new General();

    public static class Dispatcher {
        @Config.Comment(value={"The DispatchType", " - \"distanced\" for a distance-based voice-dispatch", " - \"global\" for a global, to all players, voice-dispatch"})
        public String dispatchType = "distanced";
        @Config.Comment(value={})
        public int maxDistance = 15;
        @Config.Comment(value={})
        public boolean fadeOut = true;

        public IVoiceDispatcher createDispatcher() {
            if (this.dispatchType.equalsIgnoreCase("global")) {
                return new GlobalVoiceDispatcher();
            }
            return new DistanceBasedVoiceDispatcher(this.maxDistance, this.fadeOut);
        }
    }

    public static class General {
        @Config.Comment(value={"The vocal-server port"})
        public int port = 7656;
        @Config.Comment(value={"Define if the micro on the speaking-players will be rendered."})
        public boolean showWhoSpeak = false;
        @Config.Comment(value={"The used voice-dispatcher"})
        public Dispatcher dispatcher = new Dispatcher();
        @Config.Comment(value={"This field is optionnal, but may correct some issue with connecting to voice-server!", "By providing an given hostname you are assured that all players use the same."})
        public String forcedHostname = "";
    }
}

