/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.server.dispatcher;

import fr.nathanael2611.modularvoicechat.api.HearDistanceEvent;
import fr.nathanael2611.modularvoicechat.api.VoiceDispatchEvent;
import fr.nathanael2611.modularvoicechat.api.dispatcher.IVoiceDispatcher;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DistanceBasedVoiceDispatcher
implements IVoiceDispatcher {
    private final int MAX_DISTANCE;
    private boolean fadeOut;

    public DistanceBasedVoiceDispatcher(int maxDistance, boolean fadeOut) {
        this.MAX_DISTANCE = maxDistance;
        this.fadeOut = fadeOut;
    }

    @Override
    public void dispatch(VoiceDispatchEvent event) {
        for (EntityPlayerMP connectedPlayer : event.getVoiceServer().getConnectedPlayers()) {
            double maxDistance;
            double distance;
            if (connectedPlayer == event.getSpeaker() || !((distance = (double)event.getSpeaker().func_70032_d((Entity)connectedPlayer)) <= (maxDistance = this.getHearDistance(event.getSpeaker(), connectedPlayer)))) continue;
            int volume = this.fadeOut ? 100 - (int)Helpers.getPercent(distance, maxDistance) : 100;
            event.dispatchTo(connectedPlayer, volume, event.getProperties());
        }
    }

    public double getHearDistance(EntityPlayerMP speaker, EntityPlayerMP hearer) {
        HearDistanceEvent hearDistanceEvent = new HearDistanceEvent(speaker, hearer, this.MAX_DISTANCE);
        MinecraftForge.EVENT_BUS.post((Event)hearDistanceEvent);
        return hearDistanceEvent.getDistance();
    }
}

