/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.util;

import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class Helpers {
    public static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Random RANDOM = new Random();
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("hh:mm");

    public static String readFileToString(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            reader.close();
            return stringBuilder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static List<String> createListFrilStrings(String ... str) {
        return new ArrayList<String>(Arrays.asList(str));
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Helpers.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = Helpers.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return Helpers.copyLarge(input, output, new byte[bufferSize]);
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return Helpers.copy(input, output, 4096);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static boolean isValidJson(String json) {
        try {
            return new JsonParser().parse(json).getAsJsonObject() != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isOP(String playerName) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!server.func_71262_S()) {
            return true;
        }
        for (String oppedPlayerName : server.func_184103_al().func_152606_n()) {
            if (!oppedPlayerName.equalsIgnoreCase(playerName)) continue;
            return true;
        }
        return false;
    }

    public static EntityPlayerMP getPlayerMP(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return (EntityPlayerMP)player;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(player.func_70005_c_());
    }

    public static EntityPlayerMP getPlayerByUsername(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
    }

    public static EntityPlayerMP getPlayerByEntityId(int entityId) {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (player.func_145782_y() != entityId) continue;
            return player;
        }
        return null;
    }

    public static double getPercent(double value, double max) {
        return value * 100.0 / max;
    }

    public static float getPercent(float value, float max) {
        return value * 100.0f / max;
    }

    public static int getPercent(int value, int max) {
        return value * 100 / max;
    }

    public static double randomDouble(double min, double max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return min + (max - min) * RANDOM.nextDouble();
    }

    public static int randomInteger(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static int crossMult(double value, double max, double factor) {
        return (int)(value * factor / max);
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean parseOrFalse(String str) {
        try {
            return Boolean.parseBoolean(str);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int parseOrZero(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static double parseDoubleOrZero(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public static String[] getStringListAsArray(List<String> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static void log(String string) {
        System.out.println(String.format("[%s] [%s] " + string, DATE_FORMAT.format(new Date()), "ModularVoiceChat"));
    }

    public static String clientGetPlayerNameForId(int id) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
        if (e == null) {
            return null;
        }
        return e.func_70005_c_();
    }
}

