/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.entity.SoundHandler;
import mchorse.metamorph.util.InvokeUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.reflect.FieldUtils;

public class EntityMorph
extends AbstractMorph
implements IBodyPartProvider {
    @SideOnly(value=Side.CLIENT)
    public static EntityLivingBase renderEntity;
    @SideOnly(value=Side.CLIENT)
    public static Map<Render, LayerBodyPart> bodyPartMap;
    public BodyPartManager parts = new BodyPartManager();
    protected EntityLivingBase entity;
    protected NBTTagCompound entityData;
    protected boolean customSettings;
    protected boolean updatingEntity = false;
    @SideOnly(value=Side.CLIENT)
    public RenderLivingBase renderer;
    @SideOnly(value=Side.CLIENT)
    public boolean triedHands;
    @SideOnly(value=Side.CLIENT)
    public LayerBodyPart layer;
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation texture;
    @SideOnly(value=Side.CLIENT)
    public ModelRenderer leftHand;
    @SideOnly(value=Side.CLIENT)
    public ModelRenderer rightHand;
    @SideOnly(value=Side.CLIENT)
    public Map<String, ModelRenderer> limbs;
    public ResourceLocation userTexture;
    public float scale = 1.0f;
    @SideOnly(value=Side.CLIENT)
    private ITextureObject lastTexture;

    @Override
    public BodyPartManager getBodyPart() {
        return this.parts;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        String name = this.name;
        try {
            name = EntityList.func_75621_b((Entity)this.getEntity((World)Minecraft.func_71410_x().field_71441_e));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String key = "entity." + name + ".name";
        String result = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        return key.equals(result) ? name : result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        EntityLivingBase entity = this.getEntity(player.field_70170_p);
        if (entity.field_70131_O > 2.0f) {
            scale *= 2.0f / entity.field_70131_O;
        } else if ((double)entity.field_70131_O < 0.6) {
            scale = (float)((double)scale * (0.5 / (double)entity.field_70131_O));
        }
        if (this.name.equals("minecraft:ghast")) {
            scale = 5.0f;
        } else if (this.name.equals("minecraft:guardian") && (double)entity.field_70131_O > 1.8) {
            scale *= 1.0f / entity.field_70131_O;
        }
        this.parts.initBodyParts();
        if (!this.parts.parts.isEmpty()) {
            this.setupLimbs();
        }
        this.setupBodyPart();
        this.replaceUserTexture();
        GuiUtils.drawEntityOnScreen((int)x, (int)y, (float)scale, (EntityLivingBase)entity, (float)alpha);
        this.restoreMobTexture();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        if (!this.settings.hands) {
            return true;
        }
        if (!this.triedHands && this.renderer != null) {
            this.setupTexture();
            this.setupHands();
            this.triedHands = true;
        }
        if (this.renderer == null || this.texture == null || this.leftHand == null || this.rightHand == null) {
            return true;
        }
        this.replaceUserTexture();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        ModelBase model = this.renderer.func_177087_b();
        model.field_78095_p = 0.0f;
        model.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)this.entity);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            float rax = this.rightHand.field_78795_f;
            float ray = this.rightHand.field_78796_g;
            float raz = this.rightHand.field_78808_h;
            float rpx = this.rightHand.field_78800_c;
            float rpy = this.rightHand.field_78797_d;
            float rpz = this.rightHand.field_78798_e;
            this.rightHand.field_78795_f = 0.0f;
            this.rightHand.field_78796_g = 0.0f;
            this.rightHand.field_78808_h = 0.0f;
            this.rightHand.field_78800_c = -6.0f;
            this.rightHand.field_78797_d = 4.0f;
            this.rightHand.field_78798_e = 0.0f;
            this.rightHand.func_78785_a(0.0625f);
            this.rightHand.field_78795_f = rax;
            this.rightHand.field_78796_g = ray;
            this.rightHand.field_78808_h = raz;
            this.rightHand.field_78800_c = rpx;
            this.rightHand.field_78797_d = rpy;
            this.rightHand.field_78798_e = rpz;
        } else {
            float rax = this.leftHand.field_78795_f;
            float rpx = this.leftHand.field_78800_c;
            float rpy = this.leftHand.field_78797_d;
            float rpz = this.leftHand.field_78798_e;
            this.leftHand.field_78795_f = 0.0f;
            this.leftHand.field_78800_c = 6.0f;
            this.leftHand.field_78797_d = 4.0f;
            this.leftHand.field_78798_e = 0.0f;
            this.leftHand.func_78785_a(0.0625f);
            this.leftHand.field_78795_f = rax;
            this.leftHand.field_78800_c = rpx;
            this.leftHand.field_78797_d = rpy;
            this.leftHand.field_78798_e = rpz;
        }
        this.restoreMobTexture();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity == null) {
            return;
        }
        RenderLivingBase render = this.renderer;
        if (render == null) {
            this.getEntity(entity.field_70170_p);
            render = this.renderer;
        }
        if (render != null) {
            this.entity.field_70177_z = entity.field_70177_z;
            this.entity.field_70125_A = entity.field_70125_A;
            this.entity.field_70759_as = entity.field_70759_as;
            this.entity.field_70761_aq = entity.field_70761_aq;
            this.entity.field_70126_B = entity.field_70126_B;
            this.entity.field_70127_C = entity.field_70127_C;
            this.entity.field_70758_at = entity.field_70758_at;
            this.entity.field_70760_ar = entity.field_70760_ar;
            this.parts.initBodyParts();
            if (!this.parts.parts.isEmpty()) {
                this.setupLimbs();
            }
            boolean wasSneak = false;
            ModelBase model = render.func_177087_b();
            if (model instanceof ModelBiped) {
                wasSneak = ((ModelBiped)model).field_78117_n;
                ((ModelBiped)model).field_78117_n = entity.func_70093_af();
            }
            renderEntity = entity;
            this.setupBodyPart();
            this.replaceUserTexture();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            if (this.entity instanceof EntityDragon) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                render.func_76986_a(this.entity, 0.0, 0.0, 0.0, entityYaw, partialTicks);
            } else {
                render.func_76986_a(this.entity, 0.0, 0.0, 0.0, entityYaw, partialTicks);
            }
            GlStateManager.func_179121_F();
            this.restoreMobTexture();
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).field_78117_n = wasSneak;
            }
            renderEntity = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setupBodyPart() {
        if (this.layer == null) {
            return;
        }
        this.layer.morph = this;
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderBodyParts(EntityLivingBase target, float partialTicks) {
        GlStateManager.func_179094_E();
        float scale = 0.0625f;
        block0: for (BodyPart part : this.parts.parts) {
            for (Map.Entry<String, ModelRenderer> entry : this.limbs.entrySet()) {
                if (!entry.getKey().equals(part.limb)) continue;
                GlStateManager.func_179094_E();
                entry.getValue().func_78794_c(0.0625f);
                part.render(this, target, partialTicks);
                GlStateManager.func_179121_F();
                continue block0;
            }
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private void replaceUserTexture() {
        if (this.userTexture == null) {
            return;
        }
        if (this.texture == null) {
            this.setupTexture();
        }
        if (this.texture != null) {
            if (this.userTexture.equals((Object)this.texture)) {
                return;
            }
            TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
            Map map = ReflectionUtils.getTextures((TextureManager)textureManager);
            if (map != null) {
                ITextureObject object = (ITextureObject)map.get(this.userTexture);
                if (object == null) {
                    textureManager.func_110577_a(this.userTexture);
                    object = (ITextureObject)map.get(this.userTexture);
                }
                if (object != null) {
                    this.lastTexture = (ITextureObject)map.get(this.texture);
                    if (this.lastTexture == null) {
                        textureManager.func_110577_a(this.texture);
                        this.lastTexture = (ITextureObject)map.get(this.texture);
                    }
                    if (this.lastTexture != null) {
                        map.put(this.texture, object);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void restoreMobTexture() {
        if (this.lastTexture != null) {
            TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
            Map map = ReflectionUtils.getTextures((TextureManager)textureManager);
            map.put(this.texture, this.lastTexture);
            this.lastTexture = null;
        }
    }

    public void setEntity(EntityLivingBase entity) {
        this.entity = entity;
        entity.func_70606_j(entity.func_110138_aP());
        entity.field_70145_X = true;
        entity.func_174805_g(true);
        if (this.settings == MorphSettings.DEFAULT) {
            this.customSettings = true;
            this.settings = new MorphSettings();
            if (this.settings.health == 20) {
                this.settings.health = (int)entity.func_110138_aP();
            }
            boolean bl = this.settings.hostile = entity instanceof EntityMob || entity instanceof EntityAnimal;
        }
        if (entity instanceof EntityLiving && !(entity instanceof EntityDragon)) {
            ((EntityLiving)entity).func_94061_f(true);
        }
        if (entity instanceof EntityAgeable && !entity.field_70170_p.field_72995_K) {
            ((EntityAgeable)entity).func_98054_a(entity.func_70631_g_());
        }
        if (this.entityData == null) {
            this.entityData = EntityUtils.stripEntityNBT(this.entity.serializeNBT());
        }
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public EntityLivingBase getEntity(World world) {
        if (this.entity == null) {
            this.setupEntity(world);
        }
        return this.entity;
    }

    @Override
    public void update(EntityLivingBase target) {
        IMorphing cap;
        if (this.entity == null) {
            this.setupEntity(target.field_70170_p);
        }
        this.updatingEntity = true;
        this.entity.func_184224_h(true);
        this.updateEntity(target);
        this.updatingEntity = false;
        this.entity.field_70725_aQ = target.field_70725_aQ;
        this.entity.field_70737_aN = target.field_70737_aN;
        if (this.entity instanceof EntityRabbit && target.field_70173_aa % 10 == 0 && (double)target.field_70721_aZ > 0.4) {
            ((EntityRabbit)this.entity).func_184770_cZ();
        }
        super.update(target);
        if (target.field_70170_p.field_72995_K) {
            int i = 0;
            for (ItemStack stack : target.func_184209_aF()) {
                this.entity.func_184201_a(EntityUtils.slotForIndex(i), stack);
                ++i;
            }
            this.entity.func_82142_c(target.func_82150_aj());
        }
        this.entity.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        this.entity.field_70142_S = target.field_70142_S;
        this.entity.field_70137_T = target.field_70137_T;
        this.entity.field_70136_U = target.field_70136_U;
        this.entity.field_70169_q = target.field_70169_q;
        this.entity.field_70167_r = target.field_70167_r;
        this.entity.field_70166_s = target.field_70166_s;
        this.entity.field_70177_z = target.field_70177_z;
        this.entity.field_70125_A = target.field_70125_A;
        this.entity.field_70759_as = target.field_70759_as;
        this.entity.field_70761_aq = target.field_70761_aq;
        this.entity.field_70159_w = target.field_70159_w;
        this.entity.field_70181_x = target.field_70181_x;
        this.entity.field_70179_y = target.field_70179_y;
        this.entity.field_82175_bq = target.field_82175_bq;
        this.entity.field_70733_aJ = target.field_70733_aJ;
        this.entity.field_184619_aG = target.field_184619_aG;
        this.entity.field_70721_aZ = target.field_70721_aZ;
        this.entity.field_70126_B = target.field_70126_B;
        this.entity.field_70127_C = target.field_70127_C;
        this.entity.field_70758_at = target.field_70758_at;
        this.entity.field_70760_ar = target.field_70760_ar;
        this.entity.field_70732_aI = target.field_70732_aI;
        this.entity.field_184618_aE = target.field_184618_aE;
        this.entity.field_184622_au = target.field_184622_au;
        if (this.entity instanceof EntityLiving) {
            ((EntityLiving)this.entity).func_184641_n(target.func_184591_cq() == EnumHandSide.LEFT);
        }
        this.entity.field_70143_R = target instanceof EntityPlayer && ((EntityPlayer)target).func_184812_l_() ? 0.0f : target.field_70143_R;
        this.entity.func_70095_a(target.func_70093_af());
        this.entity.func_70031_b(target.func_70051_ag());
        this.entity.field_70122_E = target.field_70122_E;
        this.entity.field_70160_al = target.field_70160_al;
        this.entity.field_70173_aa = target.field_70173_aa;
        this.entity.func_70606_j(target.func_110143_aJ());
        if (target instanceof EntityPlayer && (cap = Morphing.get((EntityPlayer)target)) != null) {
            this.entity.func_70050_g(cap.getHasSquidAir() ? cap.getSquidAir() : target.func_70086_ai());
        }
        boolean targetRiding = target.func_184218_aH();
        boolean entityRiding = this.entity.func_184218_aH();
        if (targetRiding && !entityRiding) {
            this.entity.func_184220_m((Entity)new EntityPig(this.entity.field_70170_p));
        } else if (!targetRiding && entityRiding) {
            this.entity.func_184210_p();
        }
        if (targetRiding) {
            EntityPig ride = (EntityPig)this.entity.func_184187_bx();
            Entity targetRide = target.func_184187_bx();
            if (ride == null || targetRide == null) {
                return;
            }
            ride.field_70177_z = targetRide.field_70177_z;
            ride.field_70125_A = targetRide.field_70125_A;
            ride.field_70126_B = targetRide.field_70126_B;
            ride.field_70127_C = targetRide.field_70127_C;
            if (targetRide instanceof EntityLivingBase) {
                EntityLivingBase trr = (EntityLivingBase)targetRide;
                ride.field_70759_as = trr.field_70759_as;
                ride.field_70761_aq = trr.field_70761_aq;
                ride.field_70758_at = trr.field_70758_at;
                ride.field_70760_ar = trr.field_70760_ar;
            } else {
                ride.field_70759_as = target.field_70759_as;
                ride.field_70761_aq = target.field_70761_aq;
                ride.field_70758_at = target.field_70758_at;
                ride.field_70760_ar = target.field_70760_ar;
            }
        }
        if (this.entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)this.entity;
            horse.func_110251_o(this.entityData.func_74764_b("SaddleItem"));
        }
        this.parts.updateBodyLimbs(this, target);
    }

    protected void updateEntity(EntityLivingBase target) {
        if (this.settings.updates) {
            if (!Metamorph.showMorphIdleSounds.get()) {
                this.entity.func_174810_b(true);
            }
            this.entity.func_70071_h_();
            this.entity.func_174810_b(false);
        }
    }

    public boolean isUpdatingEntity() {
        return this.updatingEntity;
    }

    @Override
    protected void updateUserHitbox(EntityLivingBase target) {
        boolean isAnimalChild;
        float width = this.entity.field_70130_N;
        float height = this.entity.field_70131_O;
        boolean bl = isAnimalChild = this.entity instanceof EntityAgeable && this.entityData.func_74762_e("Age") < 0;
        if (!target.field_70170_p.field_72995_K && isAnimalChild) {
            width = (float)((double)width * 0.5);
            height = (float)((double)height * 0.5);
        }
        this.updateSize(target, width, height);
    }

    public void setupEntity(World world) {
        EntityLivingBase created = (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.name), (World)world);
        try {
            created.deserializeNBT(this.entityData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        created.field_70725_aQ = 0;
        created.field_70737_aN = 0;
        created.field_184619_aG = 0.0f;
        created.func_70015_d(0);
        this.setEntity(created);
        if (world.field_72995_K) {
            this.setupRenderer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setupRenderer() {
        Render renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity);
        if (renderer instanceof RenderLivingBase) {
            this.renderer = (RenderLivingBase)renderer;
            ModelBase model = this.renderer.func_177087_b();
            if (this.customSettings && model instanceof ModelBiped || model instanceof ModelQuadruped) {
                this.settings.hands = true;
            }
            if (bodyPartMap == null) {
                bodyPartMap = new HashMap<Render, LayerBodyPart>();
            }
            this.layer = bodyPartMap.get(renderer);
            if (this.layer == null) {
                this.layer = new LayerBodyPart();
                bodyPartMap.put((Render)this.renderer, this.layer);
                this.renderer.func_177094_a((LayerRenderer)this.layer);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setupTexture() {
        if (this.texture != null) {
            return;
        }
        Class<?> clazz = this.renderer.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?>[] args = method.getParameterTypes();
            boolean hasEntityArg = args.length == 1 && Entity.class.isAssignableFrom(args[0]);
            boolean returnsRL = method.getReturnType().isAssignableFrom(ResourceLocation.class);
            if (!hasEntityArg || !returnsRL) continue;
            try {
                method.setAccessible(true);
                this.texture = (ResourceLocation)method.invoke((Object)this.renderer, this.entity);
            }
            catch (Exception e) {
                Metamorph.log("Failed to get texture of a morph '" + this.name + "'!");
                e.printStackTrace();
            }
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setupHands() {
        ModelBase model = this.renderer.func_177087_b();
        model.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)this.entity);
        if (model instanceof ModelBiped) {
            this.leftHand = ((ModelBiped)model).field_178724_i;
            this.rightHand = ((ModelBiped)model).field_178723_h;
        } else if (model instanceof ModelQuadruped) {
            this.leftHand = ((ModelQuadruped)model).field_78146_d;
            this.rightHand = ((ModelQuadruped)model).field_78147_e;
        } else {
            ArrayList left = new ArrayList();
            ArrayList right = new ArrayList();
            left.addAll(model.field_78092_r);
            right.addAll(model.field_78092_r);
            Collections.sort(left, new Comparator<ModelRenderer>(){

                @Override
                public int compare(ModelRenderer a, ModelRenderer b) {
                    return (int)(a.field_78800_c - b.field_78800_c < 0.0f ? Math.floor(a.field_78800_c - b.field_78800_c) : Math.ceil(a.field_78800_c - b.field_78800_c));
                }
            });
            Collections.sort(right, new Comparator<ModelRenderer>(){

                @Override
                public int compare(ModelRenderer a, ModelRenderer b) {
                    return (int)(b.field_78800_c - a.field_78800_c < 0.0f ? Math.floor(b.field_78800_c - a.field_78800_c) : Math.ceil(b.field_78800_c - a.field_78800_c));
                }
            });
            this.leftHand = left.isEmpty() ? null : (ModelRenderer)left.get(0);
            this.rightHand = right.isEmpty() ? null : (ModelRenderer)right.get(0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupLimbs() {
        Field[] fields;
        if (this.limbs != null) {
            return;
        }
        ModelBase model = this.renderer.func_177087_b();
        this.limbs = new HashMap<String, ModelRenderer>();
        for (Field field : fields = FieldUtils.getAllFields(model.getClass())) {
            field.setAccessible(true);
            if (!field.getType().isAssignableFrom(ModelRenderer.class)) continue;
            try {
                ModelRenderer renderer = (ModelRenderer)field.get(model);
                this.limbs.put(field.getName(), renderer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEntityData(NBTTagCompound tag) {
        this.entityData = tag;
    }

    public NBTTagCompound getEntityData() {
        return this.entityData;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof EntityMorph) {
            EntityMorph morph = (EntityMorph)obj;
            boolean theSame = EntityUtils.compareData(morph.entityData, this.entityData);
            result = result && theSame;
            result = result && Objects.equals(morph.parts, this.parts);
            result = result && morph.scale == this.scale;
            result = result && Objects.equals(morph.userTexture, this.userTexture);
        }
        return result;
    }

    @Override
    public void reset() {
        this.parts.reset();
        this.resetEntity();
        this.entityData = null;
        this.scale = 1.0f;
        this.userTexture = null;
        if (this.customSettings) {
            this.settings = MorphSettings.DEFAULT;
            this.customSettings = false;
        }
    }

    public void resetEntity() {
        if (this.entity != null) {
            if (this.entity.field_70170_p.field_72995_K) {
                this.renderer = null;
                this.triedHands = false;
            }
            this.entity = null;
        }
    }

    @Override
    public AbstractMorph create() {
        return new EntityMorph();
    }

    @Override
    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof EntityMorph) {
            EntityMorph morph = (EntityMorph)from;
            this.entityData = morph.entityData == null ? null : morph.entityData.func_74737_b();
            this.parts.copy(morph.parts);
            this.scale = morph.scale;
            this.userTexture = RLUtils.clone((ResourceLocation)morph.userTexture);
        }
    }

    @Override
    public float getWidth(EntityLivingBase target) {
        if (this.entity == null) {
            this.setupEntity(target.field_70170_p);
        }
        return this.entity.field_70130_N;
    }

    @Override
    public float getHeight(EntityLivingBase target) {
        if (this.entity == null) {
            this.setupEntity(target.field_70170_p);
        }
        return this.entity.field_70131_O;
    }

    @Override
    public SoundEvent getHurtSound(EntityLivingBase target, DamageSource damageSource) {
        EntityLivingBase entity = this.getEntity(target.field_70170_p);
        try {
            Method methodHurtSound = InvokeUtil.getPrivateMethod(entity.getClass(), EntityLivingBase.class, SoundHandler.GET_HURT_SOUND.getName(), DamageSource.class);
            SoundEvent hurtSound = (SoundEvent)methodHurtSound.invoke((Object)entity, damageSource);
            if (hurtSound == null) {
                hurtSound = SoundHandler.NO_SOUND;
            }
            return hurtSound;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public SoundEvent getDeathSound(EntityLivingBase target) {
        EntityLivingBase entity = this.getEntity(target.field_70170_p);
        try {
            Method methodDeathSound = InvokeUtil.getPrivateMethod(entity.getClass(), EntityLivingBase.class, SoundHandler.GET_DEATH_SOUND.getName(), new Class[0]);
            SoundEvent deathSound = (SoundEvent)methodDeathSound.invoke((Object)entity, new Object[0]);
            if (deathSound == null) {
                deathSound = SoundHandler.NO_SOUND;
            }
            return deathSound;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasCustomStepSound(EntityLivingBase target) {
        return true;
    }

    @Override
    public void playStepSound(EntityLivingBase target) {
        EntityLivingBase entity = this.getEntity(target.field_70170_p);
        try {
            Method methodPlayStep = InvokeUtil.getPrivateMethod(entity.getClass(), Entity.class, SoundHandler.PLAY_STEP_SOUND.getName(), BlockPos.class, Block.class);
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f));
            int z = MathHelper.func_76128_c((double)entity.field_70161_v);
            BlockPos pos = new BlockPos(x, y, z);
            Block block = entity.field_70170_p.func_180495_p(pos).func_177230_c();
            methodPlayStep.invoke((Object)entity, pos, block);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onChangeDimension(EntityPlayer player, int oldDim, int currentDim) {
        if (this.entity != null) {
            this.entity.field_70170_p = player.field_70170_p;
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        NBTTagList bodyParts;
        super.toNBT(tag);
        tag.func_74782_a("EntityData", (NBTBase)this.entityData);
        tag.func_74776_a("Scale", this.scale);
        if (this.userTexture != null) {
            tag.func_74782_a("Texture", RLUtils.writeNbt((ResourceLocation)this.userTexture));
        }
        if ((bodyParts = this.parts.toNBT()) != null) {
            tag.func_74782_a("BodyParts", (NBTBase)bodyParts);
        }
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.entityData = tag.func_74775_l("EntityData");
        if (tag.func_74764_b("Scale")) {
            this.scale = tag.func_74760_g("Scale");
        }
        if (tag.func_74764_b("Texture")) {
            this.userTexture = RLUtils.create((NBTBase)tag.func_74781_a("Texture"));
        }
        if (tag.func_150297_b("BodyParts", 9)) {
            this.parts.fromNBT(tag.func_150295_c("BodyParts", 10));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerBodyPart
    implements LayerRenderer<EntityLivingBase> {
        public EntityMorph morph;

        public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (this.morph != null) {
                if (entity.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                this.morph.renderBodyParts(entity, 1.0f);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

