/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.bodypart;

import com.google.common.base.Objects;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mchorse.mclib.client.Draw;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class BodyPart {
    public static Vector3f cachedTranslation = new Vector3f();
    public static Vector3f cachedAngularVelocity = new Vector3f();
    public static Matrix4f modelViewMatrix = new Matrix4f();
    public Morph morph = new Morph();
    public ItemStack[] slots = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    public Vector3f translate = new Vector3f();
    public Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f rotate = new Vector3f(180.0f, 0.0f, 0.0f);
    public boolean useTarget = false;
    public boolean enabled = true;
    public boolean animate = true;
    public String limb = "";
    private EntityLivingBase entity;
    private Vector3f lastTranslate;
    private Vector3f lastScale;
    private Vector3f lastRotate;
    private Vector3f previousRotation = new Vector3f();

    @SideOnly(value=Side.CLIENT)
    public void init() {
        this.entity = new DummyEntity((World)Minecraft.func_71410_x().field_71441_e);
        this.entity.field_70177_z = this.entity.field_70126_B;
        this.entity.field_70759_as = this.entity.field_70758_at;
        this.entity.field_70122_E = true;
        this.updateEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEntity() {
        if (this.entity == null) {
            return;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            this.entity.func_184201_a(EntityEquipmentSlot.values()[i], this.slots[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(AbstractMorph parent, EntityLivingBase entity, float partialTicks) {
        EntityLivingBase entityLivingBase = entity = this.useTarget ? entity : this.entity;
        if (this.morph.get() == null || entity == null || !this.enabled) {
            return;
        }
        Animation animation = parent instanceof IAnimationProvider ? ((IAnimationProvider)((Object)parent)).getAnimation() : null;
        float tx = this.translate.x;
        float ty = this.translate.y;
        float tz = this.translate.z;
        float sx = this.scale.x;
        float sy = this.scale.y;
        float sz = this.scale.z;
        float rx = this.rotate.x;
        float ry = this.rotate.y;
        float rz = this.rotate.z;
        if (animation != null && animation.isInProgress() && this.lastTranslate != null && this.animate) {
            Interpolation inter = animation.interp;
            float factor = animation.getFactor(partialTicks);
            tx = inter.interpolate(this.lastTranslate.x, tx, factor);
            ty = inter.interpolate(this.lastTranslate.y, ty, factor);
            tz = inter.interpolate(this.lastTranslate.z, tz, factor);
            sx = inter.interpolate(this.lastScale.x, sx, factor);
            sy = inter.interpolate(this.lastScale.y, sy, factor);
            sz = inter.interpolate(this.lastScale.z, sz, factor);
            rx = inter.interpolate(this.lastRotate.x, rx, factor);
            ry = inter.interpolate(this.lastRotate.y, ry, factor);
            rz = inter.interpolate(this.lastRotate.z, rz, factor);
        }
        if (!this.morph.isEmpty()) {
            MatrixUtils.Transformation modelView = new MatrixUtils.Transformation();
            if (MatrixUtils.matrix != null) {
                modelView = MatrixUtils.extractTransformations((Matrix4f)MatrixUtils.matrix, (Matrix4f)MatrixUtils.readModelView((Matrix4f)modelViewMatrix));
            }
            this.morph.get().cachedTranslation.set((Tuple3f)cachedTranslation);
            Vector3f translate = new Vector3f(tx, ty, tz);
            Matrix3f transformation = new Matrix3f(modelView.getRotation3f());
            transformation.mul(modelView.getScale3f());
            transformation.transform((Tuple3f)translate);
            this.morph.get().cachedTranslation.add((Tuple3f)translate);
        }
        cachedTranslation.set(0.0f, 0.0f, 0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        GL11.glRotatef((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)sx, (float)sy, (float)sz);
        float rotationYaw = entity.field_70761_aq;
        float prevRotationYaw = entity.field_70760_ar;
        float rotationYawHead = entity.field_70759_as;
        float prevRotationYawHead = entity.field_70758_at;
        entity.field_70759_as -= entity.field_70761_aq;
        entity.field_70758_at -= entity.field_70760_ar;
        entity.field_70760_ar = 0.0f;
        entity.field_70761_aq = 0.0f;
        MorphUtils.render(this.morph.get(), entity, 0.0, 0.0, 0.0, 0.0f, partialTicks);
        entity.field_70761_aq = rotationYaw;
        entity.field_70760_ar = prevRotationYaw;
        entity.field_70759_as = rotationYawHead;
        entity.field_70758_at = prevRotationYawHead;
        if (GuiModelRenderer.isRendering()) {
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179090_x();
            GlStateManager.func_179097_i();
            GlStateManager.func_179140_f();
            Draw.point((double)0.0, (double)0.0, (double)0.0);
            if (Metamorph.renderBodyPartAxis.get()) {
                Draw.axis((float)0.1f);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179098_w();
        }
        GL11.glPopMatrix();
    }

    public void update(AbstractMorph parent, EntityLivingBase entity) {
        EntityLivingBase entityLivingBase = entity = this.useTarget ? entity : this.entity;
        if (entity != null && this.enabled) {
            AbstractMorph morph;
            if (!this.useTarget) {
                ++this.entity.field_70173_aa;
            }
            if ((morph = this.morph.get()) != null) {
                float rotationYaw = entity.field_70761_aq;
                float prevRotationYaw = entity.field_70760_ar;
                float rotationYawHead = entity.field_70759_as;
                float prevRotationYawHead = entity.field_70758_at;
                entity.field_70759_as -= entity.field_70761_aq;
                entity.field_70758_at -= entity.field_70760_ar;
                entity.field_70760_ar = 0.0f;
                entity.field_70761_aq = 0.0f;
                morph.update(entity);
                entity.field_70761_aq = rotationYaw;
                entity.field_70760_ar = prevRotationYaw;
                entity.field_70759_as = rotationYawHead;
                entity.field_70758_at = prevRotationYawHead;
            }
        }
    }

    public boolean canMerge(BodyPart part) {
        this.morph.set(part.morph.copy());
        if (Objects.equal((Object)this.limb, (Object)part.limb)) {
            this.lastTranslate = new Vector3f(this.translate);
            this.lastScale = new Vector3f(this.scale);
            this.lastRotate = new Vector3f(this.rotate);
        } else {
            this.lastTranslate = null;
            this.lastScale = null;
            this.lastRotate = null;
        }
        this.translate.set((Tuple3f)part.translate);
        this.scale.set((Tuple3f)part.scale);
        this.rotate.set((Tuple3f)part.rotate);
        this.useTarget = part.useTarget;
        this.enabled = part.enabled;
        this.animate = part.animate;
        for (int i = 0; i < part.slots.length; ++i) {
            this.slots[i] = part.slots[i];
        }
        this.limb = part.limb;
        return true;
    }

    public void pause(BodyPart previous, int offset) {
        if (previous != null && Objects.equal((Object)this.limb, (Object)previous.limb)) {
            this.lastTranslate = new Vector3f(previous.translate);
            this.lastScale = new Vector3f(previous.scale);
            this.lastRotate = new Vector3f(previous.rotate);
        }
        MorphUtils.pause(this.morph.get(), previous == null ? null : previous.morph.get(), offset);
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof BodyPart) {
            BodyPart part = (BodyPart)obj;
            result = Objects.equal((Object)this.morph, (Object)part.morph);
            result = result && Objects.equal((Object)this.translate, (Object)part.translate);
            result = result && Objects.equal((Object)this.scale, (Object)part.scale);
            result = result && Objects.equal((Object)this.rotate, (Object)part.rotate);
            result = result && this.useTarget == part.useTarget;
            result = result && this.enabled == part.enabled;
            result = result && this.animate == part.animate;
            for (int i = 0; i < this.slots.length; ++i) {
                result = result && ItemStack.func_77989_b((ItemStack)this.slots[i], (ItemStack)part.slots[i]);
            }
            result = result && Objects.equal((Object)this.limb, (Object)part.limb);
        }
        return result;
    }

    public BodyPart copy() {
        BodyPart part = new BodyPart();
        part.morph.copy(this.morph);
        part.translate.set((Tuple3f)this.translate);
        part.scale.set((Tuple3f)this.scale);
        part.rotate.set((Tuple3f)this.rotate);
        part.useTarget = this.useTarget;
        part.enabled = this.enabled;
        part.animate = this.animate;
        for (int i = 0; i < this.slots.length; ++i) {
            part.slots[i] = this.slots[i];
        }
        part.limb = this.limb;
        return part;
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("Morph", 10)) {
            this.morph.fromNBT(tag.func_74775_l("Morph"));
        }
        if (tag.func_150297_b("Items", 9)) {
            NBTTagList items = tag.func_150295_c("Items", 10);
            int c = items.func_74745_c();
            for (int i = 0; i < c; ++i) {
                ItemStack stack;
                NBTTagCompound compound = items.func_150305_b(i);
                this.slots[i] = stack = new ItemStack(compound);
            }
        }
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("T", 5), (Vector3f)this.translate);
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("S", 5), (Vector3f)this.scale);
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("R", 5), (Vector3f)this.rotate);
        if (tag.func_74764_b("Target")) {
            this.useTarget = tag.func_74767_n("Target");
        }
        if (tag.func_74764_b("Enabled")) {
            this.enabled = tag.func_74767_n("Enabled");
        }
        if (tag.func_74764_b("Animate")) {
            this.animate = tag.func_74767_n("Animate");
        }
        if (tag.func_74764_b("Limb")) {
            this.limb = tag.func_74779_i("Limb");
        }
    }

    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound morph = this.morph.toNBT();
        if (morph != null) {
            tag.func_74782_a("Morph", (NBTBase)morph);
        }
        NBTTagList list = new NBTTagList();
        int empty = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            ItemStack stack = this.slots[i];
            if (!stack.func_190926_b()) {
                stack.func_77955_b(compound);
            } else {
                ++empty;
            }
            list.func_74742_a((NBTBase)compound);
        }
        if (empty != this.slots.length) {
            tag.func_74782_a("Items", (NBTBase)list);
        }
        if (this.translate.x != 0.0f || this.translate.y != 0.0f || this.translate.z != 0.0f) {
            tag.func_74782_a("T", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (Vector3f)this.translate));
        }
        if (this.scale.x != 1.0f || this.scale.y != 1.0f || this.scale.z != 1.0f) {
            tag.func_74782_a("S", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (Vector3f)this.scale));
        }
        if (this.rotate.x != 180.0f || this.rotate.y != 0.0f || this.rotate.z != 0.0f) {
            tag.func_74782_a("R", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (Vector3f)this.rotate));
        }
        if (this.useTarget) {
            tag.func_74757_a("Target", this.useTarget);
        }
        if (!this.enabled) {
            tag.func_74757_a("Enabled", this.enabled);
        }
        if (!this.animate) {
            tag.func_74757_a("Animate", this.animate);
        }
        if (!this.limb.isEmpty()) {
            tag.func_74778_a("Limb", this.limb);
        }
    }
}

