/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import mchorse.mclib.utils.JsonUtils;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.capabilities.render.EntitySelector;
import mchorse.metamorph.capabilities.render.EntitySelectorAdapter;
import mchorse.metamorph.capabilities.render.IModelRenderer;
import mchorse.metamorph.capabilities.render.ModelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public class EntityModelHandler {
    public static final List<EntitySelector> selectors = new ArrayList<EntitySelector>();
    public Gson entitySelector;
    public Entity currentRendering;

    public EntityModelHandler() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(EntitySelector.class, (Object)new EntitySelectorAdapter());
        gson.setPrettyPrinting();
        this.entitySelector = gson.create();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
        EntityLivingBase entity = event.getEntity();
        IModelRenderer cap = ModelRenderer.get((Entity)entity);
        if (cap != null && this.currentRendering == null) {
            this.currentRendering = entity;
            if (cap.render(entity, event.getX(), event.getY(), event.getZ(), Minecraft.func_71410_x().func_184121_ak())) {
                event.setCanceled(true);
            }
            this.currentRendering = null;
        }
    }

    @SubscribeEvent
    public void onUpdateEntity(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        IModelRenderer cap = ModelRenderer.get((Entity)entity);
        if (cap != null && entity.field_70170_p.field_72995_K) {
            cap.update(entity);
        }
    }

    public void loadSelectors() {
        File selectorsFile = Metamorph.proxy.selectors;
        if (selectorsFile.exists()) {
            try {
                Type token = new TypeToken<List<EntitySelector>>(){}.getType();
                List selectors = (List)this.entitySelector.fromJson(FileUtils.readFileToString((File)selectorsFile, (Charset)Charset.defaultCharset()), token);
                EntityModelHandler.selectors.clear();
                EntityModelHandler.selectors.addAll(selectors);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveSelectors() {
        try {
            JsonElement element = this.entitySelector.toJsonTree(selectors);
            FileUtils.writeStringToFile((File)Metamorph.proxy.selectors, (String)JsonUtils.jsonToPretty((JsonElement)element), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

