/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client;

import mchorse.metamorph.ClientProxy;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.client.gui.overlays.GuiHud;
import mchorse.metamorph.client.gui.overlays.GuiOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderingHandler {
    private GuiOverlay morphOverlay;
    private GuiHud hud;
    private RenderManager manager;

    public RenderingHandler(GuiOverlay morphOverlay, GuiHud hud) {
        this.morphOverlay = morphOverlay;
        this.hud = hud;
        this.manager = Minecraft.func_71410_x().func_175598_ae();
    }

    @SubscribeEvent
    public void onHUDRender(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.morphOverlay.render(resolution.func_78326_a(), resolution.func_78328_b());
        }
    }

    @SubscribeEvent
    public void onAirRenderPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.AIR || event.isCanceled()) {
            return;
        }
        if (this.hud.renderSquidAir) {
            event.setCanceled(true);
            ScaledResolution resolution = event.getResolution();
            this.hud.renderSquidAir(resolution.func_78326_a(), resolution.func_78328_b());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        IMorphing capability = Morphing.get(player);
        if (capability == null) {
            return;
        }
        int animation = capability.getAnimation();
        if (capability.renderPlayer(player, event.getX(), event.getY(), event.getZ(), player.field_70177_z, event.getPartialRenderTick())) {
            event.setCanceled(true);
        } else if (capability.isAnimating()) {
            float partialTick = event.getPartialRenderTick();
            float anim = 0.0f;
            if (capability.getCurrentMorph() == null && animation <= 10) {
                anim = 1.0f - ((float)animation - partialTick) / 10.0f;
            } else if (capability.getPreviousMorph() == null && animation > 10) {
                anim = ((float)(animation - 10) - partialTick) / 10.0f;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)anim);
        }
    }

    @SubscribeEvent
    public void onNameRender(RenderLivingEvent.Specials.Pre<EntityLivingBase> event) {
        float factor;
        EntityLivingBase host = EntityMorph.renderEntity;
        if (host == null) {
            return;
        }
        event.setCanceled(true);
        EntityLivingBase target = event.getEntity();
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (!this.canRenderName(host) || camera == null) {
            return;
        }
        double dist = target.func_70068_e(camera);
        float f = factor = target.func_70093_af() ? 32.0f : 64.0f;
        if (dist < (double)(factor * factor)) {
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.renderEntityName(target, host.func_145748_c_().func_150254_d(), event.getX(), event.getY(), event.getZ());
        }
    }

    protected boolean canRenderName(EntityLivingBase host) {
        boolean flag;
        EntityPlayerSP entityplayersp = Minecraft.func_71410_x().field_71439_g;
        boolean bl = flag = !host.func_98034_c((EntityPlayer)entityplayersp);
        if (host != entityplayersp) {
            Team team = host.func_96124_cp();
            Team team1 = entityplayersp.func_96124_cp();
            if (team != null) {
                Team.EnumVisible team$enumvisible = team.func_178770_i();
                switch (team$enumvisible) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.func_142054_a(team1) && (team.func_98297_h() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.func_142054_a(team1) && flag;
                    }
                }
                return true;
            }
        }
        if (!(host instanceof EntityPlayer)) {
            flag = flag && host.func_145818_k_();
        }
        return Minecraft.func_71382_s() && host != this.manager.field_78734_h && flag && !host.func_184207_aI();
    }

    protected void renderEntityName(EntityLivingBase entity, String name, double x, double y, double z) {
        if (name.isEmpty()) {
            return;
        }
        boolean sneaking = entity.func_70093_af();
        boolean thirdFrontal = this.manager.field_78733_k.field_74320_O == 2;
        float px = this.manager.field_78735_i;
        float py = this.manager.field_78732_j;
        float pz = entity.field_70131_O + 0.5f - (sneaking ? 0.25f : 0.0f);
        int i = "deadmau5".equals(name) ? -10 : 0;
        EntityRenderer.func_189692_a((FontRenderer)this.manager.func_78716_a(), (String)name, (float)((float)x), (float)((float)y + pz), (float)((float)z), (int)i, (float)px, (float)py, (boolean)thirdFrontal, (boolean)sneaking);
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        MorphManager.INSTANCE.list.reset();
        ClientProxy.survivalScreen = null;
    }
}

