/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.GuiPanelBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.bodypart.GuiBodyPartEditor;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import mchorse.metamorph.client.gui.editor.GuiSettingsPanel;
import mchorse.metamorph.util.MMIcons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAbstractMorph<T extends AbstractMorph>
extends GuiPanelBase<GuiMorphPanel> {
    public static final IKey KEY_CATEGORY = IKey.lang((String)"metamorph.gui.editor.keys.category");
    public GuiCreativeMorphsList morphs;
    public GuiIconElement finish;
    public GuiModelRenderer renderer;
    public GuiSettingsPanel settings;
    protected GuiMorphPanel defaultPanel;
    public T morph;

    public GuiAbstractMorph(Minecraft mc) {
        super(mc);
        this.finish = new GuiIconElement(mc, Icons.CLOSE, b -> this.morphs.exit());
        this.finish.flex().relative((GuiElement)this).set(0.0f, 0.0f, 20.0f, 20.0f).y(1.0f, -20);
        this.renderer = this.createMorphRenderer(mc);
        this.renderer.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.settings = new GuiSettingsPanel(mc, this);
        this.defaultPanel = this.settings;
        this.registerPanel(this.settings, IKey.lang((String)"metamorph.gui.editor.settings"), MMIcons.PROPERTIES);
        this.prepend((IGuiElement)this.renderer);
        this.add((IGuiElement)this.finish);
        this.keys().register(IKey.lang((String)"metamorph.gui.editor.keys.cycle"), 15, this::cycle).category(KEY_CATEGORY);
    }

    protected void cycle() {
        int index = -1;
        for (int i = 0; i < this.panels.size(); ++i) {
            if (this.view.delegate != this.panels.get(i)) continue;
            index = i;
            break;
        }
        index += GuiScreen.func_146272_n() ? 1 : -1;
        index = MathUtils.cycler((int)index, (int)0, (int)(this.panels.size() - 1));
        ((GuiIconElement)this.buttons.elements.get(index)).clickItself(GuiBase.getCurrent());
    }

    protected GuiModelRenderer createMorphRenderer(Minecraft mc) {
        return new GuiMorphRenderer(mc);
    }

    public void setMorphs(GuiCreativeMorphsList morphs) {
        this.morphs = morphs;
    }

    public void setPanel(GuiMorphPanel panel) {
        if (this.view.delegate != null) {
            ((GuiMorphPanel)this.view.delegate).finishEditing();
        }
        super.setPanel((GuiElement)panel);
        panel.startEditing();
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph != null;
    }

    public void startEdit(T morph) {
        this.morph = morph;
        this.setupRenderer(morph);
        for (GuiMorphPanel panel : this.panels) {
            panel.fillData(morph);
        }
        this.setPanel(this.defaultPanel);
    }

    protected void setupRenderer(T morph) {
        this.renderer.reset();
        if (this.renderer instanceof GuiMorphRenderer) {
            ((GuiMorphRenderer)this.renderer).morph = morph;
        }
    }

    public void finishEdit() {
        if (this.view.delegate != null) {
            ((GuiMorphPanel)this.view.delegate).finishEditing();
        }
    }

    public List<Label<NBTTagCompound>> getPresets(T morph) {
        return Collections.emptyList();
    }

    protected void addPreset(AbstractMorph morph, List<Label<NBTTagCompound>> list, String label, String json) {
        try {
            this.addPreset(morph, list, label, JsonToNBT.func_180713_a((String)json));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addPreset(AbstractMorph morph, List<Label<NBTTagCompound>> list, String label, NBTTagCompound tag) {
        NBTTagCompound morphTag = morph.toNBT();
        morphTag.func_179237_a(tag);
        list.add((Label<NBTTagCompound>)new Label(IKey.str((String)label), (Object)morphTag));
    }

    public List<GuiElement> getFields(Minecraft mc, GuiCreativeMorphsList morphs, T morph) {
        ArrayList<GuiElement> elements = new ArrayList<GuiElement>();
        GuiTextElement displayName = new GuiTextElement(mc, name -> {
            morphs.getSelected().displayName = name;
            morphs.markDirty();
        });
        displayName.setText(((AbstractMorph)morph).displayName);
        elements.add((GuiElement)Elements.label((IKey)IKey.lang((String)"metamorph.gui.editor.display_name")));
        elements.add((GuiElement)displayName);
        return elements;
    }

    public GuiIconElement registerPanel(GuiMorphPanel panel, IKey tooltip, Icon icon) {
        GuiIconElement button = super.registerPanel((GuiElement)panel, tooltip, icon);
        if (panel instanceof GuiBodyPartEditor) {
            this.registerKeybind(button, IKey.lang((String)"metamorph.gui.body_parts.open"), 48).category(KEY_CATEGORY);
        }
        return button;
    }

    protected void drawBackground(GuiContext context, int x, int y, int w, int h) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-301989888);
    }

    public void fromNBT(NBTTagCompound tag) {
        this.renderer.setPosition(tag.func_74760_g("MX"), tag.func_74760_g("MY"), tag.func_74760_g("MZ"));
        this.renderer.setScale(tag.func_74760_g("MS"));
        this.renderer.setRotation(tag.func_74760_g("MRY"), tag.func_74760_g("MRX"));
        int hash = tag.func_74762_e("PanelHash");
        for (GuiMorphPanel panel : this.panels) {
            if (((Object)((Object)panel)).hashCode() != hash) continue;
            this.setPanel(panel);
            panel.fromNBT(tag.func_74775_l("Panel"));
            return;
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("MX", this.renderer.pos.x);
        tag.func_74776_a("MY", this.renderer.pos.y);
        tag.func_74776_a("MZ", this.renderer.pos.z);
        tag.func_74776_a("MS", this.renderer.scale);
        tag.func_74776_a("MRX", this.renderer.pitch);
        tag.func_74776_a("MRY", this.renderer.yaw);
        tag.func_74782_a("Panel", (NBTBase)((GuiMorphPanel)this.view.delegate).toNBT());
        tag.func_74768_a("PanelHash", ((Object)((Object)((GuiMorphPanel)this.view.delegate))).hashCode());
        return tag;
    }
}

