/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.overlays;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;

public class GuiOverlay
extends Gui {
    public List<AcquiredMorph> morphs = new ArrayList<AcquiredMorph>();
    public final int cap = 60;

    public void render(int width, int height) {
        if (this.morphs.size() == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        Iterator<AcquiredMorph> iterator = this.morphs.iterator();
        while (iterator.hasNext()) {
            int n;
            AcquiredMorph morph = iterator.next();
            String string = I18n.func_135052_a((String)"metamorph.gui.acquired", (Object[])new Object[0]);
            boolean disappear = morph.timer <= this.cap;
            int progress = this.cap - morph.timer;
            int alpha = 255 * morph.timer / this.cap;
            if (disappear) {
                float f = 40.0f * (float)progress;
                ((Object)((Object)this)).getClass();
                n = (int)(f / 60.0f);
            } else {
                n = 0;
            }
            int y = height - 10 + n;
            int color = disappear ? 0xFFFFFF + (alpha << 24) : -1;
            MorphUtils.renderOnScreen(morph.morph, (EntityPlayer)mc.field_71439_g, 15, y, 15.0f, (float)alpha / 255.0f);
            font.func_78276_b(string, 30, y - 7, color);
            --morph.timer;
            if (morph.timer > 0) continue;
            iterator.remove();
        }
    }

    public void add(AbstractMorph acquired) {
        for (AcquiredMorph morph : this.morphs) {
            if (morph.timer <= this.cap) continue;
            morph.timer = this.cap;
        }
        this.morphs.add(new AcquiredMorph(acquired));
    }

    public static class AcquiredMorph {
        public AbstractMorph morph;
        public int timer = 240;

        public AcquiredMorph(AbstractMorph morph) {
            this.morph = morph;
        }
    }
}

