/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.entity;

import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.util.ObfuscatedName;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SoundHandler {
    public static final ObfuscatedName GET_HURT_SOUND = new ObfuscatedName("func_184601_bQ");
    public static final ObfuscatedName GET_DEATH_SOUND = new ObfuscatedName("func_184615_bR");
    public static final ObfuscatedName PLAY_STEP_SOUND = new ObfuscatedName("func_180429_a");
    public static final DamageSource GENERIC_DAMAGE = DamageSource.field_76377_j;
    public static final SoundEvent NO_SOUND = new SoundEvent(new ResourceLocation("metamorph", "no_sound"));

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerHurt(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        IMorphing morphing = Morphing.get((EntityPlayer)entity);
        if (morphing == null) {
            return;
        }
        morphing.setLastDamageSource(event.getSource());
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundAtEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        IMorphing morphing = Morphing.get(player);
        if (morphing == null) {
            return;
        }
        AbstractMorph morph = morphing.getCurrentMorph();
        if (morph == null) {
            return;
        }
        SoundEvent sound = event.getSound();
        if (sound == null) {
            return;
        }
        ResourceLocation soundResource = sound.getRegistryName();
        if (soundResource == null) {
            return;
        }
        String soundType = soundResource.func_110623_a();
        if (soundType.endsWith(".hurt")) {
            SoundEvent newSound = morph.getHurtSound((EntityLivingBase)player, morphing.getLastDamageSource());
            if (newSound == NO_SOUND) {
                event.setCanceled(true);
            } else if (newSound != null) {
                event.setSound(newSound);
            }
        } else if (soundType.endsWith(".death")) {
            SoundEvent newSound = morph.getDeathSound((EntityLivingBase)player);
            if (newSound == NO_SOUND) {
                event.setCanceled(true);
            } else if (newSound != null) {
                event.setSound(newSound);
            }
        } else if (soundType.endsWith(".step")) {
            if (player.field_70130_N != morph.getWidth((EntityLivingBase)player) || player.field_70131_O != morph.getHeight((EntityLivingBase)player)) {
                event.setCanceled(true);
            } else if (morph.hasCustomStepSound((EntityLivingBase)player)) {
                event.setCanceled(true);
                morph.playStepSound((EntityLivingBase)player);
            }
        }
    }
}

