/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib;

import java.util.Map;
import mchorse.mclib.CommonProxy;
import mchorse.mclib.client.gui.utils.ValueColors;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.commands.CommandCheats;
import mchorse.mclib.commands.CommandMcLib;
import mchorse.mclib.commands.utils.L10n;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueRL;
import mchorse.mclib.events.RegisterConfigEvent;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.math.Operation;
import mchorse.mclib.math.Operator;
import mchorse.mclib.math.Variable;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
@Mod(modid="mclib", name="McLib", version="2.3.6", updateJSON="https://raw.githubusercontent.com/mchorse/mclib/1.12/version.json", acceptedMinecraftVersions="[1.12.2]")
public class McLib {
    public static final String MOD_ID = "mclib";
    public static final String VERSION = "2.3.6";
    public static final String CLIENT_PROXY = "mchorse.mclib.ClientProxy";
    public static final String SERVER_PROXY = "mchorse.mclib.CommonProxy";
    @SidedProxy(clientSide="mchorse.mclib.ClientProxy", serverSide="mchorse.mclib.CommonProxy")
    public static CommonProxy proxy;
    public static final EventBus EVENT_BUS;
    public static L10n l10n;
    public static ValueBoolean opDropItems;
    public static ValueBoolean debugPanel;
    public static ValueColors favoriteColors;
    public static ValueInt primaryColor;
    public static ValueBoolean enableBorders;
    public static ValueBoolean enableCheckboxRendering;
    public static ValueBoolean enableTrackpadIncrements;
    public static ValueBoolean enableGridRendering;
    public static ValueInt userIntefaceScale;
    public static ValueInt tooltipStyle;
    public static ValueInt trackpadDecimalPlaces;
    public static ValueBoolean enableCursorRendering;
    public static ValueBoolean enableMouseButtonRendering;
    public static ValueBoolean enableKeystrokeRendering;
    public static ValueInt keystrokeOffset;
    public static ValueInt keystrokeMode;
    public static ValueRL backgroundImage;
    public static ValueInt backgroundColor;
    public static ValueBoolean scrollbarFlat;
    public static ValueInt scrollbarShadow;
    public static ValueInt scrollbarWidth;
    public static ValueBoolean multiskinMultiThreaded;
    public static ValueBoolean multiskinClear;
    public static ValueInt maxPacketSize;

    @SubscribeEvent
    public void onConfigRegister(RegisterConfigEvent event) {
        opDropItems = event.opAccess.category(MOD_ID).getBoolean("drop_items", true);
        ConfigBuilder builder = event.createBuilder(MOD_ID);
        debugPanel = builder.category("appearance").getBoolean("debug_panel", false);
        debugPanel.invisible();
        primaryColor = builder.getInt("primary_color", 35071).color();
        enableBorders = builder.getBoolean("enable_borders", false);
        enableCheckboxRendering = builder.getBoolean("enable_checkbox_rendering", false);
        enableTrackpadIncrements = builder.getBoolean("enable_trackpad_increments", true);
        trackpadDecimalPlaces = builder.getInt("trackpad_decimal_places", 6, 3, 31);
        enableGridRendering = builder.getBoolean("enable_grid_rendering", true);
        userIntefaceScale = builder.getInt("user_interface_scale", 2, 0, 4);
        tooltipStyle = builder.getInt("tooltip_style", 1).modes(IKey.lang("mclib.tooltip_style.light"), IKey.lang("mclib.tooltip_style.dark"));
        favoriteColors = new ValueColors("favorite_colors");
        builder.register(favoriteColors);
        builder.getCategory().markClientSide();
        enableCursorRendering = builder.category("tutorials").getBoolean("enable_mouse_rendering", false);
        enableMouseButtonRendering = builder.getBoolean("enable_mouse_buttons_rendering", false);
        enableKeystrokeRendering = builder.getBoolean("enable_keystrokes_rendering", false);
        keystrokeOffset = builder.getInt("keystroke_offset", 10, 0, 20);
        keystrokeMode = builder.getInt("keystroke_position", 1).modes(IKey.lang("mclib.keystrokes_position.auto"), IKey.lang("mclib.keystrokes_position.bottom_left"), IKey.lang("mclib.keystrokes_position.bottom_right"), IKey.lang("mclib.keystrokes_position.top_right"), IKey.lang("mclib.keystrokes_position.top_left"));
        builder.getCategory().markClientSide();
        backgroundImage = builder.category("background").getRL("image", null);
        backgroundColor = builder.getInt("color", -872415232).colorAlpha();
        builder.getCategory().markClientSide();
        scrollbarFlat = builder.category("scrollbars").getBoolean("flat", false);
        scrollbarShadow = builder.getInt("shadow", -2013265920).colorAlpha();
        scrollbarWidth = builder.getInt("width", 4, 2, 10);
        builder.getCategory().markClientSide();
        multiskinMultiThreaded = builder.category("multiskin").getBoolean("multithreaded", true);
        multiskinClear = builder.getBoolean("clear", true);
        builder.getCategory().markClientSide();
        maxPacketSize = builder.category("vanilla").getInt("max_packet_size", Short.MAX_VALUE, Short.MAX_VALUE, Integer.MAX_VALUE);
        maxPacketSize.syncable();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @NetworkCheckHandler
    public boolean checkModDependencies(Map<String, String> map, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartingEvent event) {
        if (event.getServer().func_71264_H()) {
            event.registerServerCommand((ICommand)new CommandCheats());
        } else {
            event.registerServerCommand((ICommand)new CommandMcLib());
        }
    }

    public static void main(String[] args) throws Exception {
        Operator.DEBUG = true;
        MathBuilder builder = new MathBuilder();
        McLib.test(builder, "1 - 2 * 3 + 4 ", -1.0);
        McLib.test(builder, "2 * 3 - 8 + 7 ", 5.0);
        McLib.test(builder, "3 - 7 + 2 * 4 ", 4.0);
        McLib.test(builder, "8 / 4 - 3 * 10", -28.0);
        McLib.test(builder, "2 - 4 * 5 / 8 ", -0.5);
        McLib.test(builder, "3 / 4 * 8 - 10", -4.0);
        McLib.test(builder, "2 * 3 / 4 * 5 ", 7.5);
        McLib.test(builder, "2 + 3 - 4 + 5 ", 6.0);
        McLib.test(builder, "7 - 2 ^ 4 - 4 * 5 + 15 ^ 2", 7.0 - Math.pow(2.0, 4.0) - 20.0 + Math.pow(15.0, 2.0));
        McLib.test(builder, "5 -(10 + 20)", -25.0);
        McLib.test(builder, "1 << 4 - 1", 8.0);
        McLib.test(builder, "256 >> 4 + 2", 4.0);
        McLib.test(builder, "255 & 7 + 1", 8.0);
        McLib.test(builder, "256 | 7 + 1", 264.0);
        McLib.test(builder, "5 % 2 + 1 == 0 * 2", 0.0);
        builder.variables.put("abc", new Variable("abc", 1.0));
        IValue test = builder.parse("- (40 + 2) / -2");
        System.out.println(test.isNumber() + " " + test.stringValue() + " " + test.booleanValue() + " " + test.doubleValue());
    }

    public static void test(MathBuilder builder, String expression, double result) throws Exception {
        IValue value = builder.parse(expression);
        System.out.println(expression + " = " + value.get() + " (" + result + ") is " + Operation.equals(value.get().doubleValue(), result));
        System.out.println(value.toString() + "\n");
    }

    static {
        EVENT_BUS = new EventBus();
        l10n = new L10n(MOD_ID);
    }
}

