/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public abstract class GuiModelRenderer
extends GuiElement {
    private static boolean rendering;
    private static Vector3d vec;
    private static Matrix3d mat;
    protected EntityLivingBase entity;
    protected IBlockState block = Blocks.field_150349_c.func_176223_P();
    protected int timer;
    protected boolean dragging;
    protected boolean position;
    protected Vector3f temp = new Vector3f();
    public float fov = 70.0f;
    public float scale;
    public float yaw;
    public float pitch;
    public Vector3f pos = new Vector3f();
    protected float lastX;
    protected float lastY;
    protected boolean tryPicking;
    protected Consumer<String> callback;
    private long tick;

    public static boolean isRendering() {
        return rendering;
    }

    public static void disableRenderingFlag() {
        rendering = false;
    }

    public GuiModelRenderer(Minecraft mc) {
        super(mc);
        this.entity = new DummyEntity((World)mc.field_71441_e);
        this.entity.field_70126_B = 0.0f;
        this.entity.field_70177_z = 0.0f;
        this.entity.field_70127_C = 0.0f;
        this.entity.field_70125_A = 0.0f;
        this.entity.field_70758_at = 0.0f;
        this.entity.field_70759_as = 0.0f;
        this.entity.field_70760_ar = 0.0f;
        this.entity.field_70761_aq = 0.0f;
        this.entity.field_70122_E = true;
        this.reset();
    }

    public GuiModelRenderer picker(Consumer<String> callback) {
        this.callback = callback;
        return this;
    }

    public void setRotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setPosition(float x, float y, float z) {
        this.pos.set(x, y, z);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public void reset() {
        this.yaw = 0.0f;
        this.pitch = 0.0f;
        this.scale = 2.0f;
        this.pos = new Vector3f(0.0f, 1.0f, 0.0f);
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (this.area.isInside(context) && (context.mouseButton == 0 || context.mouseButton == 2)) {
            this.dragging = true;
            this.position = GuiScreen.func_146272_n() || context.mouseButton == 2;
            this.lastX = context.mouseX;
            this.lastY = context.mouseY;
            if (GuiScreen.func_146271_m()) {
                this.tryPicking = true;
                this.dragging = false;
            }
        }
        return this.area.isInside(context);
    }

    @Override
    public boolean mouseScrolled(GuiContext context) {
        if (super.mouseScrolled(context)) {
            return true;
        }
        if (this.area.isInside(context)) {
            this.scale += Math.copySign(this.getZoomFactor(), context.mouseWheel);
            this.scale = MathUtils.clamp(this.scale, 0.0f, 100.0f);
        }
        return this.area.isInside(context);
    }

    protected float getZoomFactor() {
        if (this.scale < 1.0f) {
            return 0.05f;
        }
        if (this.scale > 30.0f) {
            return 5.0f;
        }
        if (this.scale > 10.0f) {
            return 1.0f;
        }
        if (this.scale > 3.0f) {
            return 0.5f;
        }
        return 0.1f;
    }

    @Override
    public void mouseReleased(GuiContext context) {
        this.dragging = false;
        this.tryPicking = false;
        super.mouseReleased(context);
    }

    @Override
    public void draw(GuiContext context) {
        this.updateLogic(context);
        rendering = true;
        GuiDraw.scissor(this.area.x, this.area.y, this.area.w, this.area.h, context);
        this.drawModel(context);
        GuiDraw.unscissor(context);
        rendering = false;
        super.draw(context);
    }

    private void updateLogic(GuiContext context) {
        long i = context.tick - this.tick;
        if (i > 10L) {
            i = 10L;
        }
        while (i > 0L) {
            this.update();
            --i;
        }
        this.tick = context.tick;
    }

    protected void update() {
        this.entity.field_70173_aa = this.timer = this.mc.field_71439_g != null ? this.mc.field_71439_g.field_70173_aa : this.timer + 1;
    }

    private void drawModel(GuiContext context) {
        this.setupViewport(context);
        this.setupPosition(context);
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179114_b((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-this.temp.x), (float)(-this.temp.y), (float)(-this.temp.z));
        this.drawGround();
        this.drawUserModel(context);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179097_i();
        GlStateManager.func_179101_C();
        GlStateManager.func_179118_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)context.screen.field_146294_l, (double)context.screen.field_146295_m, (double)0.0, (double)1000.0, (double)3000000.0);
        GlStateManager.func_179128_n((int)5888);
    }

    protected void setupPosition(GuiContext context) {
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.dragging) {
            if (this.position) {
                float x = this.pos.x;
                float y = this.pos.y;
                float z = this.pos.z;
                double xx = -(this.lastX - (float)mouseX) / 60.0f;
                double yy = -(this.lastY - (float)mouseY) / 60.0f;
                float factor = this.getZoomFactor();
                if ((xx *= (double)(factor / 0.1f)) != 0.0 || (yy *= (double)(factor / 0.1f)) != 0.0) {
                    vec.set(xx, yy, 0.0);
                    this.rotateVector(vec);
                    x = (float)((double)x + GuiModelRenderer.vec.x);
                    y = (float)((double)y + GuiModelRenderer.vec.y);
                    z = (float)((double)z + GuiModelRenderer.vec.z);
                    this.pos.set(x, y, z);
                }
            } else {
                this.yaw -= this.lastX - (float)mouseX;
                this.pitch -= this.lastY - (float)mouseY;
            }
            this.lastX = mouseX;
            this.lastY = mouseY;
        }
        this.temp = new Vector3f(this.pos);
        vec.set(0.0, 0.0, (double)(-this.scale));
        this.rotateVector(vec);
        this.temp.x = (float)((double)this.temp.x + GuiModelRenderer.vec.x);
        this.temp.y = (float)((double)this.temp.y + GuiModelRenderer.vec.y);
        this.temp.z = (float)((double)this.temp.z + GuiModelRenderer.vec.z);
    }

    private void rotateVector(Vector3d vec) {
        mat.rotX((double)(this.pitch / 180.0f * (float)Math.PI));
        mat.transform((Tuple3d)vec);
        mat.rotY((double)((180.0f - this.yaw) / 180.0f * (float)Math.PI));
        mat.transform((Tuple3d)vec);
    }

    protected void setupViewport(GuiContext context) {
        GlStateManager.func_179086_m((int)256);
        float rx = (float)Math.ceil((double)this.mc.field_71443_c / (double)context.screen.field_146294_l);
        float ry = (float)Math.ceil((double)this.mc.field_71440_d / (double)context.screen.field_146295_m);
        int vx = (int)((float)this.area.x * rx);
        int vy = (int)((float)this.mc.field_71440_d - (float)(this.area.y + this.area.h) * ry);
        int vw = (int)((float)this.area.w * rx);
        int vh = (int)((float)this.area.h * ry);
        GlStateManager.func_179083_b((int)vx, (int)vy, (int)vw, (int)vh);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)this.fov, (float)((float)vw / (float)vh), (float)0.05f, (float)1000.0f);
        GlStateManager.func_179128_n((int)5888);
    }

    protected abstract void drawUserModel(GuiContext var1);

    protected void tryPicking(GuiContext context) {
        byte value;
        if (!this.tryPicking) {
            return;
        }
        float rx = (float)Math.ceil((double)this.mc.field_71443_c / (double)context.screen.field_146294_l);
        float ry = (float)Math.ceil((double)this.mc.field_71440_d / (double)context.screen.field_146295_m);
        int x = (int)((float)context.mouseX * rx);
        int y = (int)((float)this.mc.field_71440_d - (float)context.mouseY * ry);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glEnable((int)2960);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.drawForStencil(context);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1);
        GL11.glReadPixels((int)x, (int)y, (int)1, (int)1, (int)6401, (int)5121, (ByteBuffer)buffer);
        buffer.rewind();
        if (this.callback != null && (value = buffer.get()) > 0) {
            this.callback.accept(this.getStencilValue(value));
        }
        this.tryPicking = false;
    }

    protected void drawForStencil(GuiContext context) {
    }

    protected String getStencilValue(int value) {
        return null;
    }

    protected void drawGround() {
        if (McLib.enableGridRendering.get()) {
            int x;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GL11.glLineWidth((float)3.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (x = 0; x <= 10; ++x) {
                if (x == 0) {
                    buffer.func_181662_b((double)(x - 5), 0.0, -5.0).func_181666_a(0.0f, 0.0f, 1.0f, 0.75f).func_181675_d();
                    buffer.func_181662_b((double)(x - 5), 0.0, 5.0).func_181666_a(0.0f, 0.0f, 1.0f, 0.75f).func_181675_d();
                    continue;
                }
                buffer.func_181662_b((double)(x - 5), 0.0, -5.0).func_181666_a(0.25f, 0.25f, 0.25f, 0.75f).func_181675_d();
                buffer.func_181662_b((double)(x - 5), 0.0, 5.0).func_181666_a(0.25f, 0.25f, 0.25f, 0.75f).func_181675_d();
            }
            for (x = 0; x <= 10; ++x) {
                if (x == 10) {
                    buffer.func_181662_b(-5.0, 0.0, (double)(x - 5)).func_181666_a(1.0f, 0.0f, 0.0f, 0.75f).func_181675_d();
                    buffer.func_181662_b(5.0, 0.0, (double)(x - 5)).func_181666_a(1.0f, 0.0f, 0.0f, 0.75f).func_181675_d();
                    continue;
                }
                buffer.func_181662_b(-5.0, 0.0, (double)(x - 5)).func_181666_a(0.25f, 0.25f, 0.25f, 0.75f).func_181675_d();
                buffer.func_181662_b(5.0, 0.0, (double)(x - 5)).func_181666_a(0.25f, 0.25f, 0.25f, 0.75f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        } else {
            BlockRendererDispatcher renderer = this.mc.func_175602_ab();
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
            renderer.func_175016_a(this.block, 1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    static {
        vec = new Vector3d();
        mat = new Matrix3d();
    }
}

