/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.modals;

import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.Timer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class GuiPopUpModal
extends GuiModal {
    private Color backgroundColorDefault = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color textColorDefault = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private float shadowAlphaDefault = 0.26666668f;
    private float alphaDefault = 1.0f;
    private boolean init = false;
    private int x0;
    private int y0;
    private Timer timer;
    private float shadowAlpha;
    private float textAlpha;
    private float backgroundAlpha;
    private Color shadowColor;
    private Color backgroundColor;
    private Color textColor;
    private int duration = 350;

    public GuiPopUpModal(Minecraft mc, IKey label) {
        super(mc, label);
        this.defaultColors();
    }

    public void setFadeDuration(int duration) {
        if (this.timer == null) {
            this.duration = duration;
        }
    }

    @Override
    public void draw(GuiContext context) {
        if (!this.init) {
            this.x0 = context.mouseX() - this.area.w / 4;
            this.y0 = context.mouseY() - this.area.h / 2;
            this.init = true;
        }
        this.area.x = this.x0;
        this.area.y = this.y0;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        int shadowAlpha = (int)(this.shadowAlpha * 255.0f) << 24;
        int textAlpha = (int)(this.textAlpha * 255.0f) << 24;
        int backgroundAlpha = (int)(this.backgroundAlpha * 255.0f) << 24;
        GuiDraw.drawDropShadow(this.area.x, this.area.y, this.area.ex(), this.area.ey(), 6, shadowAlpha + this.shadowColor.getRGBColor(), this.shadowColor.getRGBColor());
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)(backgroundAlpha + this.backgroundColor.getRGBAColor()));
        this.y = 0;
        for (String line : this.font.func_78271_c(this.label.get(), this.area.w - 20)) {
            this.font.func_175063_a(line, (float)(this.area.x + 10), (float)(this.area.y + 10 + this.y), textAlpha + this.textColor.getRGBAColor());
            this.y += 11;
        }
        if (!this.area.isInside(context)) {
            if (this.timer == null) {
                this.timer = new Timer(this.duration);
                this.timer.mark();
            }
            float x = ((float)this.duration - (float)this.timer.getRemaining()) / (float)this.duration;
            this.backgroundAlpha = this.fadeAlpha(this.alphaDefault, 0.0f, x);
            this.textAlpha = this.fadeAlpha(this.alphaDefault, 0.0f, x);
            this.shadowAlpha = this.fadeAlpha(this.shadowAlphaDefault, 0.0f, MathUtils.clamp(x * 1.7f, 0.0f, 1.0f));
            if (this.timer.check()) {
                context.postRenderCallbacks.add(c -> this.removeFromParent());
            }
        } else if (this.timer != null && !this.timer.check()) {
            this.timer = null;
            this.defaultColors();
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void defaultColors() {
        this.shadowAlpha = this.shadowAlphaDefault;
        this.textAlpha = this.alphaDefault;
        this.backgroundAlpha = this.alphaDefault;
        this.shadowColor = new Color(McLib.primaryColor.get());
        this.backgroundColor = this.backgroundColorDefault.copy();
        this.textColor = this.textColorDefault.copy();
    }

    private float fadeAlpha(float a, float b, float x) {
        return Interpolations.lerp(a, b, x);
    }
}

