/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiCanvas;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public abstract class GuiCanvasEditor
extends GuiCanvas {
    private static Area processed = new Area();
    public GuiElement editor;
    protected int w;
    protected int h;

    public GuiCanvasEditor(Minecraft mc) {
        super(mc);
        this.editor = new GuiElement(mc);
        this.editor.flex().relative(this).xy(1.0f, 1.0f).w(130).anchor(1.0f, 1.0f).column(5).stretch().vertical().padding(10);
        this.add((IGuiElement)this.editor);
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void setSize(int w, int h) {
        this.w = w;
        this.h = h;
        this.scaleX.set(0.0, 2.0);
        this.scaleY.set(0.0, 2.0);
        this.scaleX.viewOffset(-this.w / 2, this.w / 2, 20.0);
        this.scaleY.viewOffset(-this.h / 2, this.h / 2, 20.0);
        double min = Math.min(this.scaleX.getZoom(), this.scaleY.getZoom());
        this.scaleX.setZoom(min);
        this.scaleY.setZoom(min);
    }

    @Override
    protected void drawCanvas(GuiContext context) {
        this.drawBackground(context);
        Area area = this.calculate(-this.w / 2, -this.h / 2, this.w / 2, this.h / 2);
        Gui.func_73734_a((int)(area.x - 1), (int)(area.y - 1), (int)(area.ex() + 1), (int)(area.ey() + 1), (int)-15198184);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.shouldDrawCanvas(context)) {
            return;
        }
        GuiDraw.scissor(area.x, area.y, area.w, area.h, context);
        int ox = (this.area.x - area.x) % 16;
        int oy = (this.area.y - area.y) % 16;
        processed.copy(this.area);
        processed.offsetX(ox < 0 ? 16 + ox : ox);
        processed.offsetY(oy < 0 ? 16 + oy : oy);
        processed.clamp(area);
        Icons.CHECKBOARD.renderArea(area.x, area.y, area.w, area.h);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawCanvasFrame(context);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GuiDraw.unscissor(context);
    }

    protected void drawBackground(GuiContext context) {
        this.area.draw(-13684945);
    }

    protected abstract void drawCanvasFrame(GuiContext var1);

    protected boolean shouldDrawCanvas(GuiContext context) {
        return true;
    }

    protected Area calculateRelative(int a, int b, int c, int d) {
        return this.calculate(-this.w / 2 + a, -this.h / 2 + b, -this.w / 2 + c, -this.h / 2 + d);
    }

    protected Area calculate(int ix1, int iy1, int ix2, int iy2) {
        int x1 = this.toX(ix1);
        int y1 = this.toY(iy1);
        int x2 = this.toX(ix2);
        int y2 = this.toY(iy2);
        int x = x1;
        int y = y1;
        int fw = x2 - x;
        int fh = y2 - y;
        Area.SHARED.set(x, y, fw, fh);
        return Area.SHARED;
    }
}

