/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils.keys;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mchorse.mclib.client.gui.utils.keys.CompoundKey;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.keys.LangKey;
import mchorse.mclib.client.gui.utils.keys.StringKey;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class KeyParser {
    public static IKey keyFromBytes(ByteBuf buffer) {
        byte type = buffer.readByte();
        if (type == 0) {
            return IKey.str(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        }
        if (type == 1) {
            String key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            ArrayList<Object> args = new ArrayList<Object>();
            int c = buffer.readInt();
            for (int i = 0; i < c; ++i) {
                byte argType = buffer.readByte();
                if (argType == 0) {
                    args.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                    continue;
                }
                if (argType != 1) continue;
                args.add(KeyParser.keyFromBytes(buffer));
            }
            return args.isEmpty() ? IKey.lang(key) : IKey.format(key, args.toArray(new Object[args.size()]));
        }
        if (type == 2) {
            ArrayList<IKey> keys = new ArrayList<IKey>();
            int c = buffer.readInt();
            for (int i = 0; i < c; ++i) {
                IKey key = KeyParser.keyFromBytes(buffer);
                if (key == null) continue;
                keys.add(key);
            }
            return IKey.comp(keys.toArray(new IKey[keys.size()]));
        }
        return null;
    }

    public static void keyToBytes(ByteBuf buffer, IKey key) {
        if (key instanceof StringKey) {
            buffer.writeByte(0);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((StringKey)key).string);
        } else if (key instanceof LangKey) {
            LangKey lang = (LangKey)key;
            buffer.writeByte(1);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)lang.key);
            buffer.writeInt(lang.args.length);
            for (Object arg : lang.args) {
                if (arg instanceof String) {
                    buffer.writeByte(0);
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)arg));
                    continue;
                }
                if (arg instanceof IKey) {
                    buffer.writeByte(1);
                    KeyParser.keyToBytes(buffer, (IKey)arg);
                    continue;
                }
                buffer.writeByte(0);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)arg.toString());
            }
        } else if (key instanceof CompoundKey) {
            CompoundKey compound = (CompoundKey)key;
            buffer.writeByte(2);
            buffer.writeInt(compound.keys.length);
            for (IKey childKey : compound.keys) {
                KeyParser.keyToBytes(buffer, childKey);
            }
        } else {
            buffer.writeByte(100);
        }
    }
}

