/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils.resizers.layout;

import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.resizers.AutomaticResizer;
import mchorse.mclib.client.gui.utils.resizers.ChildResizer;
import mchorse.mclib.client.gui.utils.resizers.IResizer;

public class RowResizer
extends AutomaticResizer {
    private int i;
    private int x;
    private int w;
    private int count;
    private int preferred = -1;
    private int width;
    private boolean resize;
    private boolean reverse;

    public static RowResizer apply(GuiElement element, int margin) {
        RowResizer resizer = new RowResizer(element, margin);
        element.flex().post(resizer);
        return resizer;
    }

    protected RowResizer(GuiElement parent, int margin) {
        super(parent, margin);
    }

    public RowResizer preferred(int index) {
        this.preferred = this.i;
        return this;
    }

    public RowResizer width(int width) {
        this.width = width;
        return this;
    }

    public RowResizer resize() {
        this.resize = true;
        return this;
    }

    public RowResizer reverse() {
        this.reverse = true;
        return this;
    }

    @Override
    public void apply(Area area) {
        List<ChildResizer> resizers = this.getResizers();
        this.w = 0;
        this.x = 0;
        this.i = 0;
        this.count = resizers.size();
        for (ChildResizer resizer : resizers) {
            int w = Math.max(resizer.resizer == null ? 0 : resizer.resizer.getW(), 0);
            if (w <= 0) continue;
            this.w += w;
            --this.count;
        }
    }

    @Override
    public void apply(Area area, IResizer resizer, ChildResizer child) {
        int diff;
        int preferred;
        int ch;
        List<ChildResizer> resizers = this.getResizers();
        int c = resizers.size();
        int original = this.parent.area.w - this.padding * 2 - this.margin * (c - 1);
        int w = this.count > 0 ? (original - this.w) / this.count : 0;
        int x = this.parent.area.x + this.padding + this.x + child.element.margin.left;
        if (this.reverse) {
            x = this.parent.area.ex() - this.padding - this.x - child.element.margin.right;
        }
        int cw = resizer == null ? 0 : resizer.getW();
        int n = ch = resizer == null ? this.height : resizer.getH();
        if (this.width > 0) {
            cw = this.width;
        }
        cw = cw > 0 ? cw : w;
        int n2 = preferred = this.preferred == -1 ? c / 2 : this.preferred;
        if (this.i == preferred && !this.resize && this.width <= 0 && (diff = original - this.w - w * this.count) > 0) {
            cw += diff;
        }
        if (this.reverse) {
            x -= cw;
        }
        area.set(x, this.parent.area.y + this.padding + child.element.margin.top, cw, ch > 0 ? ch : this.parent.area.h - this.padding * 2);
        this.x += cw + this.margin + child.element.margin.horizontal();
        ++this.i;
    }

    @Override
    public int getW() {
        if (this.resize) {
            List<ChildResizer> resizers = this.getResizers();
            int w = resizers.isEmpty() ? 0 : -this.margin;
            for (ChildResizer resizer : resizers) {
                int cw;
                int n = cw = resizer.resizer == null ? 0 : resizer.resizer.getW();
                if (cw == 0 && this.width > 0) {
                    cw = this.width;
                }
                w += Math.max(cw, 0) + this.margin + resizer.element.margin.horizontal();
            }
            return w + this.padding * 2;
        }
        return 0;
    }

    @Override
    public int getH() {
        List<ChildResizer> resizers = this.getResizers();
        int h = 0;
        for (ChildResizer child : resizers) {
            h = Math.max(h, child.resizer == null ? 0 : child.resizer.getH() + child.element.margin.vertical());
        }
        if (h == 0) {
            h = this.height;
        }
        return h + this.padding * 2;
    }
}

