/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.utils.ValueColors;
import mchorse.mclib.config.Config;
import mchorse.mclib.config.json.ConfigParser;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueDouble;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueRL;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.events.RegisterConfigEvent;
import mchorse.mclib.network.mclib.Dispatcher;
import mchorse.mclib.network.mclib.common.PacketConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ConfigManager {
    public static final BiMap<String, Class<? extends Value>> TYPES = HashBiMap.create();
    public final Map<String, Config> modules = new HashMap<String, Config>();

    public static void synchronizeConfig(Config config, MinecraftServer server) {
        ConfigManager.synchronizeConfig(config, server, null);
    }

    public static void synchronizeConfig(Config config, MinecraftServer server, EntityPlayer exception) {
        for (EntityPlayerMP target : server.func_184103_al().func_181057_v()) {
            if (target == exception) continue;
            Dispatcher.sendTo(new PacketConfig(config, true), target);
        }
    }

    public static Value fromBytes(ByteBuf buffer) {
        String key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        String type = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (type.isEmpty()) {
            return null;
        }
        try {
            Class clazz = (Class)TYPES.get((Object)type);
            Value value = (Value)clazz.getConstructor(String.class).newInstance(key);
            value.fromBytes(buffer);
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void toBytes(ByteBuf buffer, Value value) {
        String type = (String)TYPES.inverse().get(value.getClass());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)value.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(type == null ? "" : type));
        if (type != null) {
            value.toBytes(buffer);
        }
    }

    public void register(File configs) {
        RegisterConfigEvent event = new RegisterConfigEvent(configs);
        McLib.EVENT_BUS.post((Event)event);
        Config opAccess = event.opAccess.getConfig().serverSide();
        this.modules.put(opAccess.id, opAccess);
        for (Config config : event.modules) {
            this.modules.put(config.id, config);
        }
        this.reload();
    }

    public void reload() {
        for (Config config : this.modules.values()) {
            ConfigParser.fromJson(config, config.file);
        }
    }

    public void resetServerValues() {
        for (Config config : this.modules.values()) {
            config.resetServerValues();
        }
    }

    static {
        TYPES.put((Object)"boolean", ValueBoolean.class);
        TYPES.put((Object)"double", ValueDouble.class);
        TYPES.put((Object)"float", ValueFloat.class);
        TYPES.put((Object)"int", ValueInt.class);
        TYPES.put((Object)"rl", ValueRL.class);
        TYPES.put((Object)"string", ValueString.class);
        TYPES.put((Object)"colors", ValueColors.class);
    }
}

